/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notification;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.model.Typed;
import org.traccar.notificators.Notificator;
import org.traccar.notificators.NotificatorFirebase;
import org.traccar.notificators.NotificatorMail;
import org.traccar.notificators.NotificatorNull;
import org.traccar.notificators.NotificatorSms;
import org.traccar.notificators.NotificatorTelegram;
import org.traccar.notificators.NotificatorWeb;

public final class NotificatorManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificatorManager.class);
    private static final Notificator NULL_NOTIFICATOR = new NotificatorNull();
    private final Map<String, Notificator> notificators = new HashMap<String, Notificator>();

    public NotificatorManager() {
        String[] types;
        for (String type : types = Context.getConfig().getString("notificator.types", "").split(",")) {
            String defaultNotificator = "";
            switch (type) {
                case "web": {
                    defaultNotificator = NotificatorWeb.class.getCanonicalName();
                    break;
                }
                case "mail": {
                    defaultNotificator = NotificatorMail.class.getCanonicalName();
                    break;
                }
                case "sms": {
                    defaultNotificator = NotificatorSms.class.getCanonicalName();
                    break;
                }
                case "firebase": {
                    defaultNotificator = NotificatorFirebase.class.getCanonicalName();
                    break;
                }
                case "telegram": {
                    defaultNotificator = NotificatorTelegram.class.getCanonicalName();
                    break;
                }
            }
            String className = Context.getConfig().getString("notificator." + type + ".class", defaultNotificator);
            try {
                this.notificators.put(type, (Notificator)Class.forName(className).newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOGGER.warn("Unable to load notificator class for " + type + " " + className + " " + e.getMessage());
            }
        }
    }

    public Notificator getNotificator(String type) {
        Notificator notificator = this.notificators.get(type);
        if (notificator == null) {
            LOGGER.warn("No notificator configured for type : " + type);
            return NULL_NOTIFICATOR;
        }
        return notificator;
    }

    public Set<Typed> getAllNotificatorTypes() {
        HashSet<Typed> result = new HashSet<Typed>();
        for (String notificator : this.notificators.keySet()) {
            result.add(new Typed(notificator));
        }
        return result;
    }
}

