/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import liquibase.Scope;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.util.StreamUtil;

public class LiquibaseUtil {
    private static Properties liquibaseBuildProperties;

    public static String getBuildVersion() {
        return LiquibaseUtil.getBuildInfo("build.version");
    }

    public static String getBuildTime() {
        return LiquibaseUtil.getBuildInfo("build.timestamp");
    }

    public static String getBuildNumber() {
        return LiquibaseUtil.getBuildInfo("build.number");
    }

    private static String getBuildInfo(String propertyId) {
        String value = "UNKONWN";
        if (liquibaseBuildProperties == null) {
            try (InputStream buildProperties = StreamUtil.openStream("liquibase.build.properties", false, null, new ClassLoaderResourceAccessor(LiquibaseUtil.class.getClassLoader()));){
                liquibaseBuildProperties = new Properties();
                if (buildProperties != null) {
                    liquibaseBuildProperties.load(buildProperties);
                }
            }
            catch (IOException e2) {
                Scope.getCurrentScope().getLog(LiquibaseUtil.class).severe("Cannot read liquibase.build.properties", e2);
            }
        }
        if (liquibaseBuildProperties != null) {
            value = liquibaseBuildProperties.getProperty(propertyId);
        }
        return value;
    }
}

