" Menu Translations:	Icelandic / slenska
" Maintainer:		Jn Arnar Briem <jonbriem@gmail.com>
" Originally By:	Jn Arnar Briem <jonbriem@gmail.com>
" Last Change:	Sun, 24 Mar 2019 22:40:00 CEST
" vim:set foldmethod=marker tabstop=8:

" Quit when menu translations have already been done.
if exists("did_menu_trans")
  finish
endif
let did_menu_trans = 1
let s:keepcpo= &cpo
set cpo&vim

" The translations below are in latin1, but they work for cp1252 and
" iso-8859-15 without conversion as well.
if &enc != "cp1252" && &enc != "iso-8859-15"
  scriptencoding latin1
endif

" {{{ FILE / SKR
menutrans &File				                        Skr
menutrans &Open\.\.\.<Tab>:e		                Opna\.\.\.<Tab>:e
menutrans Sp&lit-Open\.\.\.<Tab>:sp	                Splitt\ opna\.\.\.<Tab>:sp
menutrans Open\ Tab\.\.\.<Tab>:tabnew	            Opna\ flipa\.\.\.<Tab>:tabnew
menutrans &New<Tab>:enew		                    N\ Skr<Tab>:enew
menutrans &Close<Tab>:close		                    Loka<Tab>:close
menutrans &Save<Tab>:w			                    Vista<Tab>:w
menutrans Save\ &As\.\.\.<Tab>:sav	                Vista\ sem\.\.\.<Tab>:sav
menutrans &Print			                        Prenta
menutrans Sa&ve-Exit<Tab>:wqa		                Vista\ og\ Loka<Tab>:wqa
menutrans E&xit<Tab>:qa			                    Loka<Tab>:qa

if has("diff")
    menutrans Split\ &Diff\ with\.\.\.	            Splitt\ opna\ mismun\ vi\.\.\.
    menutrans Split\ Patched\ &By\.\.\.	            Splitt\ opna\ plstra\ af\.\.\.
endif
" }}} FILE / SKR

" {{{ EDIT / BREYTA
menutrans &Edit				                        Breyta
menutrans &Undo<Tab>u			                    Afturkalla<Tab>u
menutrans &Redo<Tab>^R			                    Endurkalla<Tab>^R
menutrans Rep&eat<Tab>\.		                    Endurtaka<Tab>\.
menutrans Cu&t<Tab>"+x			                    Klippa<Tab>"+x
menutrans &Copy<Tab>"+y			                    Afrita<Tab>"+y
menutrans &Paste<Tab>"+gP		                    Lma<Tab>"+gP
menutrans Put\ &Before<Tab>[p		                Lma\ Fyrir<Tab>[p
menutrans Put\ &After<Tab>]p		                Lma\ Eftir<Tab>]p
menutrans &Delete<Tab>x			                    Eya<Tab>x
menutrans &Select\ All<Tab>ggVG		                Velja\ Allt<Tab>ggVG
menutrans &Find\.\.\.			                    Finna\.\.\.
menutrans Find\ and\ Rep&lace\.\.\.	                Finna\ og\ Skipta\.\.\.

" [-- SETTINGS --]
menutrans Settings\ &Window				            Stillingar\ Glugga
menutrans &Global\ Settings				            Vvrar\ Stillingar
menutrans Startup\ &Settings				        Rsistillingar

menutrans Toggle\ Pattern\ &Highlight<Tab>:set\ hls!	    Munsturaukenning\ \/af<Tab>:set\ hls!
menutrans Toggle\ &Ignoring\ Case<Tab>:set\ ic!		        Hunsa\ h-lgstafi\ \/af<Tab>:set\ ic!
menutrans Toggle\ &Showing\ Matched\ Pairs<Tab>:set\ sm!	Sna\ Prun \/af<Tab>:set\ sm!

menutrans &Context\ lines				            Samhengislnur

menutrans &Virtual\ Edit				            Skinbreytihamur
menutrans Never						                Aldrei
menutrans Block\ Selection				            Blkval
menutrans Insert\ mode					            Innskotshamur
menutrans Block\ and\ Insert				        Blkval\ og\ Innskotshamur
menutrans Always					                Alltaf
menutrans Toggle\ Insert\ &Mode<Tab>:set\ im!		Innskotshamur\ \/af<Tab>:set\ im!
menutrans Toggle\ Vi\ C&ompatibility<Tab>:set\ cp!	Vi\ Samhfanleiki \/af<Tab>:set\ cp!

menutrans Search\ &Path\.\.\.				        Leita\ \ Sl\.\.\.
menutrans Ta&g\ Files\.\.\.				            Merkja\ Skrr\.\.\.

menutrans Toggle\ &Toolbar				            Tlabor\ \/af
menutrans Toggle\ &Bottom\ Scrollbar			    Neri\ Skrunbori\ \/af
menutrans Toggle\ &Left\ Scrollbar                  Vinstri\ Skrunbori\ \/af
menutrans Toggle\ &Right\ Scrollbar			        Hgri\ Skrunbori\ \/af

" Edit/File Settings
menutrans F&ile\ Settings				            Skrar-Stilingar

" Boolean options
menutrans Toggle\ Line\ &Numbering<Tab>:set\ nu!		Lnunmering\ \/af<Tab>:set\ nu!
menutrans Toggle\ Relati&ve\ Line\ Numbering<Tab>:set\ rnu!	Afst\ Lnunmering\ \/af<Tab>:set\ rnu!
menutrans Toggle\ &List\ Mode<Tab>:set\ list!			Listahamur\ \/af<Tab>:set\ list!
menutrans Toggle\ Line\ &Wrapping<Tab>:set\ wrap!		Lnuhlaup\ \/af<Tab>:set\ wrap!
menutrans Toggle\ W&rapping\ at\ word<Tab>:set\ lbr!	Lnuhlaup\ \ ori\ \/af<Tab>:set\ lbr!
menutrans Toggle\ Tab\ &Expanding<Tab>:set\ et!			Tab-vkkun\ \/af<Tab>:set\ et!
menutrans Toggle\ &Auto Indenting<Tab>:set\ ai!			Sjlfvirkur\ Inndrttur\ \/af<Tab>:set\ ai!
menutrans Toggle\ &C-Style\ Indenting<Tab>:set\ cin!	C-Inndrttur\ \/af<Tab>:set\ cin!

" other options
menutrans &Shiftwidth					            Shiftbreidd
menutrans Soft\ &Tabstop			                Mjk\ Tabstopp
menutrans Te&xt\ Width\.\.\.		                Textabreidd\.\.\.
menutrans &File\ Format\.\.\.		                Skrarform\.\.\.
menutrans C&olor\ Scheme			                Litaema\.\.\.
menutrans &Keymap					                Lyklaskipan
" }}} EDIT / BREYTA

" {{{  TOOLS / Tl
if has("spell")
    menutrans &Spelling					            Stafsetning
    menutrans &Spell\ Check\ On				        Villuleit\ 
    menutrans Spell\ Check\ &Off			        Villuleit\ af
    menutrans To\ &Next\ error<Tab>]s			    Nsta\ Villa<Tab>]s
    menutrans To\ &Previous\ error<Tab>[s		    Fyrri\ Villa<Tab>[s
    menutrans Suggest\ &Corrections<Tab>z=		    Leggja\ til\ Leirttingar<Tab>z=
    menutrans &Repeat\ correction<Tab>:spellrepall	Endurtaka\ Leirttingu<Tab>:spellrepall
    menutrans Set\ language\ to\ "en"			    Stilla\ Orabk\  "en"
    menutrans Set\ language\ to\ "en_au"		    Stilla\ Orabk\  "en_au"
    menutrans Set\ language\ to\ "en_ca"		    Stilla\ Orabk\  "en_ca"
    menutrans Set\ language\ to\ "en_gb"		    Stilla\ Orabk\  "en_gb"
    menutrans Set\ language\ to\ "en_nz"		    Stilla\ Orabk\  "en_nz"
    menutrans Set\ language\ to\ "en_us"		    Stilla\ Orabk\  "en_us"
    menutrans &Find\ More\ Languages			    Finna\ fleiri\ Orabkur
endif
if has("folding")
  menutrans &Folding					            Fldun
  " open close folds
  menutrans &Enable/Disable\ folds<Tab>zi		    Fldun\ \/af<Tab>zi
  menutrans &View\ Cursor\ Line<Tab>zv			    Sj\ Lnu\ Bendils<Tab>zv
  menutrans Vie&w\ Cursor\ Line\ only<Tab>zMzx	    Sj\ Eingngu\ Lnu\ Bendils<Tab>zMzx
  menutrans C&lose\ more\ folds<Tab>zm			    Loka\ Fleiri\ Fldunum<Tab>zm
  menutrans &Close\ all\ folds<Tab>zM			    Loka\ llum\ Fldunum<Tab>zM
  menutrans O&pen\ more\ folds<Tab>zr			    Opna\ Fleiri\ Faldanir<Tab>zr
  menutrans &Open\ all\ folds<Tab>zR			    Opna\ Allar\ Faldanir<Tab>zR
  " fold method
  menutrans Fold\ Met&hod			                Fldunar-httur
  menutrans M&anual					                Handvirkur
  menutrans I&ndent					                Inndrttur
  menutrans E&xpression				                Seg
  menutrans S&yntax					                Mlskipan
  menutrans &Diff					                Mismunur
  menutrans Ma&rker					                Merking
  " create and delete folds
  menutrans Create\ &Fold<Tab>zf			        Ba\ til\ Fldun<Tab>zf
  menutrans &Delete\ Fold<Tab>zd			        Eya\ Fldun<Tab>zd
  menutrans Delete\ &All\ Folds<Tab>zD		        Eya\ llum\ Fldunum<Tab>zD
  " moving around in folds
  menutrans Fold\ Col&umn\ Width			        Breidd\ Fldunar
endif  " has folding

if has("diff")
  menutrans &Diff					                Mismunur
  menutrans &Update					                Uppfra
  menutrans &Get\ Block				                Skja\ Blk
  menutrans &Put\ Block				                Setja\ Blk
endif

menutrans &Tools					                Tl
menutrans &Jump\ to\ this\ tag<Tab>g^]	    		Stkkva\ \ Merki<Tab>g^]
menutrans Jump\ &back<Tab>^T			        	Stkkva\ til\ baka<Tab>^T
menutrans Build\ &Tags\ File			        	Ba\ til\ Merkjaskr
menutrans &Make<Tab>:make				            Sma<Tab>:make
menutrans &List\ Errors<Tab>:cl			        	Birta\ Villur<Tab>:cl
menutrans L&ist\ Messages<Tab>:cl!		        	Birta\ Skilabo<Tab>:cl!
menutrans &Next\ Error<Tab>:cn			        	Nsta\ Villa<Tab>:cn
menutrans &Previous\ Error<Tab>:cp		        	Fyrri\ Villa<Tab>:cp
menutrans &Older\ List<Tab>:cold		        	Eldri\ Listi<Tab>:cold
menutrans N&ewer\ List<Tab>:cnew		        	Nrri\ Listi<Tab>:cnew

menutrans Error\ &Window				            Villugluggi
menutrans Se&t\ Compiler				            Smiur
menutrans &Update<Tab>:cwin				            Uppfra<Tab>:cwin
menutrans &Open<Tab>:copen				            Opna<Tab>:copen
menutrans &Close<Tab>:cclose				        Loka<Tab>:cclose

menutrans &Convert\ to\ HEX<Tab>:%!xxd			    Breyta\ \ HEX<Tab>:%!xxd
menutrans Conve&rt\ back<Tab>:%!xxd\ -r			    Breyta\ til\ baka<Tab>:%!xxd\ -r
" }}}  TOOLS / TL

" {{{ SYNTAX / MLSKIPAN
menutrans &Syntax				                    Mlskipan
menutrans &Show\ filetypes\ in\ menu		        Sna\ Skrartegundir
menutrans Set\ '&syntax'\ only			            Stilla\ aeins\ 'mlskipan'\
menutrans Set\ '&filetype'\ too			            Stilla\ einnig\ 'skrartegund'\
menutrans &Off					                    Af
menutrans &Manual				                    Handvirkt
menutrans A&utomatic				                Sjlfvirkt
menutrans on/off\ for\ &This\ file		            /af\ fyrir\ essa\ skr
menutrans Co&lor\ test				                Litaprfun
menutrans &Highlight\ test			                Aukenningarprfun
menutrans &Convert\ to\ HTML			            Breyta\ \ HTML
" }}} SYNTAX / MLSKIPAN

" {{{ BUFFERS / BIMINNI
menutrans &Buffers					                Biminni
menutrans &Refresh\ menu			                Uppfra\ valmynd
menutrans Delete					                Eya
menutrans &Alternate				                Skipta
menutrans &Next						                Nsta
menutrans &Previous					                Fyrra
" }}} BUFFERS / BIMINNI

" {{{ WINDOW / GLUGGI
menutrans &Window			                        Gluggi
menutrans &New<Tab>^Wn			                    Nr<Tab>^Wn
menutrans S&plit<Tab>^Ws		                    Splitta<Tab>^Ws
menutrans Split\ &Vertically<Tab>^Wv	            Splitta\ Lrtt<Tab>^Wv
menutrans Split\ File\ E&xplorer	                Splitta\ Skrarvafra
menutrans Sp&lit\ To\ #<Tab>^W^^	                Splitta\ \ Flipa\ #<Tab>^W^^
menutrans &Close<Tab>^Wc		                    Loka\ Flipa<Tab>^Wc
menutrans Close\ &Other(s)<Tab>^Wo	                Loka\ rum\ Flipum<Tab>^Wo
menutrans Ne&xt<Tab>^Ww			                    Nsti<Tab>^Ww
menutrans P&revious<Tab>^WW		                    Fyrri<Tab>^WW
menutrans &Equal\ Size<Tab>^W=		                Jafn\ Str<Tab>^W=
menutrans &Max\ Height<Tab>^W_		                Hmarksh<Tab>^W_
menutrans M&in\ Height<Tab>^W1_		                Lgmarksh<Tab>^W1_
menutrans Max\ &Width<Tab>^W\|		                Hmarksbreidd<Tab>^W\|
menutrans Min\ Widt&h<Tab>^W1\|		                Lgmarksbreidd<Tab>^W1\|
menutrans Move\ &To			                        Fra
menutrans &Top<Tab>^WK			                    Upp<Tab>^WK
menutrans &Bottom<Tab>^WJ		                    Niur<Tab>^WJ
menutrans &Left\ side<Tab>^WH		                Til\ Vinstri<Tab>^WH
menutrans &Right\ side<Tab>^WL		                Til\ Hgri<Tab>^WL
menutrans Rotate\ &Up<Tab>^WR		                Rlla\ upp<Tab>^WR
menutrans Rotate\ &Down<Tab>^Wr		                Rlla\ niur<Tab>^Wr
menutrans Select\ Fo&nt\.\.\.		                Velja\ Leturger\.\.\.
" }}} WINDOW / GLUGGI

" {{{ HELP / HJLP
menutrans &Help			                            Hjlp
menutrans &Overview<Tab><F1>	                    Yfirlit<Tab><F1>
menutrans &User\ Manual		                        Notendahandbk
menutrans &How-to\ links	                        Hjlparhlekkir
menutrans &GUI			                            Myndrnt\ Vimt
menutrans &Credits		                            Hfundar
menutrans Co&pying		                            Afritun
menutrans &Sponsor/Register                         Styrkja/Skrning
menutrans O&rphans		                            Ggerarstarf
menutrans &Find\.\.\.		                        Leit\.\.\.	" conflicts with Edit.Find
menutrans &Version		                            tgfa
menutrans &About		                            Um\ Forriti
" }}} HELP / HJLP

" {{{ POPUP
menutrans &Undo				                        Til\ Baka
menutrans Cu&t				                        Klippa
menutrans &Copy				                        Afrita
menutrans &Paste			                        Lma
menutrans &Delete			                        Eya
menutrans Select\ Blockwise		                    Velja\ Blkvst
menutrans Select\ &Word			                    Velja\ Or
menutrans Select\ &Sentence		                    Velja\ Setningu
menutrans Select\ Pa&ragraph	                    Velja\ Efnisgrein
menutrans Select\ &Line			                    Velja\ Lnu
menutrans Select\ &Block		                    Velja\ Blk
menutrans Select\ &All			                    Velja\ Allt
" }}} POPUP

" {{{ TOOLBAR
if has("toolbar")
  if exists("*Do_toolbar_tmenu")
    delfun Do_toolbar_tmenu
  endif
  fun Do_toolbar_tmenu()
    tmenu ToolBar.Open		                        Opna Skr
    tmenu ToolBar.Save		                        Vista Skr
    tmenu ToolBar.SaveAll	                        Vista Allar Skrr
    tmenu ToolBar.Print		                        Prenta
    tmenu ToolBar.Undo		                        Afturkalla
    tmenu ToolBar.Redo		                        Endurkalla
    tmenu ToolBar.Cut		                        Klippa
    tmenu ToolBar.Copy		                        Afrita
    tmenu ToolBar.Paste		                        Lma
    tmenu ToolBar.Find		                        Finna...
    tmenu ToolBar.FindNext	                        Finna Nsta
    tmenu ToolBar.FindPrev	                        Finna fyrri
    tmenu ToolBar.Replace	                        Finna og Skipta...
    if 0	" disabled; These are in the Windows menu
      tmenu ToolBar.New		                        Nr
      tmenu ToolBar.WinSplit	                    Splitta Glugga
      tmenu ToolBar.WinMax	                        Hmarksstr Glugga
      tmenu ToolBar.WinMin	                        Lgmarksstr Glugga
      tmenu ToolBar.WinClose	                    Loka Glugga
    endif
    tmenu ToolBar.LoadSesn	                        Hlaa Setu
    tmenu ToolBar.SaveSesn	                        Vista Setu
    tmenu ToolBar.RunScript	                        Keyra Skriptu
    tmenu ToolBar.Make		                        Sma
    tmenu ToolBar.Shell		                        Opna Skel
    tmenu ToolBar.RunCtags	                        Sma Merki
    tmenu ToolBar.TagJump	                        Hoppa  Merki
    tmenu ToolBar.Help		                        Hjlp
    tmenu ToolBar.FindHelp	                        Finna Hjlp...
  endfun
endif
" }}} TOOLBAR

" {{{ DIALOG TEXTS
let g:menutrans_no_file =                           "[Engin Skr]"
let g:menutrans_help_dialog =                       "Sli inn skipun ea ora til a leita upplsinga um:\n\nForskeyti i_ fyrir lagshamsskipanir (t.d. i_CTRL-X)\nForskeyti c_ fyrir skipanalnuskipanir (t.d. c_<Del>)\nForskeyti ' fyrir nafn  valmguleika (t.d. 'shiftbreidd')"
let g:menutrans_path_dialog =                       "Sli inn leitarsl fyrir skrr.\nAskilji mppur me kommu"
let g:menutrans_tags_dialog =                       "Sli inn nafn Merkjaskra.\nAskilji nfnin me kommu"
let g:menutrans_textwidth_dialog =                  "Sli inn nja textabreidd (0 til a virkja snimtun): "
let g:menutrans_fileformat_dialog =                 "Velji Skrarsni"
" }}}

let &cpo = s:keepcpo
unlet s:keepcpo
