/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nio.zipfs;

import com.sun.nio.zipfs.ZipCoder;
import com.sun.nio.zipfs.ZipConstants;
import com.sun.nio.zipfs.ZipFileAttributes;
import com.sun.nio.zipfs.ZipFileStore;
import com.sun.nio.zipfs.ZipFileSystemProvider;
import com.sun.nio.zipfs.ZipPath;
import com.sun.nio.zipfs.ZipUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipError;
import java.util.zip.ZipException;

public class ZipFileSystem
extends FileSystem {
    private final ZipFileSystemProvider provider;
    private final ZipPath defaultdir;
    private boolean readOnly = false;
    private final Path zfpath;
    private final ZipCoder zc;
    private final String defaultDir;
    private final String nameEncoding;
    private final boolean useTempFile;
    private final boolean createNew;
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    private static final Set<String> supportedFileAttributeViews = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("basic", "zip")));
    private static final String GLOB_SYNTAX = "glob";
    private static final String REGEX_SYNTAX = "regex";
    private Set<InputStream> streams = Collections.synchronizedSet(new HashSet());
    private Set<ExChannelCloser> exChClosers = new HashSet<ExChannelCloser>();
    private Set<Path> tmppaths = Collections.synchronizedSet(new HashSet());
    private static byte[] ROOTPATH = new byte[0];
    private volatile boolean isOpen = true;
    private final SeekableByteChannel ch;
    final byte[] cen;
    private END end;
    private long locpos;
    private final ReadWriteLock rwlock = new ReentrantReadWriteLock();
    private LinkedHashMap<IndexNode, IndexNode> inodes;
    private boolean hasUpdate = false;
    private final IndexNode LOOKUPKEY = IndexNode.keyOf(null);
    private final int MAX_FLATER = 20;
    private final List<Inflater> inflaters = new ArrayList<Inflater>();
    private final List<Deflater> deflaters = new ArrayList<Deflater>();
    private IndexNode root;

    ZipFileSystem(ZipFileSystemProvider zipFileSystemProvider, Path path, Map<String, ?> map) throws IOException {
        this.createNew = "true".equals(map.get("create"));
        this.nameEncoding = map.containsKey("encoding") ? (String)map.get("encoding") : "UTF-8";
        this.useTempFile = Boolean.TRUE.equals(map.get("useTempFile"));
        String string = this.defaultDir = map.containsKey("default.dir") ? (String)map.get("default.dir") : "/";
        if (this.defaultDir.charAt(0) != '/') {
            throw new IllegalArgumentException("default dir should be absolute");
        }
        this.provider = zipFileSystemProvider;
        this.zfpath = path;
        if (Files.notExists(path, new LinkOption[0])) {
            if (this.createNew) {
                try (OutputStream outputStream = Files.newOutputStream(path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                    new END().write(outputStream, 0L);
                }
            } else {
                throw new FileSystemNotFoundException(path.toString());
            }
        }
        path.getFileSystem().provider().checkAccess(path, AccessMode.READ);
        if (!Files.isWritable(path)) {
            this.readOnly = true;
        }
        this.zc = ZipCoder.get(this.nameEncoding);
        this.defaultdir = new ZipPath(this, this.getBytes(this.defaultDir));
        this.ch = Files.newByteChannel(path, StandardOpenOption.READ);
        this.cen = this.initCEN();
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    private void checkWritable() throws IOException {
        if (this.readOnly) {
            throw new ReadOnlyFileSystemException();
        }
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        ArrayList<Path> arrayList = new ArrayList<Path>();
        arrayList.add(new ZipPath(this, new byte[]{47}));
        return arrayList;
    }

    ZipPath getDefaultDir() {
        return this.defaultdir;
    }

    @Override
    public ZipPath getPath(String string, String ... stringArray) {
        String string2;
        if (stringArray.length == 0) {
            string2 = string;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            for (String string3 : stringArray) {
                if (string3.length() <= 0) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('/');
                }
                stringBuilder.append(string3);
            }
            string2 = stringBuilder.toString();
        }
        return new ZipPath(this, this.getBytes(string2));
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() {
        throw new UnsupportedOperationException();
    }

    FileStore getFileStore(ZipPath zipPath) {
        return new ZipFileStore(zipPath);
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        ArrayList<FileStore> arrayList = new ArrayList<FileStore>(1);
        arrayList.add(new ZipFileStore(new ZipPath(this, new byte[]{47})));
        return arrayList;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return supportedFileAttributeViews;
    }

    public String toString() {
        return this.zfpath.toString();
    }

    Path getZipFile() {
        return this.zfpath;
    }

    @Override
    public PathMatcher getPathMatcher(String string) {
        String string2;
        int n = string.indexOf(58);
        if (n <= 0 || n == string.length()) {
            throw new IllegalArgumentException();
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        if (string3.equals(GLOB_SYNTAX)) {
            string2 = ZipUtils.toRegexPattern(string4);
        } else if (string3.equals(REGEX_SYNTAX)) {
            string2 = string4;
        } else {
            throw new UnsupportedOperationException("Syntax '" + string3 + "' not recognized");
        }
        final Pattern pattern = Pattern.compile(string2);
        return new PathMatcher(){

            @Override
            public boolean matches(Path path) {
                return pattern.matcher(path.toString()).matches();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object;
        Object object2;
        this.beginWrite();
        try {
            if (!this.isOpen) {
                return;
            }
            this.isOpen = false;
        }
        finally {
            this.endWrite();
        }
        if (!this.streams.isEmpty()) {
            object2 = new HashSet<InputStream>(this.streams);
            object = object2.iterator();
            while (object.hasNext()) {
                InputStream iterator = (InputStream)object.next();
                iterator.close();
            }
        }
        this.beginWrite();
        try {
            this.sync();
            this.ch.close();
        }
        finally {
            this.endWrite();
        }
        object2 = this.inflaters;
        synchronized (object2) {
            for (Inflater inflater : this.inflaters) {
                inflater.end();
            }
        }
        object2 = this.deflaters;
        synchronized (object2) {
            for (Deflater deflater : this.deflaters) {
                deflater.end();
            }
        }
        this.beginWrite();
        try {
            this.inodes = null;
        }
        finally {
            this.endWrite();
        }
        object2 = null;
        object = this.tmppaths;
        synchronized (object) {
            for (Path path : this.tmppaths) {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException iOException) {
                    if (object2 == null) {
                        object2 = iOException;
                        continue;
                    }
                    ((Throwable)object2).addSuppressed(iOException);
                }
            }
        }
        this.provider.removeFileSystem(this.zfpath, this);
        if (object2 != null) {
            throw object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ZipFileAttributes getFileAttributes(byte[] byArray) throws IOException {
        Entry entry;
        this.beginRead();
        try {
            this.ensureOpen();
            entry = this.getEntry0(byArray);
            if (entry == null) {
                IndexNode indexNode = this.getInode(byArray);
                if (indexNode == null) {
                    ZipFileAttributes zipFileAttributes = null;
                    return zipFileAttributes;
                }
                entry = new Entry(indexNode.name);
                entry.method = 0;
                entry.ctime = -1L;
                entry.atime = -1L;
                entry.mtime = -1L;
            }
        }
        finally {
            this.endRead();
        }
        return new ZipFileAttributes(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimes(byte[] byArray, FileTime fileTime, FileTime fileTime2, FileTime fileTime3) throws IOException {
        this.checkWritable();
        this.beginWrite();
        try {
            this.ensureOpen();
            Entry entry = this.getEntry0(byArray);
            if (entry == null) {
                throw new NoSuchFileException(this.getString(byArray));
            }
            if (entry.type == 1) {
                entry.type = 4;
            }
            if (fileTime != null) {
                entry.mtime = fileTime.toMillis();
            }
            if (fileTime2 != null) {
                entry.atime = fileTime2.toMillis();
            }
            if (fileTime3 != null) {
                entry.ctime = fileTime3.toMillis();
            }
            this.update(entry);
        }
        finally {
            this.endWrite();
        }
    }

    boolean exists(byte[] byArray) throws IOException {
        this.beginRead();
        try {
            this.ensureOpen();
            boolean bl = this.getInode(byArray) != null;
            return bl;
        }
        finally {
            this.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDirectory(byte[] byArray) throws IOException {
        this.beginRead();
        try {
            IndexNode indexNode = this.getInode(byArray);
            boolean bl = indexNode != null && indexNode.isDir();
            return bl;
        }
        finally {
            this.endRead();
        }
    }

    private ZipPath toZipPath(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = 47;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        return new ZipPath(this, byArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<Path> iteratorOf(byte[] byArray, DirectoryStream.Filter<? super Path> filter) throws IOException {
        this.beginWrite();
        try {
            Object object;
            this.ensureOpen();
            IndexNode indexNode = this.getInode(byArray);
            if (indexNode == null) {
                throw new NotDirectoryException(this.getString(byArray));
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            IndexNode indexNode2 = indexNode.child;
            while (indexNode2 != null) {
                object = this.toZipPath(indexNode2.name);
                if (filter == null || filter.accept((Path)object)) {
                    arrayList.add(object);
                }
                indexNode2 = indexNode2.sibling;
            }
            object = arrayList.iterator();
            return object;
        }
        finally {
            this.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createDirectory(byte[] byArray, FileAttribute<?> ... fileAttributeArray) throws IOException {
        this.checkWritable();
        byArray = ZipUtils.toDirectoryPath(byArray);
        this.beginWrite();
        try {
            this.ensureOpen();
            if (byArray.length == 0 || this.exists(byArray)) {
                throw new FileAlreadyExistsException(this.getString(byArray));
            }
            this.checkParents(byArray);
            Entry entry = new Entry(byArray, 2);
            entry.method = 0;
            this.update(entry);
        }
        finally {
            this.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyFile(boolean bl, byte[] byArray, byte[] byArray2, CopyOption ... copyOptionArray) throws IOException {
        this.checkWritable();
        if (Arrays.equals(byArray, byArray2)) {
            return;
        }
        this.beginWrite();
        try {
            this.ensureOpen();
            Entry entry = this.getEntry0(byArray);
            if (entry == null) {
                throw new NoSuchFileException(this.getString(byArray));
            }
            if (entry.isDir()) {
                this.createDirectory(byArray2, new FileAttribute[0]);
                return;
            }
            boolean bl2 = false;
            boolean bl3 = false;
            for (CopyOption copyOption : copyOptionArray) {
                if (copyOption == StandardCopyOption.REPLACE_EXISTING) {
                    bl2 = true;
                    continue;
                }
                if (copyOption != StandardCopyOption.COPY_ATTRIBUTES) continue;
                bl3 = true;
            }
            Entry entry2 = this.getEntry0(byArray2);
            if (entry2 != null) {
                if (!bl2) {
                    throw new FileAlreadyExistsException(this.getString(byArray2));
                }
            } else {
                this.checkParents(byArray2);
            }
            Entry entry3 = new Entry(entry, 4);
            entry3.name(byArray2);
            if (entry.type == 2 || entry.type == 3) {
                entry3.type = entry.type;
                if (bl) {
                    entry3.bytes = entry.bytes;
                    entry3.file = entry.file;
                } else if (entry.bytes != null) {
                    entry3.bytes = Arrays.copyOf(entry.bytes, entry.bytes.length);
                } else if (entry.file != null) {
                    entry3.file = this.getTempPathForEntry(null);
                    Files.copy(entry.file, entry3.file, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            if (!bl3) {
                entry3.atime = entry3.ctime = System.currentTimeMillis();
                entry3.mtime = entry3.ctime;
            }
            this.update(entry3);
            if (bl) {
                this.updateDelete(entry);
            }
        }
        finally {
            this.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OutputStream newOutputStream(byte[] byArray, OpenOption ... openOptionArray) throws IOException {
        this.checkWritable();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (OpenOption object : openOptionArray) {
            if (object == StandardOpenOption.READ) {
                throw new IllegalArgumentException("READ not allowed");
            }
            if (object == StandardOpenOption.CREATE_NEW) {
                bl = true;
            }
            if (object == StandardOpenOption.CREATE) {
                bl2 = true;
            }
            if (object == StandardOpenOption.APPEND) {
                bl3 = true;
            }
            if (object != StandardOpenOption.TRUNCATE_EXISTING) continue;
            bl4 = true;
        }
        if (bl3 && bl4) {
            throw new IllegalArgumentException("APPEND + TRUNCATE_EXISTING not allowed");
        }
        this.beginRead();
        try {
            this.ensureOpen();
            Entry entry = this.getEntry0(byArray);
            if (entry != null) {
                if (entry.isDir() || bl) {
                    throw new FileAlreadyExistsException(this.getString(byArray));
                }
                if (bl3) {
                    InputStream inputStream = this.getInputStream(entry);
                    OutputStream outputStream = this.getOutputStream(new Entry(entry, 2));
                    ZipFileSystem.copyStream(inputStream, outputStream);
                    inputStream.close();
                    OutputStream outputStream2 = outputStream;
                    return outputStream2;
                }
                OutputStream outputStream = this.getOutputStream(new Entry(entry, 2));
                return outputStream;
            }
            if (!bl2 && !bl) {
                throw new NoSuchFileException(this.getString(byArray));
            }
            this.checkParents(byArray);
            OutputStream outputStream = this.getOutputStream(new Entry(byArray, 2));
            return outputStream;
        }
        finally {
            this.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream newInputStream(byte[] byArray) throws IOException {
        this.beginRead();
        try {
            this.ensureOpen();
            Entry entry = this.getEntry0(byArray);
            if (entry == null) {
                throw new NoSuchFileException(this.getString(byArray));
            }
            if (entry.isDir()) {
                throw new FileSystemException(this.getString(byArray), "is a directory", null);
            }
            InputStream inputStream = this.getInputStream(entry);
            return inputStream;
        }
        finally {
            this.endRead();
        }
    }

    private void checkOptions(Set<? extends OpenOption> set) {
        for (OpenOption openOption : set) {
            if (openOption == null) {
                throw new NullPointerException();
            }
            if (openOption instanceof StandardOpenOption) continue;
            throw new IllegalArgumentException();
        }
        if (set.contains(StandardOpenOption.APPEND) && set.contains(StandardOpenOption.TRUNCATE_EXISTING)) {
            throw new IllegalArgumentException("APPEND + TRUNCATE_EXISTING not allowed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SeekableByteChannel newByteChannel(byte[] byArray, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        this.checkOptions(set);
        if (set.contains(StandardOpenOption.WRITE) || set.contains(StandardOpenOption.APPEND)) {
            this.checkWritable();
            this.beginRead();
            try {
                Entry entry;
                final WritableByteChannel writableByteChannel = Channels.newChannel(this.newOutputStream(byArray, set.toArray(new OpenOption[0])));
                long l = 0L;
                if (set.contains(StandardOpenOption.APPEND) && (entry = this.getEntry0(byArray)) != null && entry.size >= 0L) {
                    l = entry.size;
                }
                final long l2 = l;
                SeekableByteChannel seekableByteChannel = new SeekableByteChannel(){
                    long written;
                    {
                        this.written = l2;
                    }

                    @Override
                    public boolean isOpen() {
                        return writableByteChannel.isOpen();
                    }

                    @Override
                    public long position() throws IOException {
                        return this.written;
                    }

                    @Override
                    public SeekableByteChannel position(long l) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public int read(ByteBuffer byteBuffer) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public SeekableByteChannel truncate(long l) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public int write(ByteBuffer byteBuffer) throws IOException {
                        int n = writableByteChannel.write(byteBuffer);
                        this.written += (long)n;
                        return n;
                    }

                    @Override
                    public long size() throws IOException {
                        return this.written;
                    }

                    @Override
                    public void close() throws IOException {
                        writableByteChannel.close();
                    }
                };
                return seekableByteChannel;
            }
            finally {
                this.endRead();
            }
        }
        this.beginRead();
        try {
            this.ensureOpen();
            Entry entry = this.getEntry0(byArray);
            if (entry == null || entry.isDir()) {
                throw new NoSuchFileException(this.getString(byArray));
            }
            final ReadableByteChannel readableByteChannel = Channels.newChannel(this.getInputStream(entry));
            final long l = entry.size;
            SeekableByteChannel seekableByteChannel = new SeekableByteChannel(){
                long read = 0L;

                @Override
                public boolean isOpen() {
                    return readableByteChannel.isOpen();
                }

                @Override
                public long position() throws IOException {
                    return this.read;
                }

                @Override
                public SeekableByteChannel position(long l2) throws IOException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int read(ByteBuffer byteBuffer) throws IOException {
                    int n = readableByteChannel.read(byteBuffer);
                    if (n > 0) {
                        this.read += (long)n;
                    }
                    return n;
                }

                @Override
                public SeekableByteChannel truncate(long l2) throws IOException {
                    throw new NonWritableChannelException();
                }

                @Override
                public int write(ByteBuffer byteBuffer) throws IOException {
                    throw new NonWritableChannelException();
                }

                @Override
                public long size() throws IOException {
                    return l;
                }

                @Override
                public void close() throws IOException {
                    readableByteChannel.close();
                }
            };
            return seekableByteChannel;
        }
        finally {
            this.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileChannel newFileChannel(byte[] byArray, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        this.checkOptions(set);
        final boolean bl = set.contains(StandardOpenOption.WRITE) || set.contains(StandardOpenOption.APPEND);
        this.beginRead();
        try {
            Entry entry;
            this.ensureOpen();
            Entry entry2 = this.getEntry0(byArray);
            if (bl) {
                this.checkWritable();
                if (entry2 == null) {
                    if (!set.contains(StandardOpenOption.CREATE) && !set.contains(StandardOpenOption.CREATE_NEW)) {
                        throw new NoSuchFileException(this.getString(byArray));
                    }
                } else {
                    if (set.contains(StandardOpenOption.CREATE_NEW)) {
                        throw new FileAlreadyExistsException(this.getString(byArray));
                    }
                    if (entry2.isDir()) {
                        throw new FileAlreadyExistsException("directory <" + this.getString(byArray) + "> exists");
                    }
                }
                set = new HashSet<OpenOption>(set);
                set.remove(StandardOpenOption.CREATE_NEW);
            } else if (entry2 == null || entry2.isDir()) {
                throw new NoSuchFileException(this.getString(byArray));
            }
            final boolean bl2 = entry2 != null && entry2.type == 3;
            final Path path = bl2 ? entry2.file : this.getTempPathForEntry(byArray);
            final FileChannel fileChannel = path.getFileSystem().provider().newFileChannel(path, set, fileAttributeArray);
            Entry entry3 = entry = bl2 ? entry2 : new Entry(byArray, path, 3);
            if (bl) {
                entry.flag = 8;
                entry.method = 8;
            }
            FileChannel fileChannel2 = new FileChannel(){

                @Override
                public int write(ByteBuffer byteBuffer) throws IOException {
                    return fileChannel.write(byteBuffer);
                }

                @Override
                public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
                    return fileChannel.write(byteBufferArray, n, n2);
                }

                @Override
                public long position() throws IOException {
                    return fileChannel.position();
                }

                @Override
                public FileChannel position(long l) throws IOException {
                    fileChannel.position(l);
                    return this;
                }

                @Override
                public long size() throws IOException {
                    return fileChannel.size();
                }

                @Override
                public FileChannel truncate(long l) throws IOException {
                    fileChannel.truncate(l);
                    return this;
                }

                @Override
                public void force(boolean bl3) throws IOException {
                    fileChannel.force(bl3);
                }

                @Override
                public long transferTo(long l, long l2, WritableByteChannel writableByteChannel) throws IOException {
                    return fileChannel.transferTo(l, l2, writableByteChannel);
                }

                @Override
                public long transferFrom(ReadableByteChannel readableByteChannel, long l, long l2) throws IOException {
                    return fileChannel.transferFrom(readableByteChannel, l, l2);
                }

                @Override
                public int read(ByteBuffer byteBuffer) throws IOException {
                    return fileChannel.read(byteBuffer);
                }

                @Override
                public int read(ByteBuffer byteBuffer, long l) throws IOException {
                    return fileChannel.read(byteBuffer, l);
                }

                @Override
                public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
                    return fileChannel.read(byteBufferArray, n, n2);
                }

                @Override
                public int write(ByteBuffer byteBuffer, long l) throws IOException {
                    return fileChannel.write(byteBuffer, l);
                }

                @Override
                public MappedByteBuffer map(FileChannel.MapMode mapMode, long l, long l2) throws IOException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public FileLock lock(long l, long l2, boolean bl3) throws IOException {
                    return fileChannel.lock(l, l2, bl3);
                }

                @Override
                public FileLock tryLock(long l, long l2, boolean bl3) throws IOException {
                    return fileChannel.tryLock(l, l2, bl3);
                }

                @Override
                protected void implCloseChannel() throws IOException {
                    fileChannel.close();
                    if (bl) {
                        entry.mtime = System.currentTimeMillis();
                        entry.size = Files.size(entry.file);
                        ZipFileSystem.this.update(entry);
                    } else if (!bl2) {
                        ZipFileSystem.this.removeTempPathForEntry(path);
                    }
                }
            };
            return fileChannel2;
        }
        finally {
            this.endRead();
        }
    }

    private Path getTempPathForEntry(byte[] byArray) throws IOException {
        Entry entry;
        Path path = this.createTempFileInSameDirectoryAs(this.zfpath);
        if (byArray != null && (entry = this.getEntry0(byArray)) != null) {
            try (InputStream inputStream = this.newInputStream(byArray);){
                Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return path;
    }

    private void removeTempPathForEntry(Path path) throws IOException {
        Files.delete(path);
        this.tmppaths.remove(path);
    }

    private void checkParents(byte[] byArray) throws IOException {
        this.beginRead();
        try {
            while ((byArray = ZipFileSystem.getParent(byArray)) != null && byArray.length != 0) {
                if (this.inodes.containsKey(IndexNode.keyOf(byArray))) continue;
                throw new NoSuchFileException(this.getString(byArray));
            }
        }
        finally {
            this.endRead();
        }
    }

    private static byte[] getParent(byte[] byArray) {
        int n = byArray.length - 1;
        if (n > 0 && byArray[n] == 47) {
            --n;
        }
        while (n > 0 && byArray[n] != 47) {
            --n;
        }
        if (n <= 0) {
            return ROOTPATH;
        }
        return Arrays.copyOf(byArray, n + 1);
    }

    private final void beginWrite() {
        this.rwlock.writeLock().lock();
    }

    private final void endWrite() {
        this.rwlock.writeLock().unlock();
    }

    private final void beginRead() {
        this.rwlock.readLock().lock();
    }

    private final void endRead() {
        this.rwlock.readLock().unlock();
    }

    final byte[] getBytes(String string) {
        return this.zc.getBytes(string);
    }

    final String getString(byte[] byArray) {
        return this.zc.toString(byArray);
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private long getDataPos(Entry entry) throws IOException {
        Object object;
        if (entry.locoff == -1L) {
            object = this.getEntry0(entry.name);
            if (object == null) {
                throw new ZipException("invalid loc for entry <" + entry.name + ">");
            }
            entry.locoff = object.locoff;
        }
        if (this.readFullyAt((byte[])(object = new byte[30]), 0, ((byte[])object).length, entry.locoff) != (long)((byte[])object).length) {
            throw new ZipException("invalid loc for entry <" + entry.name + ">");
        }
        return this.locpos + entry.locoff + 30L + (long)ZipConstants.LOCNAM(object) + (long)ZipConstants.LOCEXT(object);
    }

    final long readFullyAt(byte[] byArray, int n, long l, long l2) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.position(n);
        byteBuffer.limit((int)((long)n + l));
        return this.readFullyAt(byteBuffer, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long readFullyAt(ByteBuffer byteBuffer, long l) throws IOException {
        SeekableByteChannel seekableByteChannel = this.ch;
        synchronized (seekableByteChannel) {
            return this.ch.position(l).read(byteBuffer);
        }
    }

    private END findEND() throws IOException {
        byte[] byArray = new byte[128];
        long l = this.ch.size();
        long l2 = l - 65557L > 0L ? l - 65557L : 0L;
        long l3 = l2 - (long)(byArray.length - 22);
        for (long i = l - (long)byArray.length; i >= l3; i -= (long)(byArray.length - 22)) {
            int n;
            int n2 = 0;
            if (i < 0L) {
                n2 = (int)(-i);
                Arrays.fill(byArray, 0, n2, (byte)0);
            }
            if (this.readFullyAt(byArray, n2, n = byArray.length - n2, i + (long)n2) != (long)n) {
                ZipFileSystem.zerror("zip END header not found");
            }
            for (int j = byArray.length - 22; j >= 0; --j) {
                if (byArray[j + 0] != 80 || byArray[j + 1] != 75 || byArray[j + 2] != 5 || byArray[j + 3] != 6 || i + (long)j + 22L + (long)ZipConstants.ENDCOM(byArray, j) != l) continue;
                byArray = Arrays.copyOfRange(byArray, j, j + 22);
                END eND = new END();
                eND.endsub = ZipConstants.ENDSUB(byArray);
                eND.centot = ZipConstants.ENDTOT(byArray);
                eND.cenlen = ZipConstants.ENDSIZ(byArray);
                eND.cenoff = ZipConstants.ENDOFF(byArray);
                eND.comlen = ZipConstants.ENDCOM(byArray);
                eND.endpos = i + (long)j;
                if (eND.cenlen == 0xFFFFFFFFL || eND.cenoff == 0xFFFFFFFFL || eND.centot == 65535) {
                    byte[] byArray2 = new byte[20];
                    if (this.readFullyAt(byArray2, 0, byArray2.length, eND.endpos - 20L) != (long)byArray2.length) {
                        return eND;
                    }
                    byte[] byArray3 = new byte[56];
                    long l4 = ZipConstants.ZIP64_LOCOFF(byArray2);
                    if (this.readFullyAt(byArray3, 0, byArray3.length, l4) != (long)byArray3.length) {
                        return eND;
                    }
                    eND.cenlen = ZipConstants.ZIP64_ENDSIZ(byArray3);
                    eND.cenoff = ZipConstants.ZIP64_ENDOFF(byArray3);
                    eND.centot = (int)ZipConstants.ZIP64_ENDTOT(byArray3);
                    eND.endpos = l4;
                }
                return eND;
            }
        }
        ZipFileSystem.zerror("zip END header not found");
        return null;
    }

    private byte[] initCEN() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        byte[] byArray;
        this.end = this.findEND();
        if (this.end.endpos == 0L) {
            this.inodes = new LinkedHashMap(10);
            this.locpos = 0L;
            this.buildNodeTree();
            return null;
        }
        if (this.end.cenlen > this.end.endpos) {
            ZipFileSystem.zerror("invalid END header (bad central directory size)");
        }
        long l = this.end.endpos - this.end.cenlen;
        this.locpos = l - this.end.cenoff;
        if (this.locpos < 0L) {
            ZipFileSystem.zerror("invalid END header (bad central directory offset)");
        }
        if (this.readFullyAt(byArray = new byte[(int)(this.end.cenlen + 22L)], 0, byArray.length, l) != this.end.cenlen + 22L) {
            ZipFileSystem.zerror("read CEN tables failed");
        }
        this.inodes = new LinkedHashMap(this.end.centot + 1);
        int n5 = byArray.length - 22;
        for (n = 0; n < n5; n += 46 + n4 + n3 + n2) {
            if (ZipConstants.CENSIG(byArray, n) != ZipConstants.CENSIG) {
                ZipFileSystem.zerror("invalid CEN header (bad signature)");
            }
            int n6 = ZipConstants.CENHOW(byArray, n);
            n4 = ZipConstants.CENNAM(byArray, n);
            n3 = ZipConstants.CENEXT(byArray, n);
            n2 = ZipConstants.CENCOM(byArray, n);
            if ((ZipConstants.CENFLG(byArray, n) & 1) != 0) {
                ZipFileSystem.zerror("invalid CEN header (encrypted entry)");
            }
            if (n6 != 0 && n6 != 8) {
                ZipFileSystem.zerror("invalid CEN header (unsupported compression method: " + n6 + ")");
            }
            if (n + 46 + n4 > n5) {
                ZipFileSystem.zerror("invalid CEN header (bad header size)");
            }
            byte[] byArray2 = Arrays.copyOfRange(byArray, n + 46, n + 46 + n4);
            IndexNode indexNode = new IndexNode(byArray2, n);
            this.inodes.put(indexNode, indexNode);
        }
        if (n + 22 != byArray.length) {
            ZipFileSystem.zerror("invalid CEN header (bad header size)");
        }
        this.buildNodeTree();
        return byArray;
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen) {
            throw new ClosedFileSystemException();
        }
    }

    private Path createTempFileInSameDirectoryAs(Path path) throws IOException {
        Path path2 = path.toAbsolutePath().getParent();
        Path path3 = path2 == null ? path.getFileSystem().getPath(".", new String[0]) : path2;
        Path path4 = Files.createTempFile(path3, "zipfstmp", null, new FileAttribute[0]);
        this.tmppaths.add(path4);
        return path4;
    }

    private void updateDelete(IndexNode indexNode) {
        this.beginWrite();
        try {
            this.removeFromTree(indexNode);
            this.inodes.remove(indexNode);
            this.hasUpdate = true;
        }
        finally {
            this.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Entry entry) {
        this.beginWrite();
        try {
            IndexNode indexNode = this.inodes.put(entry, entry);
            if (indexNode != null) {
                this.removeFromTree(indexNode);
            }
            if (entry.type == 2 || entry.type == 3 || entry.type == 4) {
                IndexNode indexNode2 = this.inodes.get(this.LOOKUPKEY.as(ZipFileSystem.getParent(entry.name)));
                entry.sibling = indexNode2.child;
                indexNode2.child = entry;
            }
            this.hasUpdate = true;
        }
        finally {
            this.endWrite();
        }
    }

    private long copyLOCEntry(Entry entry, boolean bl, OutputStream outputStream, long l, byte[] byArray) throws IOException {
        int n;
        long l2 = entry.locoff;
        entry.locoff = l;
        long l3 = 0L;
        if ((entry.flag & 8) != 0) {
            l3 = entry.size >= 0xFFFFFFFFL || entry.csize >= 0xFFFFFFFFL ? 24L : 16L;
        }
        if (this.readFullyAt(byArray, 0, 30L, l2) != 30L) {
            throw new ZipException("loc: reading failed");
        }
        if (bl) {
            l2 += (long)(30 + ZipConstants.LOCNAM(byArray) + ZipConstants.LOCEXT(byArray));
            l = (long)entry.writeLOC(outputStream) + (l3 += entry.csize);
        } else {
            outputStream.write(byArray, 0, 30);
            l2 += 30L;
            l = 30L + (l3 += (long)(ZipConstants.LOCNAM(byArray) + ZipConstants.LOCEXT(byArray)) + entry.csize);
        }
        while (l3 > 0L && (n = (int)this.readFullyAt(byArray, 0, byArray.length, l2)) != -1) {
            if (l3 < (long)n) {
                n = (int)l3;
            }
            outputStream.write(byArray, 0, n);
            l3 -= (long)n;
            l2 += (long)n;
        }
        return l;
    }

    private void sync() throws IOException {
        if (!this.exChClosers.isEmpty()) {
            for (ExChannelCloser object2 : this.exChClosers) {
                if (!object2.streams.isEmpty()) continue;
                object2.ch.close();
                Files.delete(object2.path);
                this.exChClosers.remove(object2);
            }
        }
        if (!this.hasUpdate) {
            return;
        }
        Path path = this.createTempFileInSameDirectoryAs(this.zfpath);
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.WRITE));){
            ArrayList<Entry> throwable2 = new ArrayList<Entry>(this.inodes.size());
            long l = 0L;
            byte[] byArray = new byte[8192];
            Entry entry = null;
            for (IndexNode indexNode : this.inodes.values()) {
                if (indexNode instanceof Entry) {
                    entry = (Entry)indexNode;
                    try {
                        if (entry.type == 4) {
                            l += this.copyLOCEntry(entry, true, bufferedOutputStream, l, byArray);
                        } else {
                            entry.locoff = l;
                            l += (long)entry.writeLOC(bufferedOutputStream);
                            if (entry.bytes != null) {
                                ((OutputStream)bufferedOutputStream).write(entry.bytes);
                                l += (long)entry.bytes.length;
                            } else if (entry.file != null) {
                                block57: {
                                    try (InputStream inputStream = Files.newInputStream(entry.file, new OpenOption[0]);){
                                        if (entry.type == 2) {
                                            int n;
                                            while ((n = inputStream.read(byArray)) != -1) {
                                                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                                                l += (long)n;
                                            }
                                            break block57;
                                        }
                                        if (entry.type != 3) break block57;
                                        try (EntryOutputStream entryOutputStream = new EntryOutputStream(entry, bufferedOutputStream);){
                                            int n;
                                            while ((n = inputStream.read(byArray)) != -1) {
                                                ((OutputStream)entryOutputStream).write(byArray, 0, n);
                                            }
                                        }
                                        l += entry.csize;
                                        if ((entry.flag & 8) != 0) {
                                            l += (long)entry.writeEXT(bufferedOutputStream);
                                        }
                                    }
                                }
                                Files.delete(entry.file);
                                this.tmppaths.remove(entry.file);
                            }
                        }
                        throwable2.add(entry);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    continue;
                }
                if (indexNode.pos == -1) continue;
                entry = Entry.readCEN(this, indexNode.pos);
                try {
                    l += this.copyLOCEntry(entry, false, bufferedOutputStream, l, byArray);
                    throwable2.add(entry);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            this.end.cenoff = l;
            for (Entry entry2 : throwable2) {
                l += (long)entry2.writeCEN(bufferedOutputStream);
            }
            this.end.centot = throwable2.size();
            this.end.cenlen = l - this.end.cenoff;
            this.end.write(bufferedOutputStream, l);
        }
        if (!this.streams.isEmpty()) {
            ExChannelCloser exChannelCloser = new ExChannelCloser(this.createTempFileInSameDirectoryAs(this.zfpath), this.ch, this.streams);
            Files.move(this.zfpath, exChannelCloser.path, StandardCopyOption.REPLACE_EXISTING);
            this.exChClosers.add(exChannelCloser);
            this.streams = Collections.synchronizedSet(new HashSet());
        } else {
            this.ch.close();
            Files.delete(this.zfpath);
        }
        Files.move(path, this.zfpath, StandardCopyOption.REPLACE_EXISTING);
        this.hasUpdate = false;
    }

    private IndexNode getInode(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("path");
        }
        IndexNode indexNode = IndexNode.keyOf(byArray);
        IndexNode indexNode2 = this.inodes.get(indexNode);
        if (indexNode2 == null && (byArray.length == 0 || byArray[byArray.length - 1] != 47)) {
            byArray = Arrays.copyOf(byArray, byArray.length + 1);
            byArray[byArray.length - 1] = 47;
            indexNode2 = this.inodes.get(indexNode.as(byArray));
        }
        return indexNode2;
    }

    private Entry getEntry0(byte[] byArray) throws IOException {
        IndexNode indexNode = this.getInode(byArray);
        if (indexNode instanceof Entry) {
            return (Entry)indexNode;
        }
        if (indexNode == null || indexNode.pos == -1) {
            return null;
        }
        return Entry.readCEN(this, indexNode.pos);
    }

    public void deleteFile(byte[] byArray, boolean bl) throws IOException {
        this.checkWritable();
        IndexNode indexNode = this.getInode(byArray);
        if (indexNode == null) {
            if (byArray != null && byArray.length == 0) {
                throw new ZipException("root directory </> can't not be delete");
            }
            if (bl) {
                throw new NoSuchFileException(this.getString(byArray));
            }
        } else {
            if (indexNode.isDir() && indexNode.child != null) {
                throw new DirectoryNotEmptyException(this.getString(byArray));
            }
            this.updateDelete(indexNode);
        }
    }

    private static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    private OutputStream getOutputStream(Entry entry) throws IOException {
        OutputStream outputStream;
        if (entry.mtime == -1L) {
            entry.mtime = System.currentTimeMillis();
        }
        if (entry.method == -1) {
            entry.method = 8;
        }
        entry.flag = 0;
        if (this.zc.isUTF8()) {
            entry.flag |= 0x800;
        }
        if (this.useTempFile) {
            entry.file = this.getTempPathForEntry(null);
            outputStream = Files.newOutputStream(entry.file, StandardOpenOption.WRITE);
        } else {
            outputStream = new ByteArrayOutputStream(entry.size > 0L ? (int)entry.size : 8192);
        }
        return new EntryOutputStream(entry, outputStream);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputStream getInputStream(Entry entry) throws IOException {
        void var2_9;
        Object var2_2 = null;
        if (entry.type == 2) {
            if (entry.bytes != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(entry.bytes);
            } else {
                if (entry.file == null) throw new ZipException("update entry data is missing");
                InputStream inputStream = Files.newInputStream(entry.file, new OpenOption[0]);
            }
        } else {
            if (entry.type == 3) {
                return Files.newInputStream(entry.file, new OpenOption[0]);
            }
            EntryInputStream entryInputStream = new EntryInputStream(entry, this.ch);
        }
        if (entry.method == 8) {
            void var2_7;
            long l = entry.size + 2L;
            if (l > 65536L) {
                l = 8192L;
            }
            final long l2 = entry.size;
            InflaterInputStream inflaterInputStream = new InflaterInputStream((InputStream)var2_7, this.getInflater(), (int)l){
                private boolean isClosed;
                private boolean eof;
                {
                    super(inputStream, inflater, n);
                    this.isClosed = false;
                }

                @Override
                public void close() throws IOException {
                    if (!this.isClosed) {
                        ZipFileSystem.this.releaseInflater(this.inf);
                        this.in.close();
                        this.isClosed = true;
                        ZipFileSystem.this.streams.remove(this);
                    }
                }

                @Override
                protected void fill() throws IOException {
                    if (this.eof) {
                        throw new EOFException("Unexpected end of ZLIB input stream");
                    }
                    this.len = this.in.read(this.buf, 0, this.buf.length);
                    if (this.len == -1) {
                        this.buf[0] = 0;
                        this.len = 1;
                        this.eof = true;
                    }
                    this.inf.setInput(this.buf, 0, this.len);
                }

                @Override
                public int available() throws IOException {
                    if (this.isClosed) {
                        return 0;
                    }
                    long l = l2 - this.inf.getBytesWritten();
                    return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
                }
            };
        } else if (entry.method != 0) throw new ZipException("invalid compression method");
        this.streams.add((InputStream)var2_9);
        return var2_9;
    }

    static void zerror(String string) {
        throw new ZipError(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Inflater getInflater() {
        List<Inflater> list = this.inflaters;
        synchronized (list) {
            int n = this.inflaters.size();
            if (n > 0) {
                Inflater inflater = this.inflaters.remove(n - 1);
                return inflater;
            }
            return new Inflater(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInflater(Inflater inflater) {
        List<Inflater> list = this.inflaters;
        synchronized (list) {
            if (this.inflaters.size() < 20) {
                inflater.reset();
                this.inflaters.add(inflater);
            } else {
                inflater.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Deflater getDeflater() {
        List<Deflater> list = this.deflaters;
        synchronized (list) {
            int n = this.deflaters.size();
            if (n > 0) {
                Deflater deflater = this.deflaters.remove(n - 1);
                return deflater;
            }
            return new Deflater(-1, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseDeflater(Deflater deflater) {
        List<Deflater> list = this.deflaters;
        synchronized (list) {
            if (this.inflaters.size() < 20) {
                deflater.reset();
                this.deflaters.add(deflater);
            } else {
                deflater.end();
            }
        }
    }

    private void addToTree(IndexNode indexNode, HashSet<IndexNode> hashSet) {
        IndexNode indexNode2;
        if (hashSet.contains(indexNode)) {
            return;
        }
        byte[] byArray = indexNode.name;
        byte[] byArray2 = ZipFileSystem.getParent(byArray);
        if (this.inodes.containsKey(this.LOOKUPKEY.as(byArray2))) {
            indexNode2 = this.inodes.get(this.LOOKUPKEY);
        } else {
            indexNode2 = new IndexNode(byArray2, -1);
            this.inodes.put(indexNode2, indexNode2);
        }
        this.addToTree(indexNode2, hashSet);
        indexNode.sibling = indexNode2.child;
        indexNode2.child = indexNode;
        if (byArray[byArray.length - 1] == 47) {
            hashSet.add(indexNode);
        }
    }

    private void removeFromTree(IndexNode indexNode) {
        IndexNode indexNode2 = this.inodes.get(this.LOOKUPKEY.as(ZipFileSystem.getParent(indexNode.name)));
        IndexNode indexNode3 = indexNode2.child;
        if (indexNode3.equals(indexNode)) {
            indexNode2.child = indexNode3.sibling;
        } else {
            IndexNode indexNode4 = indexNode3;
            while ((indexNode3 = indexNode3.sibling) != null) {
                if (indexNode3.equals(indexNode)) {
                    indexNode4.sibling = indexNode3.sibling;
                    break;
                }
                indexNode4 = indexNode3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildNodeTree() throws IOException {
        this.beginWrite();
        try {
            HashSet<IndexNode> hashSet = new HashSet<IndexNode>();
            IndexNode indexNode = new IndexNode(ROOTPATH, -1);
            this.inodes.put(indexNode, indexNode);
            hashSet.add(indexNode);
            for (IndexNode indexNode2 : this.inodes.keySet().toArray(new IndexNode[0])) {
                this.addToTree(indexNode2, hashSet);
            }
        }
        finally {
            this.endWrite();
        }
    }

    private static class ExChannelCloser {
        Path path;
        SeekableByteChannel ch;
        Set<InputStream> streams;

        ExChannelCloser(Path path, SeekableByteChannel seekableByteChannel, Set<InputStream> set) {
            this.path = path;
            this.ch = seekableByteChannel;
            this.streams = set;
        }
    }

    static class Entry
    extends IndexNode {
        static final int CEN = 1;
        static final int NEW = 2;
        static final int FILECH = 3;
        static final int COPY = 4;
        byte[] bytes;
        Path file;
        int type = 1;
        int version;
        int flag;
        int method = -1;
        long mtime = -1L;
        long atime = -1L;
        long ctime = -1L;
        long crc = -1L;
        long csize = -1L;
        long size = -1L;
        byte[] extra;
        int versionMade;
        int disk;
        int attrs;
        long attrsEx;
        long locoff;
        byte[] comment;

        Entry() {
        }

        Entry(byte[] byArray) {
            this.name(byArray);
            this.ctime = this.atime = System.currentTimeMillis();
            this.mtime = this.atime;
            this.crc = 0L;
            this.size = 0L;
            this.csize = 0L;
            this.method = 8;
        }

        Entry(byte[] byArray, int n) {
            this(byArray);
            this.type = n;
        }

        Entry(Entry entry, int n) {
            this.name(entry.name);
            this.version = entry.version;
            this.ctime = entry.ctime;
            this.atime = entry.atime;
            this.mtime = entry.mtime;
            this.crc = entry.crc;
            this.size = entry.size;
            this.csize = entry.csize;
            this.method = entry.method;
            this.extra = entry.extra;
            this.versionMade = entry.versionMade;
            this.disk = entry.disk;
            this.attrs = entry.attrs;
            this.attrsEx = entry.attrsEx;
            this.locoff = entry.locoff;
            this.comment = entry.comment;
            this.type = n;
        }

        Entry(byte[] byArray, Path path, int n) {
            this(byArray, n);
            this.file = path;
            this.method = 0;
        }

        int version() throws ZipException {
            if (this.method == 8) {
                return 20;
            }
            if (this.method == 0) {
                return 10;
            }
            throw new ZipException("unsupported compression method");
        }

        static Entry readCEN(ZipFileSystem zipFileSystem, int n) throws IOException {
            return new Entry().cen(zipFileSystem, n);
        }

        private Entry cen(ZipFileSystem zipFileSystem, int n) throws IOException {
            byte[] byArray = zipFileSystem.cen;
            if (ZipConstants.CENSIG(byArray, n) != ZipConstants.CENSIG) {
                ZipFileSystem.zerror("invalid CEN header (bad signature)");
            }
            this.versionMade = ZipConstants.CENVEM(byArray, n);
            this.version = ZipConstants.CENVER(byArray, n);
            this.flag = ZipConstants.CENFLG(byArray, n);
            this.method = ZipConstants.CENHOW(byArray, n);
            this.mtime = ZipUtils.dosToJavaTime(ZipConstants.CENTIM(byArray, n));
            this.crc = ZipConstants.CENCRC(byArray, n);
            this.csize = ZipConstants.CENSIZ(byArray, n);
            this.size = ZipConstants.CENLEN(byArray, n);
            int n2 = ZipConstants.CENNAM(byArray, n);
            int n3 = ZipConstants.CENEXT(byArray, n);
            int n4 = ZipConstants.CENCOM(byArray, n);
            this.disk = ZipConstants.CENDSK(byArray, n);
            this.attrs = ZipConstants.CENATT(byArray, n);
            this.attrsEx = ZipConstants.CENATX(byArray, n);
            this.locoff = ZipConstants.CENOFF(byArray, n);
            this.name(Arrays.copyOfRange(byArray, n += 46, n + n2));
            n += n2;
            if (n3 > 0) {
                this.extra = Arrays.copyOfRange(byArray, n, n + n3);
                n += n3;
                this.readExtra(zipFileSystem);
            }
            if (n4 > 0) {
                this.comment = Arrays.copyOfRange(byArray, n, n + n4);
            }
            return this;
        }

        int writeCEN(OutputStream outputStream) throws IOException {
            int n;
            int n2 = 46;
            int n3 = this.version();
            long l = this.csize;
            long l2 = this.size;
            long l3 = this.locoff;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            boolean bl = false;
            int n7 = this.name != null ? this.name.length : 0;
            int n8 = this.extra != null ? this.extra.length : 0;
            int n9 = 0;
            int n10 = n = this.comment != null ? this.comment.length : 0;
            if (this.csize >= 0xFFFFFFFFL) {
                l = 0xFFFFFFFFL;
                n4 += 8;
            }
            if (this.size >= 0xFFFFFFFFL) {
                l2 = 0xFFFFFFFFL;
                n4 += 8;
            }
            if (this.locoff >= 0xFFFFFFFFL) {
                l3 = 0xFFFFFFFFL;
                n4 += 8;
            }
            if (n4 != 0) {
                n4 += 4;
            }
            while (n9 + 4 < n8) {
                int n11 = ZipConstants.SH(this.extra, n9);
                int n12 = ZipConstants.SH(this.extra, n9 + 2);
                if (n11 == 21589 || n11 == 10) {
                    bl = true;
                }
                n9 += 4 + n12;
            }
            if (!bl) {
                if (isWindows) {
                    n5 = 36;
                } else {
                    n6 = 9;
                }
            }
            ZipUtils.writeInt(outputStream, ZipConstants.CENSIG);
            if (n4 != 0) {
                ZipUtils.writeShort(outputStream, 45);
                ZipUtils.writeShort(outputStream, 45);
            } else {
                ZipUtils.writeShort(outputStream, n3);
                ZipUtils.writeShort(outputStream, n3);
            }
            ZipUtils.writeShort(outputStream, this.flag);
            ZipUtils.writeShort(outputStream, this.method);
            ZipUtils.writeInt(outputStream, (int)ZipUtils.javaToDosTime(this.mtime));
            ZipUtils.writeInt(outputStream, this.crc);
            ZipUtils.writeInt(outputStream, l);
            ZipUtils.writeInt(outputStream, l2);
            ZipUtils.writeShort(outputStream, this.name.length);
            ZipUtils.writeShort(outputStream, n8 + n4 + n5 + n6);
            if (this.comment != null) {
                ZipUtils.writeShort(outputStream, Math.min(n, 65535));
            } else {
                ZipUtils.writeShort(outputStream, 0);
            }
            ZipUtils.writeShort(outputStream, 0);
            ZipUtils.writeShort(outputStream, 0);
            ZipUtils.writeInt(outputStream, 0L);
            ZipUtils.writeInt(outputStream, l3);
            ZipUtils.writeBytes(outputStream, this.name);
            if (n4 != 0) {
                ZipUtils.writeShort(outputStream, 1);
                ZipUtils.writeShort(outputStream, n4 - 4);
                if (l2 == 0xFFFFFFFFL) {
                    ZipUtils.writeLong(outputStream, this.size);
                }
                if (l == 0xFFFFFFFFL) {
                    ZipUtils.writeLong(outputStream, this.csize);
                }
                if (l3 == 0xFFFFFFFFL) {
                    ZipUtils.writeLong(outputStream, this.locoff);
                }
            }
            if (n5 != 0) {
                ZipUtils.writeShort(outputStream, 10);
                ZipUtils.writeShort(outputStream, n5 - 4);
                ZipUtils.writeInt(outputStream, 0L);
                ZipUtils.writeShort(outputStream, 1);
                ZipUtils.writeShort(outputStream, 24);
                ZipUtils.writeLong(outputStream, ZipUtils.javaToWinTime(this.mtime));
                ZipUtils.writeLong(outputStream, ZipUtils.javaToWinTime(this.atime));
                ZipUtils.writeLong(outputStream, ZipUtils.javaToWinTime(this.ctime));
            }
            if (n6 != 0) {
                ZipUtils.writeShort(outputStream, 21589);
                ZipUtils.writeShort(outputStream, n6 - 4);
                if (this.ctime == -1L) {
                    outputStream.write(3);
                } else {
                    outputStream.write(7);
                }
                ZipUtils.writeInt(outputStream, ZipUtils.javaToUnixTime(this.mtime));
            }
            if (this.extra != null) {
                ZipUtils.writeBytes(outputStream, this.extra);
            }
            if (this.comment != null) {
                ZipUtils.writeBytes(outputStream, this.comment);
            }
            return 46 + n7 + n8 + n + n4 + n5 + n6;
        }

        static Entry readLOC(ZipFileSystem zipFileSystem, long l) throws IOException {
            return Entry.readLOC(zipFileSystem, l, new byte[1024]);
        }

        static Entry readLOC(ZipFileSystem zipFileSystem, long l, byte[] byArray) throws IOException {
            return new Entry().loc(zipFileSystem, l, byArray);
        }

        Entry loc(ZipFileSystem zipFileSystem, long l, byte[] byArray) throws IOException {
            assert (byArray.length >= 30);
            if (zipFileSystem.readFullyAt(byArray, 0, 30L, l) != 30L) {
                throw new ZipException("loc: reading failed");
            }
            if (ZipConstants.LOCSIG(byArray) != ZipConstants.LOCSIG) {
                throw new ZipException("loc: wrong sig ->" + Long.toString(ZipConstants.LOCSIG(byArray), 16));
            }
            this.version = ZipConstants.LOCVER(byArray);
            this.flag = ZipConstants.LOCFLG(byArray);
            this.method = ZipConstants.LOCHOW(byArray);
            this.mtime = ZipUtils.dosToJavaTime(ZipConstants.LOCTIM(byArray));
            this.crc = ZipConstants.LOCCRC(byArray);
            this.csize = ZipConstants.LOCSIZ(byArray);
            this.size = ZipConstants.LOCLEN(byArray);
            int n = ZipConstants.LOCNAM(byArray);
            int n2 = ZipConstants.LOCEXT(byArray);
            this.name = new byte[n];
            if (zipFileSystem.readFullyAt(this.name, 0, n, l + 30L) != (long)n) {
                throw new ZipException("loc: name reading failed");
            }
            if (n2 > 0) {
                this.extra = new byte[n2];
                if (zipFileSystem.readFullyAt(this.extra, 0, n2, l + 30L + (long)n) != (long)n2) {
                    throw new ZipException("loc: ext reading failed");
                }
            }
            l += (long)(30 + n + n2);
            if ((this.flag & 8) != 0) {
                Entry entry = zipFileSystem.getEntry0(this.name);
                if (entry == null) {
                    throw new ZipException("loc: name not found in cen");
                }
                this.size = entry.size;
                this.csize = entry.csize;
                l += this.method == 0 ? this.size : this.csize;
                l = this.size >= 0xFFFFFFFFL || this.csize >= 0xFFFFFFFFL ? (l += 24L) : (l += 16L);
            } else {
                if (this.extra != null && (this.size == 0xFFFFFFFFL || this.csize == 0xFFFFFFFFL)) {
                    int n3 = 0;
                    while (n3 + 20 < n2) {
                        int n4 = ZipConstants.SH(this.extra, n3 + 2);
                        if (ZipConstants.SH(this.extra, n3) == 1 && n4 == 16) {
                            this.size = ZipConstants.LL(this.extra, n3 + 4);
                            this.csize = ZipConstants.LL(this.extra, n3 + 12);
                            break;
                        }
                        n3 += n4 + 4;
                    }
                }
                l += this.method == 0 ? this.size : this.csize;
            }
            return this;
        }

        int writeLOC(OutputStream outputStream) throws IOException {
            int n;
            ZipUtils.writeInt(outputStream, ZipConstants.LOCSIG);
            int n2 = this.version();
            int n3 = this.name != null ? this.name.length : 0;
            int n4 = this.extra != null ? this.extra.length : 0;
            boolean bl = false;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            if ((this.flag & 8) != 0) {
                ZipUtils.writeShort(outputStream, this.version());
                ZipUtils.writeShort(outputStream, this.flag);
                ZipUtils.writeShort(outputStream, this.method);
                ZipUtils.writeInt(outputStream, (int)ZipUtils.javaToDosTime(this.mtime));
                ZipUtils.writeInt(outputStream, 0L);
                ZipUtils.writeInt(outputStream, 0L);
                ZipUtils.writeInt(outputStream, 0L);
            } else {
                if (this.csize >= 0xFFFFFFFFL || this.size >= 0xFFFFFFFFL) {
                    n6 = 20;
                    ZipUtils.writeShort(outputStream, 45);
                } else {
                    ZipUtils.writeShort(outputStream, this.version());
                }
                ZipUtils.writeShort(outputStream, this.flag);
                ZipUtils.writeShort(outputStream, this.method);
                ZipUtils.writeInt(outputStream, (int)ZipUtils.javaToDosTime(this.mtime));
                ZipUtils.writeInt(outputStream, this.crc);
                if (n6 != 0) {
                    ZipUtils.writeInt(outputStream, 0xFFFFFFFFL);
                    ZipUtils.writeInt(outputStream, 0xFFFFFFFFL);
                } else {
                    ZipUtils.writeInt(outputStream, this.csize);
                    ZipUtils.writeInt(outputStream, this.size);
                }
            }
            while (n5 + 4 < n4) {
                n = ZipConstants.SH(this.extra, n5);
                int n9 = ZipConstants.SH(this.extra, n5 + 2);
                if (n == 21589 || n == 10) {
                    bl = true;
                }
                n5 += 4 + n9;
            }
            if (!bl) {
                if (isWindows) {
                    n8 = 36;
                } else {
                    n7 = 9;
                    if (this.atime != -1L) {
                        n7 += 4;
                    }
                    if (this.ctime != -1L) {
                        n7 += 4;
                    }
                }
            }
            ZipUtils.writeShort(outputStream, this.name.length);
            ZipUtils.writeShort(outputStream, n4 + n6 + n8 + n7);
            ZipUtils.writeBytes(outputStream, this.name);
            if (n6 != 0) {
                ZipUtils.writeShort(outputStream, 1);
                ZipUtils.writeShort(outputStream, 16);
                ZipUtils.writeLong(outputStream, this.size);
                ZipUtils.writeLong(outputStream, this.csize);
            }
            if (n8 != 0) {
                ZipUtils.writeShort(outputStream, 10);
                ZipUtils.writeShort(outputStream, n8 - 4);
                ZipUtils.writeInt(outputStream, 0L);
                ZipUtils.writeShort(outputStream, 1);
                ZipUtils.writeShort(outputStream, 24);
                ZipUtils.writeLong(outputStream, ZipUtils.javaToWinTime(this.mtime));
                ZipUtils.writeLong(outputStream, ZipUtils.javaToWinTime(this.atime));
                ZipUtils.writeLong(outputStream, ZipUtils.javaToWinTime(this.ctime));
            }
            if (n7 != 0) {
                ZipUtils.writeShort(outputStream, 21589);
                ZipUtils.writeShort(outputStream, n7 - 4);
                n = 1;
                if (this.atime != -1L) {
                    n |= 2;
                }
                if (this.ctime != -1L) {
                    n |= 4;
                }
                outputStream.write(n);
                ZipUtils.writeInt(outputStream, ZipUtils.javaToUnixTime(this.mtime));
                if (this.atime != -1L) {
                    ZipUtils.writeInt(outputStream, ZipUtils.javaToUnixTime(this.atime));
                }
                if (this.ctime != -1L) {
                    ZipUtils.writeInt(outputStream, ZipUtils.javaToUnixTime(this.ctime));
                }
            }
            if (this.extra != null) {
                ZipUtils.writeBytes(outputStream, this.extra);
            }
            return 30 + this.name.length + n4 + n6 + n8 + n7;
        }

        int writeEXT(OutputStream outputStream) throws IOException {
            ZipUtils.writeInt(outputStream, ZipConstants.EXTSIG);
            ZipUtils.writeInt(outputStream, this.crc);
            if (this.csize >= 0xFFFFFFFFL || this.size >= 0xFFFFFFFFL) {
                ZipUtils.writeLong(outputStream, this.csize);
                ZipUtils.writeLong(outputStream, this.size);
                return 24;
            }
            ZipUtils.writeInt(outputStream, this.csize);
            ZipUtils.writeInt(outputStream, this.size);
            return 16;
        }

        void readExtra(ZipFileSystem zipFileSystem) throws IOException {
            if (this.extra == null) {
                return;
            }
            int n = this.extra.length;
            int n2 = 0;
            int n3 = 0;
            while (n2 + 4 < n) {
                int n4;
                int n5 = n2;
                int n6 = ZipConstants.SH(this.extra, n5);
                if ((n5 += 4) + (n4 = ZipConstants.SH(this.extra, n5 + 2)) > n) break;
                block0 : switch (n6) {
                    case 1: {
                        if (this.size == 0xFFFFFFFFL) {
                            if (n5 + 8 > n) break;
                            this.size = ZipConstants.LL(this.extra, n5);
                            n5 += 8;
                        }
                        if (this.csize == 0xFFFFFFFFL) {
                            if (n5 + 8 > n) break;
                            this.csize = ZipConstants.LL(this.extra, n5);
                            n5 += 8;
                        }
                        if (this.locoff != 0xFFFFFFFFL || n5 + 8 > n) break;
                        this.locoff = ZipConstants.LL(this.extra, n5);
                        n5 += 8;
                        break;
                    }
                    case 10: {
                        if (n4 < 32 || ZipConstants.SH(this.extra, n5 += 4) != 1 || ZipConstants.SH(this.extra, n5 + 2) != 24) break;
                        this.mtime = ZipUtils.winToJavaTime(ZipConstants.LL(this.extra, n5 + 4));
                        this.atime = ZipUtils.winToJavaTime(ZipConstants.LL(this.extra, n5 + 12));
                        this.ctime = ZipUtils.winToJavaTime(ZipConstants.LL(this.extra, n5 + 20));
                        break;
                    }
                    case 21589: {
                        byte[] byArray = new byte[30];
                        if (zipFileSystem.readFullyAt(byArray, 0, byArray.length, this.locoff) != (long)byArray.length) {
                            throw new ZipException("loc: reading failed");
                        }
                        if (ZipConstants.LOCSIG(byArray) != ZipConstants.LOCSIG) {
                            throw new ZipException("loc: wrong sig ->" + Long.toString(ZipConstants.LOCSIG(byArray), 16));
                        }
                        int n7 = ZipConstants.LOCEXT(byArray);
                        if (n7 < 9) break;
                        byArray = new byte[n7];
                        int n8 = ZipConstants.LOCNAM(byArray);
                        if (zipFileSystem.readFullyAt(byArray, 0, byArray.length, this.locoff + 30L + (long)n8) != (long)byArray.length) {
                            throw new ZipException("loc extra: reading failed");
                        }
                        int n9 = 0;
                        while (n9 + 4 < byArray.length) {
                            int n10;
                            int n11 = ZipConstants.SH(byArray, n9);
                            int n12 = ZipConstants.SH(byArray, n9 + 2);
                            n9 += 4;
                            if (n11 != 21589) {
                                n9 += n12;
                                continue;
                            }
                            if (((n10 = ZipConstants.CH(byArray, n9++)) & 1) != 0) {
                                this.mtime = ZipUtils.unixToJavaTime(ZipConstants.LG(byArray, n9));
                                n9 += 4;
                            }
                            if ((n10 & 2) != 0) {
                                this.atime = ZipUtils.unixToJavaTime(ZipConstants.LG(byArray, n9));
                                n9 += 4;
                            }
                            if ((n10 & 4) == 0) break block0;
                            this.ctime = ZipUtils.unixToJavaTime(ZipConstants.LG(byArray, n9));
                            n9 += 4;
                            break block0;
                        }
                        break;
                    }
                    default: {
                        System.arraycopy(this.extra, n2, this.extra, n3, n4 + 4);
                        n3 += n4 + 4;
                    }
                }
                n2 += n4 + 4;
            }
            this.extra = (byte[])(n3 != 0 && n3 != this.extra.length ? Arrays.copyOf(this.extra, n3) : null);
        }
    }

    static class IndexNode {
        byte[] name;
        int hashcode;
        int pos = -1;
        IndexNode sibling;
        IndexNode child;

        IndexNode(byte[] byArray, int n) {
            this.name(byArray);
            this.pos = n;
        }

        static final IndexNode keyOf(byte[] byArray) {
            return new IndexNode(byArray, -1);
        }

        final void name(byte[] byArray) {
            this.name = byArray;
            this.hashcode = Arrays.hashCode(byArray);
        }

        final IndexNode as(byte[] byArray) {
            this.name(byArray);
            return this;
        }

        boolean isDir() {
            return this.name != null && (this.name.length == 0 || this.name[this.name.length - 1] == 47);
        }

        public boolean equals(Object object) {
            if (!(object instanceof IndexNode)) {
                return false;
            }
            return Arrays.equals(this.name, ((IndexNode)object).name);
        }

        public int hashCode() {
            return this.hashcode;
        }

        IndexNode() {
        }
    }

    static class END {
        int disknum;
        int sdisknum;
        int endsub;
        int centot;
        long cenlen;
        long cenoff;
        int comlen;
        byte[] comment;
        int diskNum;
        long endpos;
        int disktot;

        END() {
        }

        void write(OutputStream outputStream, long l) throws IOException {
            int n;
            boolean bl = false;
            long l2 = this.cenlen;
            long l3 = this.cenoff;
            if (l2 >= 0xFFFFFFFFL) {
                l2 = 0xFFFFFFFFL;
                bl = true;
            }
            if (l3 >= 0xFFFFFFFFL) {
                l3 = 0xFFFFFFFFL;
                bl = true;
            }
            if ((n = this.centot) >= 65535) {
                n = 65535;
                bl = true;
            }
            if (bl) {
                long l4 = l;
                ZipUtils.writeInt(outputStream, 101075792L);
                ZipUtils.writeLong(outputStream, 44L);
                ZipUtils.writeShort(outputStream, 45);
                ZipUtils.writeShort(outputStream, 45);
                ZipUtils.writeInt(outputStream, 0L);
                ZipUtils.writeInt(outputStream, 0L);
                ZipUtils.writeLong(outputStream, this.centot);
                ZipUtils.writeLong(outputStream, this.centot);
                ZipUtils.writeLong(outputStream, this.cenlen);
                ZipUtils.writeLong(outputStream, this.cenoff);
                ZipUtils.writeInt(outputStream, 117853008L);
                ZipUtils.writeInt(outputStream, 0L);
                ZipUtils.writeLong(outputStream, l4);
                ZipUtils.writeInt(outputStream, 1L);
            }
            ZipUtils.writeInt(outputStream, ZipConstants.ENDSIG);
            ZipUtils.writeShort(outputStream, 0);
            ZipUtils.writeShort(outputStream, 0);
            ZipUtils.writeShort(outputStream, n);
            ZipUtils.writeShort(outputStream, n);
            ZipUtils.writeInt(outputStream, l2);
            ZipUtils.writeInt(outputStream, l3);
            if (this.comment != null) {
                ZipUtils.writeShort(outputStream, this.comment.length);
                ZipUtils.writeBytes(outputStream, this.comment);
            } else {
                ZipUtils.writeShort(outputStream, 0);
            }
        }
    }

    class EntryOutputStream
    extends DeflaterOutputStream {
        private CRC32 crc;
        private Entry e;
        private long written;

        EntryOutputStream(Entry entry, OutputStream outputStream) throws IOException {
            super(outputStream, ZipFileSystem.this.getDeflater());
            if (entry == null) {
                throw new NullPointerException("Zip entry is null");
            }
            this.e = entry;
            this.crc = new CRC32();
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.e.type != 3) {
                ZipFileSystem.this.ensureOpen();
            }
            if (n < 0 || n2 < 0 || n > byArray.length - n2) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            switch (this.e.method) {
                case 8: {
                    super.write(byArray, n, n2);
                    break;
                }
                case 0: {
                    this.written += (long)n2;
                    this.out.write(byArray, n, n2);
                    break;
                }
                default: {
                    throw new ZipException("invalid compression method");
                }
            }
            this.crc.update(byArray, n, n2);
        }

        @Override
        public void close() throws IOException {
            switch (this.e.method) {
                case 8: {
                    this.finish();
                    this.e.size = this.def.getBytesRead();
                    this.e.csize = this.def.getBytesWritten();
                    this.e.crc = this.crc.getValue();
                    break;
                }
                case 0: {
                    this.e.size = this.e.csize = this.written;
                    this.e.crc = this.crc.getValue();
                    break;
                }
                default: {
                    throw new ZipException("invalid compression method");
                }
            }
            if (this.out instanceof ByteArrayOutputStream) {
                this.e.bytes = ((ByteArrayOutputStream)this.out).toByteArray();
            }
            if (this.e.type == 3) {
                ZipFileSystem.this.releaseDeflater(this.def);
                return;
            }
            super.close();
            ZipFileSystem.this.releaseDeflater(this.def);
            ZipFileSystem.this.update(this.e);
        }
    }

    private class EntryInputStream
    extends InputStream {
        private final SeekableByteChannel zfch;
        private long pos;
        protected long rem;
        protected final long size;

        EntryInputStream(Entry entry, SeekableByteChannel seekableByteChannel) throws IOException {
            this.zfch = seekableByteChannel;
            this.rem = entry.csize;
            this.size = entry.size;
            this.pos = ZipFileSystem.this.getDataPos(entry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            ZipFileSystem.this.ensureOpen();
            if (this.rem == 0L) {
                return -1;
            }
            if (n2 <= 0) {
                return 0;
            }
            if ((long)n2 > this.rem) {
                n2 = (int)this.rem;
            }
            long l = 0L;
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.position(n);
            byteBuffer.limit(n + n2);
            SeekableByteChannel seekableByteChannel = this.zfch;
            synchronized (seekableByteChannel) {
                l = this.zfch.position(this.pos).read(byteBuffer);
            }
            if (l > 0L) {
                this.pos += l;
                this.rem -= l;
            }
            if (this.rem == 0L) {
                this.close();
            }
            return (int)l;
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.read(byArray, 0, 1) == 1) {
                return byArray[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public long skip(long l) throws IOException {
            ZipFileSystem.this.ensureOpen();
            if (l > this.rem) {
                l = this.rem;
            }
            this.pos += l;
            this.rem -= l;
            if (this.rem == 0L) {
                this.close();
            }
            return l;
        }

        @Override
        public int available() {
            return this.rem > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.rem;
        }

        public long size() {
            return this.size;
        }

        @Override
        public void close() {
            this.rem = 0L;
            ZipFileSystem.this.streams.remove(this);
        }
    }
}

