# GNU Typist - improved typing tutor program for UNIX systems
# Copyright (C) 1998  Simon Baldwin (simonb@sco.com)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

#------------------------------------------------------------------------------
# Series N
#------------------------------------------------------------------------------
G:_N_MENU
*:_N_NO_MENU

#------------------------------------------------------------------------------
# Lesson N1
#------------------------------------------------------------------------------
*:N1
*:_N_S_N1
B:                             Lesson N1

*:_N_R_L0
T:
 :			Numeric Keypad Lessons
 :
 :The N series lessons are provided for practice with the numeric keys available
 :on the H89/H19 terminal.  You do not need to know how to touch type on the
 :standard keyboard in order to learn touch typing on a calculator keypad.  So,
 :you can begin this series right away.
 :
 :When entering numeric values, accuracy is usually more important than speed.
 :Take these lessons very slowly.  Speed will come naturally later.
 :
 :As with the standard keypad, you must start in the HOME position.  Place the
 :first three fingers of your right hand over the 4, 5, and 6 keys of the keypad.
 :(Your thumb and fifth finger are not used.)  Your fingers should be poised just
 :over the keys gently brushing them.  Use the thumb or any finger of your left
 :hand for other keys, such as the SPACE bar.
 :
 :After entering each line, hit the ENTER key with the 6-finger (the third finger
 :of your right hand).  Immediately return your finger to the 6 key.  It is very
 :important that you bring the finger back without looking.

I:Use your third finger only.
*:_N_R_L1
D:666666

I:Use your second finger for the 5.
*:_N_R_L2
D:6565656

I:Use your first finger for the 4.
*:_N_R_L3
D:666444555444666

I:Now let's try several lines.
*:_N_R_L4
S:666444666
 :444555666
 :555444555
 :666444666
 :646464646
 :656565656
 :445566555
 :456456456

I:Use your second finger for the period.
*:_N_R_L5
D:555...555

*:_N_R_L6
S:5.54.45.56.6
 :444.555
 :45.56.6
 :64.65.4
 :54.65.4

*:_N_R_L7
S:445566.654
 :654456.546
 :546546.564
 :554466.645
 :555444.666

I:Use your first finger for the 1-key.
*:_N_R_L8
D:444111444.444111444

*:_N_R_L9
S:111.444
 :414.141
 :456.546
 :415.164
 :541.146

I:Now, let's review the keys we've learned.
*:_N_R_L10
D:444555666111...555444666111

*:_N_R_L11
S:414.564
 :546.145
 :546.145
 :644.146
 :615.645
 :564.145
 :546.164
 :111.555
 :514.651

G:_N_E_N1

#------------------------------------------------------------------------------
# Lesson N2
#------------------------------------------------------------------------------
*:N2
*:_N_S_N2
B:                             Lesson N2

I:First, let's review the keys from lesson 1.
*:_N_R_L12
D:444.555.666.111.6541.6541

I:Use your 5-finger for the 2 key.
*:_N_R_L13
D:555222555.525.525.525

*:_N_R_L14
S:45.25
 :52.52
 :62.62
 :22.22
 :51.12
 :12.52
 :24.42

I:Use your 6-finger for the 3 key.
*:_N_R_L15
D:666333666.636.636

*:_N_R_L16
S:456.123
 :321.654
 :666.333
 :323.353
 :343.313
 :353.363
 :313.434

*:_N_R_L17
S:12.33
 :45.33
 :65.35
 :12.35
 :65.25
 :25.63
 :43.53
 :13.36
 :34.31

I:Use your 4-finger for the zero.
*:_N_R_L18
D:444000444.401.410

*:_N_R_L19
D:410.020.030.040.060.104

*:_N_R_L20
S:12.00
 :23.00
 :51.50
 :46.25
 :54.00
 :13.04

I:Use your 5-finger for the 8-key.
*:_N_R_L21
D:555888555.852.258

*:_N_R_L22
D:585.080.808.818.282

*:_N_R_L23
S:81.05
 :84.80
 :88.88
 :58.28
 :80.18
 :28.38

I:Use your 6-finger for the 9-key.
*:_N_R_L24
D:666999666.393.696

*:_N_R_L25
D:595.989.696.393.295

*:_N_R_L26
S:.91
 :.90
 :.94
 :.95
 :.96
 :.93
 :.90
 :.95

I:And, the last number is 7. (Use your 4-finger for it.)
*:_N_R_L27
D:444777444.0147.7410

*:_N_R_L28
D:767.737.797.727.707.717

*:_N_R_L29
D:1234567890.1234567890

*:_N_R_L30
S:17.19
 :71.70
 :19.37
 :57.07
 :71.37
 :27.72
 :37.73
 :76.67
 :45.17
 :70.07

*:_N_R_L31
S:75856
 :87237
 :21570
 :24870
 :47258
 :21573
 :21573
 :21584
 :35827

G:_N_E_N2

#------------------------------------------------------------------------------
# Lesson N3
#------------------------------------------------------------------------------
*:N3
*:_N_S_N3
B:                             Lesson N3

I:First, let's review all the numbers.
*:_N_R_L32
D:1234567890.0987654321

*:_N_R_L33
D:12.34.56.78.90.10.29.38.47.57

*:_N_R_L34
S:123.654
 :212.658
 :908.000
 :285.080
 :288.381
 :398.813
 :286.187
 :924.156
 :684.028
 :354.459
 :321.840

*:_N_R_L35
S:12345
 :35840
 :25874
 :93682
 :71489
 :31265
 :97824
 :28617
 :39715
 :17935
 :28460
 :52846
 :28469

*:_N_R_L36
S:1.00
 :2.05
 :3.50
 :4.52
 :5.81
 :6.95
 :7.00
 :8.45
 :9.50

*:_N_R_L37
S:879.359
 :286.498
 :357.159
 :654.852
 :159.357
 :571.392
 :284.293
 :231.879

*:_N_R_L38
S:100.200
 :258.246
 :369.741
 :123.987
 :582.714
 :239.900
 :273.194
 :372.973

I:Use any finger of your left hand for the SPACE bar.
*:_N_R_L39
D:111 222 333 444 555 666 777 888 999 000

*:_N_R_L40
S:123 654 879 264
 :128 364 928 187
 :987 234 681 287
 :357 159 671 077
 :350 950 137 940
 :320 487 364 197

*:_N_R_L41
S:82.01 35
 :28.50 12
 :50.00 79
 :40.25 37
 :82.50 19
 :99.95 61
 :12.95 87
 :40.00 55
 :64.50 99

G:_N_E_N3
#------------------------------------------------------------------------------
# Lesson series N jump tables
#------------------------------------------------------------------------------
*:_N_E_N1
Q: Do you want to continue to lesson N2 [Y/N] ? 
N:_N_MENU
G:_N_S_N2
*:_N_E_N2
Q: Do you want to continue to lesson N3 [Y/N] ? 
N:_N_MENU
G:_N_S_N3
*:_N_E_N3
G:_N_MENU

#------------------------------------------------------------------------------
# Lesson series N menu
#------------------------------------------------------------------------------
*:_N_MENU
B:                   Calculator keypad lessons
M: UP=_EXIT "The N series contains the following 3 lessons"
 :_N_S_N1 "Lesson N1     4 5 . 6 1"
 :_N_S_N2 "Lesson N2     2 3 0 8 9 7"
 :_N_S_N3 "Lesson N3     Practise"
*:_N_EXIT
#------------------------------------------------------------------------------
