/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.carrot2.shaded.guava.common.base.Predicate;
import org.carrot2.shaded.guava.common.base.Throwables;
import org.carrot2.util.attribute.AttributeBinder;
import org.carrot2.util.attribute.AttributeBindingException;

public class AttributeBinderInjector {
    public static void injectByType(Class<? extends Annotation> injectableMarker, final Map<Class<?>, Object> values, Object ... objects) {
        try {
            AttributeBinder.IAttributeBinderAction[] actions = new AttributeBinder.IAttributeBinderAction[]{new InjectByType(values)};
            for (Object o : objects) {
                if (o == null) continue;
                Predicate<Field> p = new Predicate<Field>(){

                    public boolean apply(Field field) {
                        return values.containsKey(field.getType());
                    }
                };
                AttributeBinder.bind(o, actions, p, injectableMarker);
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static class InjectByType
    implements AttributeBinder.IAttributeBinderAction {
        private final Map<Class<?>, Object> values;

        InjectByType(Map<Class<?>, Object> values) {
            this.values = values;
        }

        @Override
        public void performAction(AttributeBinder.BindingTracker bindingTracker, int level, Object object, Field field, Object value, Predicate<Field> predicate) throws InstantiationException {
            if (!Modifier.isStatic(field.getModifiers()) && this.values.containsKey(field.getType())) {
                if (!Modifier.isPublic(field.getModifiers())) {
                    throw AttributeBindingException.createWithNoKey("Could not assign to non-public field " + object.getClass().getName() + "#" + field.getName() + ", value " + value);
                }
                try {
                    field.set(object, this.values.get(field.getType()));
                }
                catch (Exception e) {
                    throw AttributeBindingException.createWithNoKey("Could not assign field " + object.getClass().getName() + "#" + field.getName() + " with value " + value, e);
                }
            }
        }
    }
}

