/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.TextPatchBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.LocalCommitExecutor;
import com.intellij.openapi.vcs.changes.patch.CreatePatchConfigurationPanel;
import com.intellij.openapi.vcs.changes.patch.PatchWriter;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.ui.UIBundle;
import com.intellij.util.ObjectUtils;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CreatePatchCommitExecutor
extends LocalCommitExecutor {
    private static final Logger LOG = Logger.getInstance(CreatePatchCommitExecutor.class);
    private static final String VCS_PATCH_PATH_KEY = "vcs.patch.path";
    private static final String VCS_PATCH_TO_CLIPBOARD = "vcs.patch.to.clipboard";
    private final Project myProject;

    public CreatePatchCommitExecutor(@NotNull Project project) {
        if (project == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    @Nls
    public String getActionText() {
        String string = VcsBundle.message((String)"action.name.create.patch", (Object[])new Object[0]);
        if (string == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String getHelpId() {
        return "reference.dialogs.vcs.patch.create";
    }

    public boolean supportsPartialCommit() {
        return true;
    }

    @NotNull
    public CommitSession createCommitSession(@NotNull CommitContext commitContext) {
        if (commitContext == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(2);
        }
        CommitSession commitSession = CreatePatchCommitExecutor.createCommitSession(this.myProject, new DefaultPatchBuilder(this.myProject), commitContext);
        if (commitSession == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(3);
        }
        return commitSession;
    }

    public static CommitSession createCommitSession(@NotNull Project project, @NotNull PatchBuilder patchBuilder, @NotNull CommitContext commitContext) {
        if (project == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(4);
        }
        if (patchBuilder == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(5);
        }
        if (commitContext == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(6);
        }
        return new CreatePatchCommitSession(project, commitContext, patchBuilder);
    }

    private static boolean checkIsFileValid(@NotNull Project project, @NotNull File file) {
        if (project == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(7);
        }
        if (file == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(8);
        }
        if (file.exists()) {
            int[] result2 = new int[1];
            WaitForProgressToShow.runOrInvokeAndWaitAboveProgress(() -> {
                result2[0] = Messages.showYesNoDialog((Project)project, (String)VcsBundle.message((String)"patch.apply.already.exists.overwrite.prompt", (Object[])new Object[]{file.getName(), file.getParent()}), (String)VcsBundle.message((String)"patch.creation.save.patch.file.title", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.overwrite", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
            });
            if (1 == result2[0]) {
                return false;
            }
        }
        if (file.getParentFile() == null) {
            WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)project, (String)VcsBundle.message((String)"create.patch.error.title", (Object[])new Object[]{VcsBundle.message((String)"patch.creation.can.not.write.patch.error", (Object[])new Object[]{file.getPath()})}), (String)CommonBundle.getErrorTitle()), (ModalityState)ModalityState.NON_MODAL, (Project)project);
            return false;
        }
        return true;
    }

    @NotNull
    private static String getDefaultPatchPath(@NotNull Project project) {
        String baseDir;
        if (project == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(9);
        }
        String string = (baseDir = project.getBasePath()) == null ? FileUtil.toSystemIndependentName((String)PathManager.getHomePath()) : baseDir;
        if (string == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static Boolean showDialog(@NotNull Project project, @NotNull File file) {
        if (project == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(11);
        }
        if (file == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(12);
        }
        String message = VcsBundle.message((String)"create.patch.success.confirmation", (Object[])new Object[]{file.getPath()});
        String title2 = VcsBundle.message((String)"create.patch.commit.action.title", (Object[])new Object[0]);
        final Boolean[] ref = new Boolean[1];
        DialogWrapper.DoNotAskOption option2 = new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return true;
            }

            public void setToBeShown(boolean value, int exitCode) {
                if (!value) {
                    ref[0] = exitCode == 0;
                }
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return true;
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = UIBundle.message((String)"dialog.options.do.not.ask", (Object[])new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/CreatePatchCommitExecutor$1", "getDoNotShowMessage"));
            }
        };
        RevealFileAction.showDialog((Project)project, (String)message, (String)title2, (File)file, (DialogWrapper.DoNotAskOption)option2);
        return ref[0];
    }

    public static void writePatchToClipboard(@NotNull Project project, @NotNull String baseDir, @NotNull Collection<? extends Change> changes, boolean reversePatch, boolean honorExcludedFromCommit, @NotNull PatchBuilder patchBuilder, @NotNull CommitContext commitContext) throws VcsException, IOException {
        if (project == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(13);
        }
        if (baseDir == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(14);
        }
        if (changes == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(15);
        }
        if (patchBuilder == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(16);
        }
        if (commitContext == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(17);
        }
        List<FilePatch> patches = patchBuilder.buildPatches(baseDir, changes, reversePatch, honorExcludedFromCommit);
        PatchWriter.writeAsPatchToClipboard(project, patches, baseDir, commitContext);
        VcsNotifier.getInstance(project).notifySuccess(VcsBundle.message((String)"patch.copied.to.clipboard", (Object[])new Object[0]));
    }

    private static List<? extends FilePatch> createFilePatchesFromShelf(@NotNull Project project, String basePath, @NotNull ShelvedChangeList shelvedList, @Nullable Collection<String> selectedPaths) {
        if (project == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(18);
        }
        if (shelvedList == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(19);
        }
        try {
            List textFilePatches = ShelveChangesManager.loadPatches(project, shelvedList.PATH, null);
            List result2 = !ContainerUtil.isEmpty(selectedPaths) ? ContainerUtil.filter(textFilePatches, patch -> selectedPaths.contains(patch.getAfterName())) : textFilePatches;
            CreatePatchCommitExecutor.mapPatchesToNewBase(Objects.requireNonNull(project.getBasePath()), basePath, result2);
            return result2;
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
            return Collections.emptyList();
        }
    }

    private static void mapPatchesToNewBase(@NotNull String oldBase, @NotNull String newBase, @NotNull List<? extends FilePatch> patches) {
        if (oldBase == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(20);
        }
        if (newBase == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(21);
        }
        if (patches == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(22);
        }
        for (FilePatch filePatch : patches) {
            filePatch.setBeforeName(filePatch.getBeforeName() == null ? null : TextPatchBuilder.getRelativePath(newBase, new File(oldBase, filePatch.getBeforeName()).getPath()));
            filePatch.setAfterName(filePatch.getAfterFileName() == null ? null : TextPatchBuilder.getRelativePath(newBase, new File(oldBase, filePatch.getAfterName()).getPath()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/CreatePatchCommitExecutor";
                break;
            }
            case 2: 
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitContext";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchBuilder";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedList";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldBase";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBase";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/CreatePatchCommitExecutor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommitSession";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPatchPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCommitSession";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkIsFileValid";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPatchPath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "writePatchToClipboard";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createFilePatchesFromShelf";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "mapPatchesToNewBase";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ShelfPatchBuilder
    implements PatchBuilder {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ShelvedChangeList myShelvedChangeList;
        @NotNull
        private final List<String> mySelectedPaths;

        public ShelfPatchBuilder(@NotNull Project project, @NotNull ShelvedChangeList shelvedChangeList, @NotNull List<String> selectedPaths) {
            if (project == null) {
                ShelfPatchBuilder.$$$reportNull$$$0(0);
            }
            if (shelvedChangeList == null) {
                ShelfPatchBuilder.$$$reportNull$$$0(1);
            }
            if (selectedPaths == null) {
                ShelfPatchBuilder.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myShelvedChangeList = shelvedChangeList;
            this.mySelectedPaths = selectedPaths;
        }

        @Override
        public boolean isReverseSupported() {
            return false;
        }

        @Override
        public List<FilePatch> buildPatches(String baseDir, @NotNull Collection<? extends Change> changes, boolean reversePatch, boolean honorExcludedFromCommit) throws VcsException {
            if (changes == null) {
                ShelfPatchBuilder.$$$reportNull$$$0(3);
            }
            ArrayList<FilePatch> result2 = new ArrayList<FilePatch>(CreatePatchCommitExecutor.createFilePatchesFromShelf(this.myProject, baseDir, this.myShelvedChangeList, this.mySelectedPaths));
            List binaries = ContainerUtil.isEmpty(this.mySelectedPaths) ? this.myShelvedChangeList.getBinaryFiles() : ContainerUtil.filter(this.myShelvedChangeList.getBinaryFiles(), binary -> this.mySelectedPaths.contains(ObjectUtils.chooseNotNull((Object)binary.AFTER_PATH, (Object)binary.BEFORE_PATH)));
            result2.addAll(IdeaTextPatchBuilder.buildPatch(this.myProject, ContainerUtil.map((Collection)binaries, b -> b.createChange(this.myProject)), baseDir, reversePatch));
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shelvedChangeList";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedPaths";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/CreatePatchCommitExecutor$ShelfPatchBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildPatches";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DefaultPatchBuilder
    implements PatchBuilder {
        private final Project myProject;

        public DefaultPatchBuilder(@NotNull Project project) {
            if (project == null) {
                DefaultPatchBuilder.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @Override
        public List<FilePatch> buildPatches(String baseDir, @NotNull Collection<? extends Change> changes, boolean reversePatch, boolean honorExcludedFromCommit) throws VcsException {
            if (changes == null) {
                DefaultPatchBuilder.$$$reportNull$$$0(1);
            }
            return IdeaTextPatchBuilder.buildPatch(this.myProject, changes, baseDir, reversePatch, honorExcludedFromCommit);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/CreatePatchCommitExecutor$DefaultPatchBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildPatches";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface PatchBuilder {
        default public boolean isReverseSupported() {
            return true;
        }

        public List<FilePatch> buildPatches(String var1, @NotNull Collection<? extends Change> var2, boolean var3, boolean var4) throws VcsException;
    }

    private static class CreatePatchCommitSession
    implements CommitSession {
        @NotNull
        private final Project myProject;
        @NotNull
        private final CommitContext myCommitContext;
        @NotNull
        private final PatchBuilder myPatchBuilder;
        private final CreatePatchConfigurationPanel myPanel;

        private CreatePatchCommitSession(@NotNull Project project, @NotNull CommitContext commitContext, @NotNull PatchBuilder patchBuilder) {
            if (project == null) {
                CreatePatchCommitSession.$$$reportNull$$$0(0);
            }
            if (commitContext == null) {
                CreatePatchCommitSession.$$$reportNull$$$0(1);
            }
            if (patchBuilder == null) {
                CreatePatchCommitSession.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myCommitContext = commitContext;
            this.myPatchBuilder = patchBuilder;
            this.myPanel = new CreatePatchConfigurationPanel(this.myProject);
        }

        public JComponent getAdditionalConfigurationUI(@NotNull Collection<Change> changes, @Nullable String commitMessage2) {
            String patchPath;
            if (changes == null) {
                CreatePatchCommitSession.$$$reportNull$$$0(3);
            }
            if ((patchPath = StringUtil.nullize((String)PropertiesComponent.getInstance((Project)this.myProject).getValue(CreatePatchCommitExecutor.VCS_PATCH_PATH_KEY))) == null && (patchPath = VcsApplicationSettings.getInstance().PATCH_STORAGE_LOCATION) == null) {
                patchPath = CreatePatchCommitExecutor.getDefaultPatchPath(this.myProject);
            }
            this.myPanel.setFileName(ShelveChangesManager.suggestPatchName(this.myProject, commitMessage2, new File(patchPath), null));
            this.myPanel.setToClipboard(PropertiesComponent.getInstance((Project)this.myProject).getBoolean(CreatePatchCommitExecutor.VCS_PATCH_TO_CLIPBOARD, false));
            File commonAncestor = ChangesUtil.findCommonAncestor(changes);
            this.myPanel.setCommonParentPath(commonAncestor);
            this.myPanel.selectBasePath(PatchWriter.calculateBaseForWritingPatch(this.myProject, changes));
            this.myPanel.setReversePatch(false);
            this.myPanel.setReverseEnabledAndVisible(this.myPatchBuilder.isReverseSupported());
            JComponent panel2 = this.myPanel.getPanel();
            panel2.putClientProperty("Vcs.SessionDialog.title", VcsBundle.message((String)"create.patch.settings.dialog.title", (Object[])new Object[0]));
            return panel2;
        }

        public boolean canExecute(Collection<Change> changes, String commitMessage2) {
            return this.myPanel.isOkToExecute();
        }

        public void execute(@NotNull Collection<Change> changes, @Nullable String commitMessage2) {
            if (changes == null) {
                CreatePatchCommitSession.$$$reportNull$$$0(4);
            }
            PropertiesComponent.getInstance((Project)this.myProject).setValue(CreatePatchCommitExecutor.VCS_PATCH_TO_CLIPBOARD, this.myPanel.isToClipboard());
            try {
                String baseDir = this.myPanel.getBaseDirName();
                boolean isReverse = this.myPanel.isReversePatch();
                String fileName = this.myPanel.getFileName();
                Charset encoding = this.myPanel.getEncoding();
                if (this.myPanel.isToClipboard()) {
                    CreatePatchCommitExecutor.writePatchToClipboard(this.myProject, baseDir, changes, isReverse, true, this.myPatchBuilder, this.myCommitContext);
                } else {
                    CreatePatchCommitSession.validateAndWritePatchToFile(this.myProject, baseDir, changes, isReverse, fileName, encoding, this.myPatchBuilder, this.myCommitContext);
                }
            }
            catch (VcsException | IOException ex) {
                LOG.info(ex);
                WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> this.lambda$execute$0((Exception)ex), null, (Project)this.myProject);
            }
        }

        public static void validateAndWritePatchToFile(@NotNull Project project, @NotNull String baseDir, @NotNull Collection<? extends Change> changes, boolean reversePatch, @NotNull String fileName, @NotNull Charset encoding, @NotNull PatchBuilder patchBuilder, @NotNull CommitContext commitContext) throws VcsException, IOException {
            File file;
            if (project == null) {
                CreatePatchCommitSession.$$$reportNull$$$0(5);
            }
            if (baseDir == null) {
                CreatePatchCommitSession.$$$reportNull$$$0(6);
            }
            if (changes == null) {
                CreatePatchCommitSession.$$$reportNull$$$0(7);
            }
            if (fileName == null) {
                CreatePatchCommitSession.$$$reportNull$$$0(8);
            }
            if (encoding == null) {
                CreatePatchCommitSession.$$$reportNull$$$0(9);
            }
            if (patchBuilder == null) {
                CreatePatchCommitSession.$$$reportNull$$$0(10);
            }
            if (commitContext == null) {
                CreatePatchCommitSession.$$$reportNull$$$0(11);
            }
            if (!CreatePatchCommitExecutor.checkIsFileValid(project, file = new File(fileName).getAbsoluteFile())) {
                return;
            }
            file.getParentFile().mkdirs();
            VcsConfiguration.getInstance((Project)project).acceptLastCreatedPatchName(file.getName());
            String patchPath = FileUtil.toSystemIndependentName((String)StringUtil.notNullize((String)file.getParent()));
            String valueToStore = StringUtil.isEmpty((String)patchPath) || patchPath.equals(CreatePatchCommitExecutor.getDefaultPatchPath(project)) ? null : patchPath;
            PropertiesComponent.getInstance((Project)project).setValue(CreatePatchCommitExecutor.VCS_PATCH_PATH_KEY, valueToStore);
            VcsApplicationSettings.getInstance().PATCH_STORAGE_LOCATION = valueToStore;
            List<FilePatch> patches = patchBuilder.buildPatches(baseDir, changes, reversePatch, true);
            PatchWriter.writePatches(project, fileName, baseDir, patches, commitContext, encoding, true);
            WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> {
                VcsConfiguration configuration = VcsConfiguration.getInstance((Project)project);
                if (Boolean.TRUE.equals(configuration.SHOW_PATCH_IN_EXPLORER)) {
                    RevealFileAction.openFile((File)file);
                } else if (configuration.SHOW_PATCH_IN_EXPLORER == null) {
                    configuration.SHOW_PATCH_IN_EXPLORER = CreatePatchCommitExecutor.showDialog(project, file);
                }
            }, null, (Project)project);
        }

        @Nullable
        public ValidationInfo validateFields() {
            return this.myPanel.validateFields();
        }

        @Nullable
        public String getHelpId() {
            return "reference.dialogs.PatchFileSettings";
        }

        private /* synthetic */ void lambda$execute$0(Exception ex) {
            Messages.showErrorDialog((Project)this.myProject, (String)VcsBundle.message((String)"create.patch.error.title", (Object[])new Object[]{ex.getMessage()}), (String)CommonBundle.getErrorTitle());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitContext";
                    break;
                }
                case 2: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patchBuilder";
                    break;
                }
                case 3: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseDir";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "encoding";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/CreatePatchCommitExecutor$CreatePatchCommitSession";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAdditionalConfigurationUI";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "validateAndWritePatchToFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

