/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class CompareRevisionsFromFileHistoryActionProvider
implements AnActionExtensionProvider {
    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareRevisionsFromFileHistoryActionProvider.$$$reportNull$$$0(0);
        }
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        return e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI) != null && filePath != null && !filePath.isDirectory();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareRevisionsFromFileHistoryActionProvider.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        if (project == null || filePath == null || filePath.isDirectory() || log == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (log.getSelectedCommits().size() >= 2) {
            e.getPresentation().setText(VcsLogBundle.messagePointer((String)"action.presentation.CompareRevisionsFromFileHistoryActionProvider.text.compare", (Object[])new Object[0]));
            e.getPresentation().setDescription(VcsLogBundle.messagePointer((String)"action.presentation.CompareRevisionsFromFileHistoryActionProvider.description.compare", (Object[])new Object[0]));
        } else {
            e.getPresentation().setText(VcsLogBundle.messagePointer((String)"action.presentation.CompareRevisionsFromFileHistoryActionProvider.text.show.diff", (Object[])new Object[0]));
            e.getPresentation().setDescription(VcsLogBundle.messagePointer((String)"action.presentation.CompareRevisionsFromFileHistoryActionProvider.description.show.diff", (Object[])new Object[0]));
        }
        e.getPresentation().setVisible(true);
        if (e.getInputEvent() instanceof KeyEvent) {
            e.getPresentation().setEnabled(true);
        } else {
            Change[] changes = (Change[])e.getData(VcsDataKeys.SELECTED_CHANGES);
            e.getPresentation().setEnabled(changes != null && changes.length == 1 && changes[0] != null);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareRevisionsFromFileHistoryActionProvider.$$$reportNull$$$0(2);
        }
        VcsLogUsageTriggerCollector.triggerUsage(e, this);
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        Change[] changes = (Change[])e.getData(VcsDataKeys.SELECTED_CHANGES);
        if (changes == null || changes.length != 1 || changes[0] == null) {
            return;
        }
        ShowDiffAction.showDiffForChange(project, Arrays.asList(changes));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/vcs/log/ui/actions/history/CompareRevisionsFromFileHistoryActionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isActive";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

