/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.plugincomponents;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.util.List;
import org.editorconfig.EditorConfigRegistry;
import org.editorconfig.configmanagement.EditorSettingsManager;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.jetbrains.annotations.NotNull;

public class EditorConfigModificationListener
implements BulkFileListener {
    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            EditorConfigModificationListener.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        for (VFileEvent vFileEvent : events) {
            VirtualFile file = vFileEvent.getFile();
            if (file == null || !file.getName().equals(".editorconfig")) continue;
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                if (!ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file) && EditorConfigRegistry.shouldStopAtProjectRoot()) continue;
                ApplicationManager.getApplication().invokeLater(() -> {
                    SettingsProviderComponent.getInstance().incModificationCount();
                    for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
                        if (editor.isDisposed()) continue;
                        EditorSettingsManager.applyEditorSettings(editor);
                        ((EditorEx)editor).reinitSettings();
                    }
                });
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/editorconfig/plugincomponents/EditorConfigModificationListener", "after"));
    }
}

