/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.plugincomponents;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import org.editorconfig.language.messages.EditorConfigBundle;

public class EditorConfigNotifier {
    public static final String LAST_NOTIFICATION_STATUS = "editorconfig.notification";
    public static final String GROUP_DISPLAY_ID = "editorconfig";

    public static EditorConfigNotifier getInstance() {
        return (EditorConfigNotifier)ServiceManager.getService(EditorConfigNotifier.class);
    }

    public void error(Project project, String id, String message2) {
        this.doNotify(project, id, message2, NotificationType.ERROR);
    }

    protected void doNotify(Project project, String id, String message2, NotificationType type) {
        String value = PropertiesComponent.getInstance((Project)project).getValue(LAST_NOTIFICATION_STATUS);
        if (id.equals(value)) {
            return;
        }
        Notifications.Bus.notify((Notification)new Notification(GROUP_DISPLAY_ID, EditorConfigBundle.message(GROUP_DISPLAY_ID), message2, type), (Project)project);
        PropertiesComponent.getInstance((Project)project).setValue(LAST_NOTIFICATION_STATUS, id);
    }
}

