/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.AbstractCoverageProjectViewNodeDecorator;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.ColoredTreeCellRenderer;
import org.jetbrains.annotations.NotNull;

final class CoverageProjectViewDirectoryNodeDecorator
extends AbstractCoverageProjectViewNodeDecorator {
    CoverageProjectViewDirectoryNodeDecorator(@NotNull Project project) {
        if (project == null) {
            CoverageProjectViewDirectoryNodeDecorator.$$$reportNull$$$0(0);
        }
        super(project);
    }

    public void decorate(PackageDependenciesNode node, ColoredTreeCellRenderer cellRenderer) {
        CoverageAnnotator coverageAnnotator;
        PsiElement element = node.getPsiElement();
        if (element == null || !element.isValid()) {
            return;
        }
        Project project = element.getProject();
        CoverageDataManager manager = this.getCoverageDataManager(project);
        if (manager == null) {
            return;
        }
        CoverageSuitesBundle currentSuite = manager.getCurrentSuitesBundle();
        CoverageAnnotator coverageAnnotator2 = coverageAnnotator = currentSuite != null ? currentSuite.getAnnotator(project) : null;
        if (coverageAnnotator == null) {
            return;
        }
        String informationString = null;
        if (element instanceof PsiDirectory) {
            informationString = coverageAnnotator.getDirCoverageInformationString((PsiDirectory)element, currentSuite, manager);
        } else if (element instanceof PsiFile) {
            informationString = coverageAnnotator.getFileCoverageInformationString((PsiFile)element, currentSuite, manager);
        }
        if (informationString != null) {
            CoverageProjectViewDirectoryNodeDecorator.appendCoverageInfo(cellRenderer, informationString);
        }
    }

    public void decorate(ProjectViewNode node, PresentationData data) {
        CoverageAnnotator coverageAnnotator;
        Project project = node.getProject();
        if (project == null) {
            return;
        }
        CoverageDataManager manager = this.getCoverageDataManager(project);
        if (manager == null) {
            return;
        }
        CoverageSuitesBundle currentSuite = manager.getCurrentSuitesBundle();
        CoverageAnnotator coverageAnnotator2 = coverageAnnotator = currentSuite == null ? null : currentSuite.getAnnotator(project);
        if (coverageAnnotator == null) {
            return;
        }
        Object value = node.getValue();
        PsiElement element = null;
        if (value instanceof PsiElement) {
            element = (PsiElement)value;
        } else if (value instanceof SmartPsiElementPointer) {
            element = ((SmartPsiElementPointer)value).getElement();
        }
        String informationString = null;
        if (element instanceof PsiDirectory) {
            informationString = coverageAnnotator.getDirCoverageInformationString((PsiDirectory)element, currentSuite, manager);
        } else if (element instanceof PsiFile) {
            informationString = coverageAnnotator.getFileCoverageInformationString((PsiFile)element, currentSuite, manager);
        }
        if (informationString != null) {
            data.setLocationString(informationString);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/coverage/CoverageProjectViewDirectoryNodeDecorator", "<init>"));
    }
}

