/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBranchUiHandlerImpl;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchWorker;
import git4idea.branch.GitNewBranchOptions;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.fetch.GitFetchResult;
import git4idea.fetch.GitFetchSupport;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.action.GHPRActionKeys;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataProvider;
import org.jetbrains.plugins.github.util.GithubSettings;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J0\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J&\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J2\u0010\u001f\u001a\u0004\u0018\u00010\u001c*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u00042\b\u0010!\u001a\u0004\u0018\u00010\u0004H\u0002R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/github/pullrequest/action/GHPRCreateBranchAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "httpForkUrl", "", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;", "getHttpForkUrl", "(Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;)Ljava/lang/String;", "sshForkUrl", "getSshForkUrl", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "generateSuggestedBranchName", "pullRequestNumber", "", "dataProvider", "trySetTrackingUpstreamBranch", "git", "Lgit4idea/commands/Git;", "repository", "Lgit4idea/repo/GitRepository;", "branchName", "ghPullRequest", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequest;", "update", "createRemote", "Lgit4idea/repo/GitRemote;", "remoteName", "url", "findOrCreateRemote", "httpUrl", "sshUrl", "intellij.vcs.github"})
public final class GHPRCreateBranchAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        GitRepository repository = (GitRepository)e.getData(GHPRActionKeys.getGIT_REPOSITORY());
        GHPRDataProvider selection2 = (GHPRDataProvider)e.getData(GHPRActionKeys.getPULL_REQUEST_DATA_PROVIDER());
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(project != null && !project.isDefault() && selection2 != null && repository != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Object object = e.getRequiredData(CommonDataKeys.PROJECT);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"e.getRequiredData(CommonDataKeys.PROJECT)");
        Project project = (Project)object;
        Object object2 = e.getRequiredData(GHPRActionKeys.getGIT_REPOSITORY());
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"e.getRequiredData(GHPRActionKeys.GIT_REPOSITORY)");
        GitRepository repository = (GitRepository)object2;
        Object object3 = e.getRequiredData(GHPRActionKeys.getPULL_REQUEST_DATA_PROVIDER());
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"e.getRequiredData(GHPRAc\u2026LL_REQUEST_DATA_PROVIDER)");
        GHPRDataProvider dataProvider = (GHPRDataProvider)object3;
        long pullRequestNumber = dataProvider.getId().getNumber();
        GitNewBranchOptions gitNewBranchOptions = GitBranchUtil.getNewBranchNameFromUser((Project)project, (Collection)CollectionsKt.listOf((Object)repository), (String)GithubBundle.message("pull.request.branch.checkout.create.dialog.title", pullRequestNumber), (String)this.generateSuggestedBranchName(pullRequestNumber, dataProvider), (boolean)true);
        if (gitNewBranchOptions == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)gitNewBranchOptions, (String)"GitBranchUtil.getNewBran\u2026rovider), true) ?: return");
        GitNewBranchOptions options = gitNewBranchOptions;
        if (!options.shouldCheckout()) {
            new Task.Backgroundable(this, dataProvider, project, options, repository, project, GithubBundle.message("pull.request.branch.checkout.create.task.title", new Object[0]), true){
                private final Git git;
                final /* synthetic */ GHPRCreateBranchAction this$0;
                final /* synthetic */ GHPRDataProvider $dataProvider;
                final /* synthetic */ Project $project;
                final /* synthetic */ GitNewBranchOptions $options;
                final /* synthetic */ GitRepository $repository;

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                    GHPullRequest ghPullRequest = (GHPullRequest)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)this.$dataProvider.getDetailsData().loadDetails(), (ProgressIndicator)indicator);
                    String sha = ghPullRequest.getHeadRefOid();
                    ProgressIndicatorUtils.awaitWithCheckCanceled((Future)this.$dataProvider.getChangesData().fetchHeadBranch(), (ProgressIndicator)indicator);
                    indicator.setText(GithubBundle.message("pull.request.branch.checkout.create.task.indicator", new Object[0]));
                    new GitBranchWorker(this.$project, this.git, (GitBranchUiHandler)new GitBranchUiHandlerImpl(this.$project, this.git, indicator)).createBranch(this.$options.getName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)this.$repository, (Object)sha)));
                    if (this.$options.shouldSetTracking()) {
                        String string = this.$options.getName();
                        GHPullRequest gHPullRequest = ghPullRequest;
                        Intrinsics.checkExpressionValueIsNotNull((Object)gHPullRequest, (String)"ghPullRequest");
                        GHPRCreateBranchAction.access$trySetTrackingUpstreamBranch(this.this$0, this.git, this.$repository, this.$dataProvider, string, gHPullRequest);
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$dataProvider = $captured_local_variable$1;
                    this.$project = $captured_local_variable$2;
                    this.$options = $captured_local_variable$3;
                    this.$repository = $captured_local_variable$4;
                    super($super_call_param$5, $super_call_param$6, $super_call_param$7);
                    Git git = Git.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)git, (String)"Git.getInstance()");
                    this.git = git;
                }
            }.queue();
        } else {
            new Task.Backgroundable(this, dataProvider, project, options, repository, project, GithubBundle.message("pull.request.branch.checkout.task.title", new Object[0]), true){
                private final Git git;
                final /* synthetic */ GHPRCreateBranchAction this$0;
                final /* synthetic */ GHPRDataProvider $dataProvider;
                final /* synthetic */ Project $project;
                final /* synthetic */ GitNewBranchOptions $options;
                final /* synthetic */ GitRepository $repository;

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                    GHPullRequest ghPullRequest = (GHPullRequest)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)this.$dataProvider.getDetailsData().loadDetails(), (ProgressIndicator)indicator);
                    String sha = ghPullRequest.getHeadRefOid();
                    ProgressIndicatorUtils.awaitWithCheckCanceled((Future)this.$dataProvider.getChangesData().fetchHeadBranch(), (ProgressIndicator)indicator);
                    indicator.setText(GithubBundle.message("pull.request.branch.checkout.task.indicator", new Object[0]));
                    new GitBranchWorker(this.$project, this.git, (GitBranchUiHandler)new GitBranchUiHandlerImpl(this.$project, this.git, indicator)).checkoutNewBranchStartingFrom(this.$options.getName(), sha, CollectionsKt.listOf((Object)this.$repository));
                    if (this.$options.shouldSetTracking()) {
                        String string = this.$options.getName();
                        GHPullRequest gHPullRequest = ghPullRequest;
                        Intrinsics.checkExpressionValueIsNotNull((Object)gHPullRequest, (String)"ghPullRequest");
                        GHPRCreateBranchAction.access$trySetTrackingUpstreamBranch(this.this$0, this.git, this.$repository, this.$dataProvider, string, gHPullRequest);
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$dataProvider = $captured_local_variable$1;
                    this.$project = $captured_local_variable$2;
                    this.$options = $captured_local_variable$3;
                    this.$repository = $captured_local_variable$4;
                    super($super_call_param$5, $super_call_param$6, $super_call_param$7);
                    Git git = Git.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)git, (String)"Git.getInstance()");
                    this.git = git;
                }
            }.queue();
        }
    }

    private final String generateSuggestedBranchName(long pullRequestNumber, GHPRDataProvider dataProvider) {
        Object object = dataProvider.getDetailsData().getLoadedDetails();
        if (object == null || (object = ((GHPullRequest)object).getHeadRefName()) == null) {
            object = "pull/" + pullRequestNumber;
        }
        return object;
    }

    private final void trySetTrackingUpstreamBranch(Git git, GitRepository repository, GHPRDataProvider dataProvider, String branchName, GHPullRequest ghPullRequest) {
        Project project;
        Project project2 = repository.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"repository.project");
        Project $this$service$iv = project = project2;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(VcsNotifier.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getService(T::class.java)");
        VcsNotifier vcsNotifier = (VcsNotifier)object;
        GHActor pullRequestAuthor = ghPullRequest.getAuthor();
        if (pullRequestAuthor == null) {
            vcsNotifier.notifyError(GithubBundle.message("pull.request.branch.checkout.set.tracking.branch.failed", new Object[0]), GithubBundle.message("pull.request.branch.checkout.resolve.author.failed", new Object[0]));
            return;
        }
        String httpForkUrl = this.getHttpForkUrl(dataProvider);
        String sshForkUrl = this.getSshForkUrl(dataProvider);
        GitRemote forkRemote = this.findOrCreateRemote(git, repository, pullRequestAuthor.getLogin(), httpForkUrl, sshForkUrl);
        if (forkRemote == null) {
            String string = GithubBundle.message("pull.request.branch.checkout.resolve.remote.failed", new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GithubBundle.message(\"pu\u2026t.resolve.remote.failed\")");
            String failedMessage = string;
            if (httpForkUrl != null) {
                failedMessage = failedMessage + '\n' + httpForkUrl;
            }
            if (sshForkUrl != null) {
                failedMessage = failedMessage + '\n' + sshForkUrl;
            }
            vcsNotifier.notifyError(GithubBundle.message("pull.request.branch.checkout.set.tracking.branch.failed", new Object[0]), failedMessage);
            return;
        }
        String forkBranchName = forkRemote.getName() + '/' + ghPullRequest.getHeadRefName();
        GitFetchResult gitFetchResult = GitFetchSupport.fetchSupport((Project)project).fetch(repository, forkRemote, ghPullRequest.getHeadRefName());
        Intrinsics.checkExpressionValueIsNotNull((Object)gitFetchResult, (String)"GitFetchSupport.fetchSup\u2026hPullRequest.headRefName)");
        GitFetchResult fetchResult = gitFetchResult;
        if (fetchResult.showNotificationIfFailed(GithubBundle.message("pull.request.branch.checkout.set.tracking.branch.failed", new Object[0]))) {
            GitCommandResult gitCommandResult = git.setUpstream(repository, forkBranchName, branchName);
            Intrinsics.checkExpressionValueIsNotNull((Object)gitCommandResult, (String)"git.setUpstream(reposito\u2026rkBranchName, branchName)");
            GitCommandResult setUpstream = gitCommandResult;
            if (!setUpstream.success()) {
                vcsNotifier.notifyError(GithubBundle.message("pull.request.branch.checkout.set.tracking.branch.failed", new Object[0]), setUpstream.getErrorOutputAsJoinedString());
            }
        }
    }

    private final GitRemote findOrCreateRemote(@NotNull Git $this$findOrCreateRemote, GitRepository repository, String remoteName, String httpUrl, String sshUrl) {
        String sshOrHttpUrl;
        Object v2;
        GitRemote it;
        block7: {
            Collection collection = repository.getRemotes();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"repository.remotes");
            Iterable iterable = collection;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                it = (GitRemote)t;
                boolean bl3 = false;
                GitRemote gitRemote = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)gitRemote, (String)"it");
                if (!(gitRemote.getFirstUrl() != null && (Intrinsics.areEqual((Object)it.getFirstUrl(), (Object)httpUrl) || Intrinsics.areEqual((Object)it.getFirstUrl(), (Object)sshUrl)))) continue;
                v2 = t;
                break block7;
            }
            v2 = null;
        }
        GitRemote existingRemote = v2;
        if (existingRemote != null) {
            return existingRemote;
        }
        GithubSettings githubSettings = GithubSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)githubSettings, (String)"GithubSettings.getInstance()");
        boolean useSshUrl = githubSettings.isCloneGitUsingSsh();
        String string = sshOrHttpUrl = useSshUrl ? sshUrl : httpUrl;
        if (sshOrHttpUrl != null) {
            boolean bl;
            block8: {
                Collection collection = repository.getRemotes();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"repository.remotes");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (GitRemote)element$iv;
                        boolean bl4 = false;
                        GitRemote gitRemote = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)gitRemote, (String)"it");
                        if (!Intrinsics.areEqual((Object)gitRemote.getName(), (Object)remoteName)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return this.createRemote($this$findOrCreateRemote, repository, "pull_" + remoteName, sshOrHttpUrl);
            }
        }
        return useSshUrl && sshUrl != null ? this.createRemote($this$findOrCreateRemote, repository, remoteName, sshUrl) : (!useSshUrl && httpUrl != null ? this.createRemote($this$findOrCreateRemote, repository, remoteName, httpUrl) : (sshUrl != null ? this.createRemote($this$findOrCreateRemote, repository, remoteName, sshUrl) : (httpUrl != null ? this.createRemote($this$findOrCreateRemote, repository, remoteName, httpUrl) : null)));
    }

    private final GitRemote createRemote(@NotNull Git $this$createRemote, GitRepository repository, String remoteName, String url) {
        Object v2;
        block1: {
            boolean bl = false;
            boolean bl2 = false;
            GitRepository $this$with = repository;
            boolean bl3 = false;
            $this$createRemote.addRemote($this$with, remoteName, url);
            $this$with.update();
            Collection collection = $this$with.getRemotes();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"remotes");
            Iterable iterable = collection;
            boolean bl4 = false;
            Iterable iterable2 = iterable;
            boolean bl5 = false;
            for (Object t : iterable2) {
                GitRemote it = (GitRemote)t;
                boolean bl6 = false;
                GitRemote gitRemote = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)gitRemote, (String)"it");
                if (!Intrinsics.areEqual((Object)gitRemote.getName(), (Object)remoteName)) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    private final String getHttpForkUrl(@NotNull GHPRDataProvider $this$httpForkUrl) {
        Object object = $this$httpForkUrl.getDetailsData().getLoadedDetails();
        return object != null && (object = ((GHPullRequest)object).getHeadRepository()) != null ? ((GHPullRequest.HeadRepository)object).getUrl() : null;
    }

    private final String getSshForkUrl(@NotNull GHPRDataProvider $this$sshForkUrl) {
        Object object = $this$sshForkUrl.getDetailsData().getLoadedDetails();
        return object != null && (object = ((GHPullRequest)object).getHeadRepository()) != null ? ((GHPullRequest.HeadRepository)object).getSshUrl() : null;
    }

    public GHPRCreateBranchAction() {
        super(GithubBundle.messagePointer("pull.request.branch.checkout.create.action", new Object[0]), GithubBundle.messagePointer("pull.request.branch.checkout.create.action.description", new Object[0]), null);
    }

    public static final /* synthetic */ void access$trySetTrackingUpstreamBranch(GHPRCreateBranchAction $this, Git git, GitRepository repository, GHPRDataProvider dataProvider, String branchName, GHPullRequest ghPullRequest) {
        $this.trySetTrackingUpstreamBranch(git, repository, dataProvider, branchName, ghPullRequest);
    }
}

