/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.actions.GitMergeAction;
import git4idea.branch.GitRebaseParams;
import git4idea.commands.GitCommand;
import git4idea.commands.GitImpl;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVersionSpecialty;
import git4idea.i18n.GitBundle;
import git4idea.pull.GitPullDialog;
import git4idea.pull.PullOption;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class GitPull
extends GitMergeAction {
    private static final Logger LOG = Logger.getInstance(GitPull.class);

    @Override
    @NotNull
    protected String getActionName() {
        String string = GitBundle.getString("pull.action.name");
        if (string == null) {
            GitPull.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected GitMergeAction.DialogState displayDialog(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot) {
        GitPullDialog dialog2;
        if (project == null) {
            GitPull.$$$reportNull$$$0(1);
        }
        if (gitRoots == null) {
            GitPull.$$$reportNull$$$0(2);
        }
        if (defaultRoot == null) {
            GitPull.$$$reportNull$$$0(3);
        }
        if (!(dialog2 = new GitPullDialog(project, gitRoots, defaultRoot)).showAndGet()) {
            return null;
        }
        GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(project);
        GitRepository repository = (GitRepository)repositoryManager.getRepositoryForRootQuick(dialog2.gitRoot());
        assert (repository != null) : "Repository can't be null for root " + dialog2.gitRoot();
        return new GitMergeAction.DialogState(dialog2.gitRoot(), GitBundle.message("pulling.title", dialog2.getSelectedRemote().getName()), this.getHandlerProvider(project, dialog2), dialog2.getSelectedBranches(), dialog2.isCommitAfterMerge(), ContainerUtil.map(dialog2.getSelectedOptions(), option -> option.getOption()));
    }

    @Override
    protected void perform(@NotNull GitMergeAction.DialogState dialogState, @NotNull Project project) {
        if (dialogState == null) {
            GitPull.$$$reportNull$$$0(4);
        }
        if (project == null) {
            GitPull.$$$reportNull$$$0(5);
        }
        if (!dialogState.selectedOptions.contains(PullOption.REBASE.getOption())) {
            super.perform(dialogState, project);
        } else {
            GitPull.performRebase(project, dialogState);
        }
    }

    private static void performRebase(final @NotNull Project project, GitMergeAction.DialogState dialogState) {
        if (project == null) {
            GitPull.$$$reportNull$$$0(6);
        }
        final VirtualFile selectedRoot = dialogState.selectedRoot;
        final String selectedBranch = dialogState.selectedBranches.get(0);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, GitBundle.getString("rebase.progress.indicator.title")){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                GitRepository selectedRepository = Objects.requireNonNull((GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForRoot(selectedRoot));
                GitRebaseParams rebaseParams = new GitRebaseParams(GitVcs.getInstance(project).getVersion(), selectedBranch);
                GitRebaseUtils.rebase(project, Collections.singletonList(selectedRepository), rebaseParams, indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/actions/GitPull$1", "run"));
            }
        });
    }

    @Override
    protected boolean shouldSetupRebaseEditor(@NotNull Project project, VirtualFile selectedRoot) {
        if (project == null) {
            GitPull.$$$reportNull$$$0(7);
        }
        String value = null;
        try {
            value = GitConfigUtil.getValue(project, selectedRoot, "pull.rebase");
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
        }
        return "interactive".equals(value);
    }

    @NotNull
    protected Supplier<GitLineHandler> getHandlerProvider(Project project, GitPullDialog dialog2) {
        GitRemote remote = dialog2.getSelectedRemote();
        String remoteName = remote.getName();
        VirtualFile root = dialog2.gitRoot();
        Set<PullOption> selectedOptions = dialog2.getSelectedOptions();
        List<String> selectedBranches = dialog2.getSelectedBranches();
        Supplier<GitLineHandler> supplier = () -> {
            List<String> urls = remote.getUrls();
            GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.PULL, GitImpl.REBASE_CONFIG_PARAMS);
            h2.setUrls(urls);
            h2.addParameters("--no-stat");
            for (PullOption option : selectedOptions) {
                h2.addParameters(option.getOption());
            }
            h2.addParameters("-v");
            if (GitVersionSpecialty.ABLE_TO_USE_PROGRESS_IN_REMOTE_COMMANDS.existsIn(project)) {
                h2.addParameters("--progress");
            }
            h2.addParameters(remoteName);
            for (String branch : selectedBranches) {
                h2.addParameters(branch);
            }
            return h2;
        };
        if (supplier == null) {
            GitPull.$$$reportNull$$$0(8);
        }
        return supplier;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/actions/GitPull";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRoots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultRoot";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/actions/GitPull";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandlerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "displayDialog";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performRebase";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shouldSetupRebaseEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

