/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgContentRevision;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgResolveCommand;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgPromptCommandExecutor;
import org.zmlx.hg4idea.util.HgUtil;

public class HgMergeProvider
implements MergeProvider {
    private static final Logger LOG = Logger.getInstance((String)HgMergeProvider.class.getName());
    private final Project myProject;

    public HgMergeProvider(Project project) {
        this.myProject = project;
    }

    @NotNull
    public MergeData loadRevisions(@NotNull VirtualFile file) throws VcsException {
        HgContentRevision base;
        HgRevisionNumber serverRevisionNumber;
        if (file == null) {
            HgMergeProvider.$$$reportNull$$$0(0);
        }
        MergeData mergeData = new MergeData();
        HgWorkingCopyRevisionsCommand command = new HgWorkingCopyRevisionsCommand(this.myProject);
        VirtualFile repo = HgUtil.getHgRootOrThrow(this.myProject, file);
        HgFile hgFile = new HgFile(this.myProject, file);
        HgRevisionNumber baseRevisionNumber = null;
        if (this.wasFileCheckedIn(repo, file)) {
            Couple<HgRevisionNumber> parents = command.parents(repo, file);
            serverRevisionNumber = (HgRevisionNumber)parents.second;
            HgRevisionNumber localRevisionNumber = (HgRevisionNumber)parents.first;
            HgContentRevision local = HgContentRevision.create(this.myProject, hgFile, localRevisionNumber);
            mergeData.CURRENT = local.getContentAsBytes();
            ArrayList<String> arguments = new ArrayList<String>();
            String localChangeset = localRevisionNumber.getChangeset();
            String serverChangeset = serverRevisionNumber.getChangeset();
            arguments.add(StringUtil.isEmptyOrSpaces((String)localChangeset) ? localRevisionNumber.getRevision() : localChangeset);
            arguments.add(StringUtil.isEmptyOrSpaces((String)serverChangeset) ? serverRevisionNumber.getRevision() : serverChangeset);
            HgCommandResult result = new HgPromptCommandExecutor(this.myProject).executeInCurrentThread(repo, "debugancestor", arguments);
            if (result != null) {
                String output = result.getRawOutput();
                List parts = StringUtil.split((String)output, (String)":");
                if (parts.size() < 2) {
                    LOG.info("Couldn't parse result of debugancestor command execution " + arguments);
                    new HgCommandResultNotifier(this.myProject).notifyError(null, HgBundle.message("hg4idea.error.debugancestor.command.execution", new Object[0]), HgBundle.message("hg4idea.error.debugancestor.command.description", new Object[0]));
                } else {
                    baseRevisionNumber = HgRevisionNumber.getInstance((String)parts.get(0), (String)parts.get(1));
                }
            } else {
                LOG.info(HgBundle.message("hg4idea.error.debugancestor.command.execution", new Object[0]) + arguments);
                new HgCommandResultNotifier(this.myProject).notifyError(null, HgBundle.message("hg4idea.error.debugancestor.command.execution", new Object[0]), HgBundle.message("hg4idea.error.debugancestor.command.description", new Object[0]));
            }
        } else {
            serverRevisionNumber = (HgRevisionNumber)command.parents((VirtualFile)repo, (VirtualFile)file).first;
            baseRevisionNumber = (HgRevisionNumber)command.parents((VirtualFile)repo, (VirtualFile)file, (HgRevisionNumber)serverRevisionNumber).first;
            File origFile = new File(file.getPath() + ".orig");
            mergeData.CURRENT = VcsUtil.getFileByteContent((File)origFile);
        }
        mergeData.ORIGINAL = baseRevisionNumber != null ? ((base = HgContentRevision.create(this.myProject, hgFile, baseRevisionNumber)).getContent() != null ? base.getContentAsBytes() : ArrayUtilRt.EMPTY_BYTE_ARRAY) : ArrayUtilRt.EMPTY_BYTE_ARRAY;
        HgContentRevision server = HgContentRevision.create(this.myProject, hgFile, serverRevisionNumber);
        mergeData.LAST = server.getContentAsBytes();
        file.refresh(false, false);
        MergeData mergeData2 = mergeData;
        if (mergeData2 == null) {
            HgMergeProvider.$$$reportNull$$$0(1);
        }
        return mergeData2;
    }

    public void conflictResolvedForFile(@NotNull VirtualFile file) {
        if (file == null) {
            HgMergeProvider.$$$reportNull$$$0(2);
        }
        try {
            new HgResolveCommand(this.myProject).markResolved(HgUtil.getHgRootOrThrow(this.myProject, file), file);
        }
        catch (VcsException e) {
            LOG.error("Couldn't mark file resolved, because it is not under Mercurial root.");
        }
    }

    public boolean isBinary(@NotNull VirtualFile file) {
        if (file == null) {
            HgMergeProvider.$$$reportNull$$$0(3);
        }
        return file.getFileType().isBinary();
    }

    private boolean wasFileCheckedIn(VirtualFile repo, VirtualFile file) {
        Couple<HgRevisionNumber> parents = new HgWorkingCopyRevisionsCommand(this.myProject).parents(repo, file);
        return parents.second != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/provider/HgMergeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/provider/HgMergeProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRevisions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadRevisions";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "conflictResolvedForFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isBinary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

