/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyAddExceptionSuperClassQuickFix;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.types.PyClassLikeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyExceptionInheritInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyExceptionInheritInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyExceptionInheritInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyExceptionInheritInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyRaiseStatement(PyRaiseStatement node) {
            PsiPolyVariantReference reference;
            PsiElement psiElement;
            PyExpression callee;
            PyExpression[] expressions = node.getExpressions();
            if (expressions.length == 0) {
                return;
            }
            PyExpression expression = expressions[0];
            if (expression instanceof PyCallExpression && (callee = ((PyCallExpression)expression).getCallee()) instanceof PyReferenceExpression && (psiElement = (reference = ((PyReferenceExpression)callee).getReference(this.getResolveContext())).resolve()) instanceof PyClass) {
                PyClass aClass = (PyClass)psiElement;
                for (PyClassLikeType type : aClass.getAncestorTypes(this.myTypeEvalContext)) {
                    if (type == null) {
                        return;
                    }
                    String name = type.getName();
                    if (name != null && !"BaseException".equals(name) && !"Exception".equals(name)) continue;
                    return;
                }
                this.registerProblem((PsiElement)expression, "Exception doesn't inherit from base 'Exception' class", new PyAddExceptionSuperClassQuickFix());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyExceptionInheritInspection$Visitor", "<init>"));
        }
    }
}

