/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.SingleAlarm;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

class StatusBarUpdater
implements Disposable {
    private final Project myProject;
    private final SingleAlarm myAlarm;
    private static final HighlightSeverity MIN = new HighlightSeverity("min", HighlightSeverity.INFORMATION.myVal + 1);

    StatusBarUpdater(Project project) {
        this.myProject = project;
        this.myAlarm = new SingleAlarm(() -> this.updateStatus(), 100, this);
        project.getMessageBus().connect((Disposable)this).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                StatusBarUpdater.this.updateLater();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/StatusBarUpdater$1", "selectionChanged"));
            }
        });
        project.getMessageBus().connect((Disposable)this).subscribe(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC, (Object)new DaemonCodeAnalyzer.DaemonListener(){

            public void daemonFinished() {
                StatusBarUpdater.this.updateLater();
            }
        });
    }

    private void updateLater() {
        this.myAlarm.cancelAndRequest();
    }

    public void dispose() {
    }

    private void updateStatus() {
        Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
        if (editor == null || !editor.getContentComponent().hasFocus()) {
            return;
        }
        Document document = editor.getDocument();
        if (document.isInBulkUpdate()) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        DaemonCodeAnalyzer codeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)this.myProject);
        HighlightInfo info = ((DaemonCodeAnalyzerImpl)codeAnalyzer).findHighlightByOffset(document, offset, false, MIN);
        String text = info != null && info.getDescription() != null ? info.getDescription() : "";
        StatusBar statusBar = WindowManager.getInstance().getStatusBar((Component)editor.getContentComponent(), this.myProject);
        if (statusBar != null && !text.equals(statusBar.getInfo())) {
            statusBar.setInfo(text, "updater");
        }
    }
}

