/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@Deprecated
public class CreateFileFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final int REFRESH_INTERVAL = 1000;
    private final boolean myIsDirectory;
    private final String myNewFileName;
    private final String myText;
    @PropertyKey(resourceBundle="messages.CodeInsightBundle")
    @NotNull
    private final String myKey;
    private boolean myIsAvailable;
    private long myIsAvailableTimeStamp;

    public CreateFileFix(boolean isDirectory, @NotNull String newFileName, @NotNull PsiDirectory directory, @Nullable String text, @PropertyKey(resourceBundle="messages.CodeInsightBundle") @NotNull String key) {
        if (newFileName == null) {
            CreateFileFix.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            CreateFileFix.$$$reportNull$$$0(1);
        }
        if (key == null) {
            CreateFileFix.$$$reportNull$$$0(2);
        }
        super((PsiElement)directory);
        this.myIsDirectory = isDirectory;
        this.myNewFileName = newFileName;
        this.myText = text;
        this.myKey = key;
        this.myIsAvailable = isDirectory || !FileTypeManager.getInstance().getFileTypeByFileName(newFileName).isBinary();
        this.myIsAvailableTimeStamp = System.currentTimeMillis();
    }

    public CreateFileFix(@NotNull String newFileName, @NotNull PsiDirectory directory, String text) {
        if (newFileName == null) {
            CreateFileFix.$$$reportNull$$$0(3);
        }
        if (directory == null) {
            CreateFileFix.$$$reportNull$$$0(4);
        }
        this(false, newFileName, directory, text, "create.file.text");
    }

    public CreateFileFix(boolean isDirectory, @NotNull String newFileName, @NotNull PsiDirectory directory) {
        if (newFileName == null) {
            CreateFileFix.$$$reportNull$$$0(5);
        }
        if (directory == null) {
            CreateFileFix.$$$reportNull$$$0(6);
        }
        this(isDirectory, newFileName, directory, null, isDirectory ? "create.directory.text" : "create.file.text");
    }

    @Nullable
    protected String getFileText() {
        return this.myText;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)this.myKey, (Object[])new Object[]{this.myNewFileName});
        if (string == null) {
            CreateFileFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"create.file.family", (Object[])new Object[0]);
        if (string == null) {
            CreateFileFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        if (file2 == null) {
            CreateFileFix.$$$reportNull$$$0(9);
        }
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            CreateFileFix.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            CreateFileFix.$$$reportNull$$$0(11);
        }
        if (startElement == null) {
            CreateFileFix.$$$reportNull$$$0(12);
        }
        if (endElement == null) {
            CreateFileFix.$$$reportNull$$$0(13);
        }
        if (this.isAvailable(project, null, file2)) {
            this.invoke(project, (PsiDirectory)startElement);
        }
    }

    public void applyFix() {
        this.invoke(this.myStartElement.getProject(), (PsiDirectory)this.myStartElement.getElement());
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            CreateFileFix.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            CreateFileFix.$$$reportNull$$$0(15);
        }
        if (startElement == null) {
            CreateFileFix.$$$reportNull$$$0(16);
        }
        if (endElement == null) {
            CreateFileFix.$$$reportNull$$$0(17);
        }
        PsiDirectory myDirectory = (PsiDirectory)startElement;
        long current2 = System.currentTimeMillis();
        if (ApplicationManager.getApplication().isUnitTestMode() || current2 - this.myIsAvailableTimeStamp > 1000L) {
            this.myIsAvailable &= myDirectory.getVirtualFile().findChild(this.myNewFileName) == null;
            this.myIsAvailableTimeStamp = current2;
        }
        return this.myIsAvailable;
    }

    private void invoke(@NotNull Project project, PsiDirectory myDirectory) throws IncorrectOperationException {
        block10: {
            if (project == null) {
                CreateFileFix.$$$reportNull$$$0(18);
            }
            this.myIsAvailableTimeStamp = 0L;
            try {
                if (this.myIsDirectory) {
                    myDirectory.createSubdirectory(this.myNewFileName);
                    break block10;
                }
                String newFileName = this.myNewFileName;
                String newDirectories = null;
                if (this.myNewFileName.contains("/")) {
                    int pos = this.myNewFileName.lastIndexOf(47);
                    newFileName = this.myNewFileName.substring(pos + 1);
                    newDirectories = this.myNewFileName.substring(0, pos);
                }
                PsiDirectory directory = myDirectory;
                if (newDirectories != null) {
                    try {
                        VfsUtil.createDirectoryIfMissing((VirtualFile)myDirectory.getVirtualFile(), newDirectories);
                        VirtualFile vfsDir = VfsUtil.findRelativeFile((VirtualFile)myDirectory.getVirtualFile(), (String[])ArrayUtil.toStringArray((Collection)StringUtil.split(newDirectories, (String)"/")));
                        PsiDirectory psiDirectory = directory = vfsDir == null ? null : myDirectory.getManager().findDirectory(vfsDir);
                        if (directory == null) {
                            throw new IOException("Couldn't create directory '" + newDirectories + "'");
                        }
                    }
                    catch (IOException e) {
                        throw new IncorrectOperationException(e.getMessage());
                    }
                }
                PsiFile newFile = directory.createFile(newFileName);
                String text = this.getFileText();
                if (text != null) {
                    FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(newFileName);
                    PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("_" + newFileName, type, (CharSequence)text);
                    PsiElement psiElement = CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiFile);
                    text = psiElement.getText();
                }
                this.openFile(project, directory, newFile, text);
            }
            catch (IncorrectOperationException e) {
                this.myIsAvailable = false;
            }
        }
    }

    protected void openFile(@NotNull Project project, PsiDirectory directory, PsiFile newFile, String text) {
        if (project == null) {
            CreateFileFix.$$$reportNull$$$0(19);
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)directory.getProject());
        FileEditor[] fileEditors = editorManager.openFile(newFile.getVirtualFile(), true);
        if (text != null) {
            for (FileEditor fileEditor : fileEditors) {
                if (!(fileEditor instanceof TextEditor)) continue;
                Document document = ((TextEditor)fileEditor).getEditor().getDocument();
                document.setText((CharSequence)text);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    FileDocumentManager.getInstance().saveDocument(document);
                }
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                break;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileName";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/quickFix/CreateFileFix";
                break;
            }
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/quickFix/CreateFileFix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "openFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

