/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.intellij.BundleBase;
import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.lang.LangBundle;
import com.intellij.lang.javascript.boilerplate.AbstractGithubTagDownloadedProjectGenerator;
import com.intellij.lang.javascript.boilerplate.GithubTagListProvider;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.platform.templates.github.GithubTagInfo;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.ReloadableComboBoxPanel;
import com.intellij.util.ui.ReloadablePanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GithubProjectGeneratorPeer
implements WebProjectGenerator.GeneratorPeer<GithubTagInfo> {
    private final List<WebProjectGenerator.SettingsStateListener> myListeners;
    private final GithubTagInfo myMasterTag;
    private final GithubTagListProvider myTagListProvider;
    private JComponent myComponent;
    private JPanel myVersionPanel;
    private ReloadablePanel<GithubTagInfo> myReloadableComboBoxPanel;

    public static String getGithubZipballUrl(String ghUserName, String ghRepoName, String branch) {
        return String.format("https://github.com/%s/%s/zipball/%s", ghUserName, ghRepoName, branch);
    }

    private void createUIComponents() {
        this.myReloadableComboBoxPanel = new ReloadableComboBoxPanel<GithubTagInfo>(){

            @Override
            protected void doUpdateValues(@NotNull Set<GithubTagInfo> tags) {
                if (tags == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!this.shouldUpdate(tags)) {
                    return;
                }
                List sortedTags = GithubProjectGeneratorPeer.createSortedTagList(tags);
                GithubTagInfo selectedItem = (GithubTagInfo)this.getSelectedValue();
                if (selectedItem == null && sortedTags.size() > 0) {
                    selectedItem = (GithubTagInfo)sortedTags.get(0);
                }
                this.myComboBox.removeAllItems();
                this.myComboBox.addItem(GithubProjectGeneratorPeer.this.myMasterTag);
                for (GithubTagInfo tag2 : sortedTags) {
                    this.myComboBox.addItem(tag2);
                }
                if (selectedItem != null) {
                    for (int i2 = 0; i2 < this.myComboBox.getItemCount(); ++i2) {
                        GithubTagInfo item = GithubTagInfo.tryCast(this.myComboBox.getItemAt(i2));
                        if (item == null || !item.getName().equals(selectedItem.getName())) continue;
                        this.myComboBox.setSelectedIndex(i2);
                        break;
                    }
                }
                this.myComboBox.updateUI();
                GithubProjectGeneratorPeer.this.fireStateChanged();
            }

            private boolean shouldUpdate(Set<GithubTagInfo> newTags) {
                if (this.myComboBox.getItemCount() == 0) {
                    return true;
                }
                int count = this.myComboBox.getItemCount();
                HashSet<GithubTagInfo> oldTags = new HashSet<GithubTagInfo>();
                for (int i2 = 1; i2 < count; ++i2) {
                    GithubTagInfo item = (GithubTagInfo)ObjectUtils.tryCast(this.myComboBox.getItemAt(i2), GithubTagInfo.class);
                    if (item == null) continue;
                    oldTags.add(item);
                }
                return !oldTags.equals(newTags);
            }

            @Override
            @NotNull
            protected JComboBox<GithubTagInfo> createValuesComboBox() {
                JComboBox<GithubTagInfo> box = super.createValuesComboBox();
                box.setRenderer((ListCellRenderer<GithubTagInfo>)SimpleListCellRenderer.create((label2, tag2, index) -> {
                    String text = tag2 == null ? (this.isBackgroundJobRunning() ? CommonBundle.getLoadingTreeNodeText() : LangBundle.message((String)"label.unavailable", (Object[])new Object[0])) : tag2.getName();
                    label2.setText(text);
                }));
                JComboBox<GithubTagInfo> jComboBox = box;
                if (jComboBox == null) {
                    1.$$$reportNull$$$0(1);
                }
                return jComboBox;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tags";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/boilerplate/GithubProjectGeneratorPeer$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/boilerplate/GithubProjectGeneratorPeer$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createValuesComboBox";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doUpdateValues";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myVersionPanel = this.myReloadableComboBoxPanel.getMainPanel();
    }

    public GithubProjectGeneratorPeer(@NotNull AbstractGithubTagDownloadedProjectGenerator generator) {
        if (generator == null) {
            GithubProjectGeneratorPeer.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.myListeners = new ArrayList<WebProjectGenerator.SettingsStateListener>();
        String ghUserName = generator.getGithubUserName();
        String ghRepoName = generator.getGithubRepositoryName();
        this.myMasterTag = new GithubTagInfo("master", GithubProjectGeneratorPeer.getGithubZipballUrl(ghUserName, ghRepoName, "master"));
        this.myTagListProvider = new GithubTagListProvider(ghUserName, ghRepoName);
        this.myReloadableComboBoxPanel.setDataProvider(new ReloadablePanel.DataProvider<GithubTagInfo>(){

            @Override
            public Set<GithubTagInfo> getCachedValues() {
                return GithubProjectGeneratorPeer.this.myTagListProvider.getCachedTags();
            }

            @Override
            public void updateValuesAsynchronously() {
                GithubProjectGeneratorPeer.this.myTagListProvider.updateTagListAsynchronously(GithubProjectGeneratorPeer.this);
            }
        });
        this.myReloadableComboBoxPanel.reloadValuesInBackground();
    }

    void onTagsUpdated(@NotNull Set<GithubTagInfo> tags) {
        if (tags == null) {
            GithubProjectGeneratorPeer.$$$reportNull$$$0(1);
        }
        this.myReloadableComboBoxPanel.onUpdateValues(tags);
    }

    void onTagsUpdateError(@NotNull String errorMessage) {
        if (errorMessage == null) {
            GithubProjectGeneratorPeer.$$$reportNull$$$0(2);
        }
        this.myReloadableComboBoxPanel.onValuesUpdateError(errorMessage);
    }

    @NotNull
    private static List<GithubTagInfo> createSortedTagList(@NotNull Collection<? extends GithubTagInfo> tags) {
        if (tags == null) {
            GithubProjectGeneratorPeer.$$$reportNull$$$0(3);
        }
        ArrayList<GithubTagInfo> sortedTags = new ArrayList<GithubTagInfo>(tags);
        sortedTags.sort((tag1, tag2) -> {
            GithubTagInfo.Version v1 = tag1.getVersion();
            GithubTagInfo.Version v2 = tag2.getVersion();
            return v2.compareTo(v1);
        });
        for (GithubTagInfo tag3 : sortedTags) {
            tag3.setRecentTag(false);
        }
        if (!sortedTags.isEmpty()) {
            ((GithubTagInfo)sortedTags.get(0)).setRecentTag(true);
        }
        ArrayList<GithubTagInfo> arrayList = sortedTags;
        if (arrayList == null) {
            GithubProjectGeneratorPeer.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            GithubProjectGeneratorPeer.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    @Override
    public void buildUI(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            GithubProjectGeneratorPeer.$$$reportNull$$$0(6);
        }
        settingsStep.addSettingsField(BundleBase.replaceMnemonicAmpersand((String)IdeBundle.message((String)"github.project.generator.version", (Object[])new Object[0])), (JComponent)this.myVersionPanel);
        settingsStep.addSettingsComponent((JComponent)this.myReloadableComboBoxPanel.getErrorComponent());
    }

    @Override
    @NotNull
    public GithubTagInfo getSettings() {
        GithubTagInfo tag2 = this.myReloadableComboBoxPanel.getSelectedValue();
        if (tag2 == null) {
            throw new RuntimeException("[internal error] No versions available.");
        }
        GithubTagInfo githubTagInfo = tag2;
        if (githubTagInfo == null) {
            GithubProjectGeneratorPeer.$$$reportNull$$$0(7);
        }
        return githubTagInfo;
    }

    @Override
    @Nullable
    public ValidationInfo validate() {
        GithubTagInfo tag2 = this.myReloadableComboBoxPanel.getSelectedValue();
        if (tag2 != null) {
            return null;
        }
        String errorMessage = StringUtil.notNullize((String)this.myReloadableComboBoxPanel.getErrorComponent().getText());
        if (errorMessage.isEmpty()) {
            errorMessage = IdeBundle.message((String)"github.project.generator.versions.not.loaded.error", (Object[])new Object[0]);
        }
        return new ValidationInfo(errorMessage);
    }

    @Override
    public boolean isBackgroundJobRunning() {
        return this.myReloadableComboBoxPanel.isBackgroundJobRunning();
    }

    @Override
    public void addSettingsStateListener(@NotNull WebProjectGenerator.SettingsStateListener listener2) {
        if (listener2 == null) {
            GithubProjectGeneratorPeer.$$$reportNull$$$0(8);
        }
        this.myListeners.add(listener2);
    }

    private void fireStateChanged() {
        GithubTagInfo tag2 = this.myReloadableComboBoxPanel.getSelectedValue();
        for (WebProjectGenerator.SettingsStateListener listener2 : this.myListeners) {
            listener2.stateChanged(tag2 != null);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        this.createUIComponents();
        JPanel jPanel2 = new JPanel();
        this.myComponent = jPanel2;
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = this.myVersionPanel;
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/LangBundle", GithubProjectGeneratorPeer.class).getString("label.github.project.version"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myComponent;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/boilerplate/GithubProjectGeneratorPeer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/boilerplate/GithubProjectGeneratorPeer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSortedTagList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onTagsUpdated";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onTagsUpdateError";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSortedTagList";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildUI";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addSettingsStateListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

