/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.Nullable;

public final class StartMarkAction
extends BasicUndoableAction {
    public static final Key<StartMarkAction> START_MARK_ACTION_KEY = Key.create((String)"current.inplace.refactorings.mark");
    private String myCommandName;
    private boolean myGlobal;
    private Document myDocument;

    private StartMarkAction(Editor editor, String commandName) {
        super(new DocumentReference[]{DocumentReferenceManager.getInstance().create(editor.getDocument())});
        this.myCommandName = commandName;
        this.myDocument = editor.getDocument();
    }

    public void undo() {
    }

    public void redo() {
    }

    public void setGlobal(boolean global) {
        this.myGlobal = global;
    }

    public boolean isGlobal() {
        return this.myGlobal;
    }

    public String getCommandName() {
        return this.myCommandName;
    }

    public void setCommandName(String commandName) {
        this.myCommandName = commandName;
    }

    public Document getDocument() {
        return this.myDocument;
    }

    public static void checkCleared(@Nullable Project project) {
        if (project == null) {
            return;
        }
        try {
            StartMarkAction markAction = (StartMarkAction)((Object)project.getUserData(START_MARK_ACTION_KEY));
            assert (markAction == null) : markAction.myDocument;
        }
        finally {
            project.putUserData(START_MARK_ACTION_KEY, null);
        }
    }

    public static StartMarkAction start(Editor editor, Project project, String commandName) throws AlreadyStartedException {
        StartMarkAction existingMark = (StartMarkAction)((Object)project.getUserData(START_MARK_ACTION_KEY));
        if (existingMark != null) {
            throw new AlreadyStartedException(existingMark.myCommandName, existingMark.myDocument, existingMark.getAffectedDocuments());
        }
        StartMarkAction markAction = new StartMarkAction(editor, commandName);
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)markAction);
        project.putUserData(START_MARK_ACTION_KEY, (Object)markAction);
        return markAction;
    }

    public static StartMarkAction canStart(Project project) {
        return (StartMarkAction)((Object)project.getUserData(START_MARK_ACTION_KEY));
    }

    static void markFinished(Project project) {
        StartMarkAction existingMark = (StartMarkAction)((Object)project.getUserData(START_MARK_ACTION_KEY));
        if (existingMark != null) {
            project.putUserData(START_MARK_ACTION_KEY, null);
            existingMark.myDocument = null;
        }
    }

    public static class AlreadyStartedException
    extends Exception {
        private final DocumentReference[] myAffectedDocuments;
        private final Document myDocument;

        public AlreadyStartedException(String commandName, Document document, DocumentReference[] documentRefs) {
            super("Unable to start inplace refactoring:\n" + IdeBundle.message((String)"dialog.message.command.not.finished.yet", (Object[])new Object[]{commandName}));
            this.myAffectedDocuments = documentRefs;
            this.myDocument = document;
        }

        public DocumentReference[] getAffectedDocuments() {
            return this.myAffectedDocuments;
        }

        public Document getDocument() {
            return this.myDocument;
        }
    }
}

