/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.autoimport.AsyncFileChangeListenerBase;
import com.intellij.openapi.externalSystem.autoimport.ProjectStatus;
import com.intellij.openapi.externalSystem.autoimport.changes.FilesChangesListener;
import com.intellij.openapi.externalSystem.autoimport.changes.FilesChangesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0014J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/changes/VirtualFilesChangesProvider;", "Lcom/intellij/openapi/externalSystem/autoimport/changes/FilesChangesProvider;", "Lcom/intellij/openapi/externalSystem/autoimport/AsyncFileChangeListenerBase;", "isIgnoreUpdatesFromSave", "", "(Z)V", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/openapi/externalSystem/autoimport/changes/FilesChangesListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "processRecursively", "getProcessRecursively", "()Z", "apply", "", "init", "isRelevant", "path", "", "subscribe", "listener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "updateFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "intellij.platform.externalSystem.impl"})
public final class VirtualFilesChangesProvider
extends AsyncFileChangeListenerBase
implements FilesChangesProvider {
    private final EventDispatcher<FilesChangesListener> eventDispatcher;
    private final boolean processRecursively = false;
    private final boolean isIgnoreUpdatesFromSave;

    @Override
    public void subscribe(@NotNull FilesChangesListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        this.eventDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @Override
    protected boolean getProcessRecursively() {
        return this.processRecursively;
    }

    @Override
    protected void init() {
        ((FilesChangesListener)this.eventDispatcher.getMulticaster()).init();
    }

    @Override
    protected void apply() {
        ((FilesChangesListener)this.eventDispatcher.getMulticaster()).apply();
    }

    @Override
    protected boolean isRelevant(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return true;
    }

    @Override
    protected void updateFile(@NotNull VirtualFile file2, @NotNull VFileEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (this.isIgnoreUpdatesFromSave && event.isFromSave()) {
            return;
        }
        ProjectStatus.ModificationType modificationType = event.isFromRefresh() ? ProjectStatus.ModificationType.EXTERNAL : ProjectStatus.ModificationType.INTERNAL;
        FilesChangesListener filesChangesListener = (FilesChangesListener)this.eventDispatcher.getMulticaster();
        String string = file2.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
        filesChangesListener.onFileChange(string, file2.getModificationStamp(), modificationType);
    }

    public VirtualFilesChangesProvider(boolean isIgnoreUpdatesFromSave) {
        this.isIgnoreUpdatesFromSave = isIgnoreUpdatesFromSave;
        EventDispatcher eventDispatcher = EventDispatcher.create(FilesChangesListener.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)eventDispatcher, (String)"EventDispatcher.create(F\u2026ngesListener::class.java)");
        this.eventDispatcher = eventDispatcher;
    }
}

