/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.util.ObjectUtils;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public final class LargeFileEditorProvider
extends TextEditorProvider {
    @Override
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            LargeFileEditorProvider.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            LargeFileEditorProvider.$$$reportNull$$$0(1);
        }
        return TextEditorProvider.isTextFile(file2) && SingleRootFileViewProvider.isTooLargeForContentLoading(file2) && (!Experiments.getInstance().isFeatureEnabled("new.large.text.file.viewer") || file2.getFileType().isBinary() || !file2.isInLocalFileSystem());
    }

    @Override
    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            LargeFileEditorProvider.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            LargeFileEditorProvider.$$$reportNull$$$0(3);
        }
        return file2.getFileType().isBinary() ? new LargeBinaryFileEditor(file2) : new LargeTextFileEditor(project, file2, this);
    }

    @Override
    @NotNull
    public String getEditorTypeId() {
        return "LargeFileEditor";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LargeBinaryFileEditor
    extends UserDataHolderBase
    implements FileEditor {
        private final VirtualFile myFile;

        LargeBinaryFileEditor(VirtualFile file2) {
            this.myFile = file2;
        }

        @NotNull
        public JComponent getComponent() {
            JLabel label2 = new JLabel(IdeBundle.message((String)"label.binary.file.0.is.too.large.1", (Object[])new Object[]{this.myFile.getPath(), StringUtil.formatFileSize((long)this.myFile.getLength())}));
            label2.setHorizontalAlignment(0);
            JLabel jLabel = label2;
            if (jLabel == null) {
                LargeBinaryFileEditor.$$$reportNull$$$0(0);
            }
            return jLabel;
        }

        public JComponent getPreferredFocusedComponent() {
            return null;
        }

        @NotNull
        public String getName() {
            return "Large file editor";
        }

        @NotNull
        public FileEditorState getState(@NotNull FileEditorStateLevel level) {
            if (level == null) {
                LargeBinaryFileEditor.$$$reportNull$$$0(1);
            }
            return new TextEditorState();
        }

        public void setState(@NotNull FileEditorState state) {
            if (state == null) {
                LargeBinaryFileEditor.$$$reportNull$$$0(2);
            }
        }

        public boolean isModified() {
            return false;
        }

        public boolean isValid() {
            return this.myFile.isValid();
        }

        public void selectNotify() {
        }

        public void deselectNotify() {
        }

        public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
            if (listener2 == null) {
                LargeBinaryFileEditor.$$$reportNull$$$0(3);
            }
        }

        public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
            if (listener2 == null) {
                LargeBinaryFileEditor.$$$reportNull$$$0(4);
            }
        }

        public BackgroundEditorHighlighter getBackgroundHighlighter() {
            return null;
        }

        public FileEditorLocation getCurrentLocation() {
            return null;
        }

        public StructureViewBuilder getStructureViewBuilder() {
            return null;
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider$LargeBinaryFileEditor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider$LargeBinaryFileEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getState";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setState";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addPropertyChangeListener";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "removePropertyChangeListener";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class LargeTextFileEditor
    extends TextEditorImpl {
        LargeTextFileEditor(@NotNull Project project, @NotNull VirtualFile file2, @NotNull TextEditorProvider provider) {
            if (project == null) {
                LargeTextFileEditor.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                LargeTextFileEditor.$$$reportNull$$$0(1);
            }
            if (provider == null) {
                LargeTextFileEditor.$$$reportNull$$$0(2);
            }
            super(project, file2, provider);
            ObjectUtils.consumeIfCast((Object)this.getEditor(), EditorEx.class, editorEx -> editorEx.setViewer(true));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "provider";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/fileEditor/impl/text/LargeFileEditorProvider$LargeTextFileEditor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

