/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ide.plugins.ContainerDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.ModuleStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleScopeProvider;
import com.intellij.openapi.module.impl.NonPersistentModuleStore;
import com.intellij.openapi.module.impl.scopes.ModuleScopeProviderImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelElement;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleImpl
extends ComponentManagerImpl
implements ModuleEx {
    private static final Logger LOG = Logger.getInstance(ModuleImpl.class);
    @NotNull
    private final Project myProject;
    @Nullable
    private final VirtualFilePointer myImlFilePointer;
    private volatile boolean isModuleAdded;
    private String myName;
    private final ModuleScopeProvider myModuleScopeProvider;

    @ApiStatus.Internal
    public ModuleImpl(@NotNull String name, @NotNull Project project, @Nullable String filePath) {
        if (name == null) {
            ModuleImpl.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ModuleImpl.$$$reportNull$$$0(1);
        }
        super((ComponentManagerImpl)project);
        this.registerServiceInstance(Module.class, this, (PluginDescriptor)ComponentManagerImpl.getFakeCorePluginDescriptor());
        this.myProject = project;
        this.myModuleScopeProvider = new ModuleScopeProviderImpl(this);
        this.myName = name;
        this.myImlFilePointer = filePath == null ? null : VirtualFilePointerManager.getInstance().create(VfsUtilCore.pathToUrl((String)filePath), (Disposable)this, new VirtualFilePointerListener(){

            public void validityChanged(@NotNull @NotNull VirtualFilePointer @NotNull [] pointers2) {
                VirtualFile virtualFile;
                if (pointers2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((virtualFile = ModuleImpl.this.myImlFilePointer.getFile()) != null) {
                    ((ModuleStore)ModuleImpl.this.getStore()).setPath(virtualFile.toNioPath(), virtualFile, false);
                    ModuleManager.getInstance((Project)ModuleImpl.this.myProject).incModificationCount();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/openapi/module/impl/ModuleImpl$1", "validityChanged"));
            }
        });
    }

    @Override
    public void init(@Nullable Runnable beforeComponentCreation) {
        this.registerComponents(PluginManagerCore.getLoadedPlugins());
        if (!this.isPersistent()) {
            this.registerService(IComponentStore.class, NonPersistentModuleStore.class, (PluginDescriptor)Objects.requireNonNull(PluginManagerCore.getPlugin(PluginManagerCore.CORE_ID), "Could not find plugin by id: " + PluginManagerCore.CORE_ID), true);
        }
        if (beforeComponentCreation != null) {
            beforeComponentCreation.run();
        }
        this.createComponents(null);
    }

    private boolean isPersistent() {
        return this.myImlFilePointer != null;
    }

    protected void setProgressDuringInit(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ModuleImpl.$$$reportNull$$$0(2);
        }
    }

    public final boolean isDisposed() {
        return super.isDisposed() || ((ProjectEx)this.myProject).isLight() && this.myProject.isDisposed();
    }

    protected boolean isComponentSuitable(@NotNull ComponentConfig componentConfig) {
        if (componentConfig == null) {
            ModuleImpl.$$$reportNull$$$0(3);
        }
        if (!super.isComponentSuitable(componentConfig)) {
            return false;
        }
        Map options2 = componentConfig.options;
        if (options2 == null || options2.isEmpty()) {
            return true;
        }
        for (String optionName : options2.keySet()) {
            if ("workspace".equals(optionName) || "overrides".equals(optionName)) continue;
            String message = "Don't specify " + optionName + " in the component registration, transform component to service and implement your logic in your getInstance() method";
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(message);
                continue;
            }
            LOG.warn(message);
        }
        return true;
    }

    @Nullable
    public VirtualFile getModuleFile() {
        if (this.myImlFilePointer == null) {
            return null;
        }
        return this.myImlFilePointer.getFile();
    }

    @Override
    public void rename(@NotNull String newName, boolean notifyStorage) {
        if (newName == null) {
            ModuleImpl.$$$reportNull$$$0(4);
        }
        this.myName = newName;
        if (notifyStorage) {
            this.getStore().getStorageManager().rename("$MODULE_FILE$", newName + ".iml");
        }
    }

    @NotNull
    private IComponentStore getStore() {
        IComponentStore iComponentStore = Objects.requireNonNull((IComponentStore)this.getService(IComponentStore.class));
        if (iComponentStore == null) {
            ModuleImpl.$$$reportNull$$$0(5);
        }
        return iComponentStore;
    }

    @NotNull
    public String getModuleFilePath() {
        if (!this.isPersistent()) {
            return "";
        }
        String string = this.getStore().getStorageManager().expandMacros("$MODULE_FILE$");
        if (string == null) {
            ModuleImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    public synchronized void dispose() {
        this.isModuleAdded = false;
        super.dispose();
    }

    @NotNull
    protected ContainerDescriptor getContainerDescriptor(@NotNull IdeaPluginDescriptorImpl pluginDescriptor) {
        if (pluginDescriptor == null) {
            ModuleImpl.$$$reportNull$$$0(7);
        }
        ContainerDescriptor containerDescriptor = pluginDescriptor.getModule();
        if (containerDescriptor == null) {
            ModuleImpl.$$$reportNull$$$0(8);
        }
        return containerDescriptor;
    }

    @Override
    public void projectOpened() {
        for (ModuleComponent component2 : this.getModuleComponents()) {
            try {
                component2.projectOpened();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public void projectClosed() {
        List<ModuleComponent> components = this.getModuleComponents();
        for (int i2 = components.size() - 1; i2 >= 0; --i2) {
            try {
                components.get(i2).projectClosed();
                continue;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ModuleImpl.$$$reportNull$$$0(9);
        }
        return project;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ModuleImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean isLoaded() {
        return this.isModuleAdded;
    }

    @Override
    public void moduleAdded() {
        this.isModuleAdded = true;
        for (ModuleComponent component2 : this.getModuleComponents()) {
            component2.moduleAdded();
        }
    }

    @NotNull
    private List<ModuleComponent> getModuleComponents() {
        List list2 = this.getComponentInstancesOfType(ModuleComponent.class);
        if (list2 == null) {
            ModuleImpl.$$$reportNull$$$0(11);
        }
        return list2;
    }

    public void setOption(@NotNull String key, @Nullable String value2) {
        if (key == null) {
            ModuleImpl.$$$reportNull$$$0(12);
        }
        DeprecatedModuleOptionManager manager = this.getOptionManager();
        if (value2 == null) {
            if (((DeprecatedModuleOptionManager)manager).state.options.remove(key) != null) {
                manager.incModificationCount();
            }
        } else if (!value2.equals(((DeprecatedModuleOptionManager)manager).state.options.put(key, value2))) {
            manager.incModificationCount();
        }
    }

    @NotNull
    private DeprecatedModuleOptionManager getOptionManager() {
        DeprecatedModuleOptionManager deprecatedModuleOptionManager = (DeprecatedModuleOptionManager)((Object)this.getService(DeprecatedModuleOptionManager.class));
        if (deprecatedModuleOptionManager == null) {
            ModuleImpl.$$$reportNull$$$0(13);
        }
        return deprecatedModuleOptionManager;
    }

    public String getOptionValue(@NotNull String key) {
        if (key == null) {
            ModuleImpl.$$$reportNull$$$0(14);
        }
        return ((DeprecatedModuleOptionManager)this.getOptionManager()).state.options.get(key);
    }

    @NotNull
    public GlobalSearchScope getModuleScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleScope();
        if (globalSearchScope == null) {
            ModuleImpl.$$$reportNull$$$0(15);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleScope(includeTests);
        if (globalSearchScope == null) {
            ModuleImpl.$$$reportNull$$$0(16);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleWithLibrariesScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithLibrariesScope();
        if (globalSearchScope == null) {
            ModuleImpl.$$$reportNull$$$0(17);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependenciesScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithDependenciesScope();
        if (globalSearchScope == null) {
            ModuleImpl.$$$reportNull$$$0(18);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleContentScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleContentScope();
        if (globalSearchScope == null) {
            ModuleImpl.$$$reportNull$$$0(19);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleContentWithDependenciesScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleContentWithDependenciesScope();
        if (globalSearchScope == null) {
            ModuleImpl.$$$reportNull$$$0(20);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependenciesAndLibrariesScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithDependenciesAndLibrariesScope(includeTests);
        if (globalSearchScope == null) {
            ModuleImpl.$$$reportNull$$$0(21);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependentsScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithDependentsScope();
        if (globalSearchScope == null) {
            ModuleImpl.$$$reportNull$$$0(22);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleTestsWithDependentsScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleTestsWithDependentsScope();
        if (globalSearchScope == null) {
            ModuleImpl.$$$reportNull$$$0(23);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleRuntimeScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleRuntimeScope(includeTests);
        if (globalSearchScope == null) {
            ModuleImpl.$$$reportNull$$$0(24);
        }
        return globalSearchScope;
    }

    @Override
    public void clearScopesCache() {
        this.myModuleScopeProvider.clearCache();
    }

    public String toString() {
        if (this.myName == null) {
            return "Module (not initialized)";
        }
        return "Module: '" + this.getName() + "'";
    }

    @Override
    public long getOptionsModificationCount() {
        return this.getOptionManager().getModificationCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentConfig";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/ModuleImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/ModuleImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStore";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleFilePath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleComponents";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionManager";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleScope";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleWithLibrariesScope";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleWithDependenciesScope";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleContentScope";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleContentWithDependenciesScope";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleWithDependenciesAndLibrariesScope";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleWithDependentsScope";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleTestsWithDependentsScope";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleRuntimeScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setProgressDuringInit";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isComponentSuitable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContainerDescriptor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setOption";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOptionValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @com.intellij.openapi.components.State(name="DeprecatedModuleOptionManager", useLoadedStateAsExisting=false)
    @ApiStatus.Internal
    public static class DeprecatedModuleOptionManager
    extends SimpleModificationTracker
    implements PersistentStateComponent<State>,
    ProjectModelElement {
        private final Module module;
        private State state;

        DeprecatedModuleOptionManager(@NotNull Module module) {
            if (module == null) {
                DeprecatedModuleOptionManager.$$$reportNull$$$0(0);
            }
            this.state = new State();
            this.module = module;
        }

        @Nullable
        public ProjectModelExternalSource getExternalSource() {
            if (this.state.options.size() > 1 || this.state.options.size() == 1 && !this.state.options.containsKey("type")) {
                return null;
            }
            return ExternalProjectSystemRegistry.getInstance().getExternalSource(this.module);
        }

        @Nullable
        public State getState() {
            return this.state;
        }

        public void loadState(@NotNull State state) {
            if (state == null) {
                DeprecatedModuleOptionManager.$$$reportNull$$$0(1);
            }
            this.state = state;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/module/impl/ModuleImpl$DeprecatedModuleOptionManager";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static final class State {
            @Property(surroundWithTag=false)
            @MapAnnotation(surroundKeyWithTag=false, surroundValueWithTag=false, surroundWithTag=false, entryTagName="option")
            public final Map<String, String> options = new THashMap();

            State() {
            }
        }
    }
}

