/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ui.SdkAppearanceService;
import com.intellij.openapi.roots.ui.configuration.SdkListItem;
import com.intellij.openapi.roots.ui.configuration.SdkListModel;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.Producer;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Objects;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SdkListPresenter
extends ColoredListCellRenderer<SdkListItem> {
    private static final Icon EMPTY_ICON = EmptyIcon.create((int)1, (int)16);
    @NotNull
    private final Producer<SdkListModel> myGetModel;

    public SdkListPresenter(@NotNull Producer<SdkListModel> getSdkListModel) {
        if (getSdkListModel == null) {
            SdkListPresenter.$$$reportNull$$$0(0);
        }
        this.myGetModel = getSdkListModel;
    }

    @NotNull
    public <T> ListCellRenderer<T> forType(final @NotNull Function<? super T, ? extends SdkListItem> unwrap) {
        if (unwrap == null) {
            SdkListPresenter.$$$reportNull$$$0(1);
        }
        return new ListCellRenderer<T>(){

            @Override
            @NotNull
            public Component getListCellRendererComponent(JList<? extends T> list2, @Nullable T value2, int index, boolean isSelected, boolean cellHasFocus) {
                SdkListItem item = value2 == null ? null : (SdkListItem)unwrap.fun(value2);
                Component component2 = SdkListPresenter.this.getListCellRendererComponent(list2, item, index, isSelected, cellHasFocus);
                if (component2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return component2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/SdkListPresenter$1", "getListCellRendererComponent"));
            }
        };
    }

    public Component getListCellRendererComponent(@NotNull JList<? extends SdkListItem> list2, @Nullable SdkListItem value2, int index, boolean selected2, boolean hasFocus) {
        String separatorTextAbove;
        if (list2 == null) {
            SdkListPresenter.$$$reportNull$$$0(2);
        }
        final SimpleColoredComponent component2 = (SimpleColoredComponent)super.getListCellRendererComponent(list2, (Object)value2, index, selected2, hasFocus);
        JPanel panel2 = new JPanel(new BorderLayout()){
            private final AccessibleContext myContext;
            {
                super(arg0);
                this.myContext = component2.getAccessibleContext();
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                return this.myContext;
            }

            @Override
            public void setBorder(Border border) {
                component2.setBorder(border);
            }
        };
        panel2.add((Component)component2, "Center");
        SdkListModel model = (SdkListModel)this.myGetModel.produce();
        if (index == -1) {
            component2.setOpaque(false);
            panel2.setOpaque(false);
            if (model.isSearching()) {
                JBLabel progressIcon = new JBLabel((Icon)AnimatedIcon.Default.INSTANCE);
                panel2.add((Component)progressIcon, "East");
            }
            return panel2;
        }
        component2.setOpaque(true);
        panel2.setOpaque(true);
        panel2.setBackground(selected2 ? list2.getSelectionBackground() : list2.getBackground());
        if (value2 instanceof SdkListItem.GroupItem) {
            JBLabel toggle = new JBLabel(AllIcons.Icons.Ide.NextStep);
            toggle.setOpaque(false);
            panel2.add((Component)toggle, "East");
        }
        String string = separatorTextAbove = value2 != null ? model.getSeparatorTextAbove(value2) : null;
        if (separatorTextAbove != null) {
            SeparatorWithText separator = new SeparatorWithText();
            if (!separatorTextAbove.isEmpty()) {
                separator.setCaption(separatorTextAbove);
            }
            separator.setOpaque(false);
            separator.setBackground(list2.getBackground());
            JPanel wrapper2 = new JPanel(new BorderLayout());
            wrapper2.add((Component)separator, "Center");
            wrapper2.setBackground(list2.getBackground());
            wrapper2.setOpaque(true);
            panel2.add((Component)wrapper2, "North");
        }
        return panel2;
    }

    protected void customizeCellRenderer(@NotNull JList<? extends SdkListItem> list2, @Nullable SdkListItem value2, int index, boolean selected2, boolean hasFocus) {
        if (list2 == null) {
            SdkListPresenter.$$$reportNull$$$0(3);
        }
        this.setIcon(EMPTY_ICON);
        this.getAccessibleContext().setAccessibleName(null);
        if (value2 instanceof SdkListItem.InvalidSdkItem) {
            SdkListItem.InvalidSdkItem item = (SdkListItem.InvalidSdkItem)value2;
            String str = ProjectBundle.message((String)"jdk.combo.box.invalid.item", (Object[])new Object[]{item.getSdkName()});
            this.append(str, SimpleTextAttributes.ERROR_ATTRIBUTES);
        } else if (value2 instanceof SdkListItem.ProjectSdkItem) {
            Sdk sdk2 = ((SdkListModel)this.myGetModel.produce()).resolveProjectSdk();
            if (sdk2 != null) {
                this.setIcon(((SdkType)sdk2.getSdkType()).getIcon());
                this.append(ProjectBundle.message((String)"project.roots.project.jdk.inherited", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.append(" ");
                this.append(sdk2.getName(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else {
                this.append(ProjectBundle.message((String)"jdk.combo.box.project.item", (Object[])new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        } else if (value2 instanceof SdkListItem.SuggestedItem) {
            SdkListItem.SuggestedItem item = (SdkListItem.SuggestedItem)value2;
            SdkType type = item.getSdkType();
            String home = item.getHomePath();
            String version2 = item.getVersion();
            Icon icon2 = type.getIconForAddAction();
            if (Objects.equals(icon2, IconUtil.getAddIcon())) {
                icon2 = type.getIcon();
            }
            if (icon2 == null) {
                icon2 = IconUtil.getAddIcon();
            }
            this.setIcon(icon2);
            this.append(SdkListPresenter.presentDetectedSdkPath(home));
            this.append(" ");
            this.append(version2, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (value2 instanceof SdkListItem.ActionItem) {
            SdkListItem.ActionItem item = (SdkListItem.ActionItem)value2;
            Presentation template = item.myAction.getTemplatePresentation();
            SdkType sdkType = item.myAction.getSdkType();
            if (item.myGroup != null) {
                switch (item.myRole) {
                    case ADD: {
                        Icon icon3 = sdkType.getIcon();
                        if (icon3 == null) {
                            icon3 = AllIcons.General.Add;
                        }
                        this.setIcon(icon3);
                        this.append(ProjectBundle.message((String)"sdk.configure.add.sdkType.subAction", (Object[])new Object[]{sdkType.getPresentableName()}));
                        break;
                    }
                    case DOWNLOAD: {
                        this.setIcon(template.getIcon());
                        this.append(ProjectBundle.message((String)"sdk.configure.download.subAction", (Object[])new Object[]{sdkType.getPresentableName()}));
                    }
                }
            } else {
                switch (item.myRole) {
                    case ADD: {
                        this.setIcon(template.getIcon());
                        this.append(ProjectBundle.message((String)"sdk.configure.add.sdkType.action", (Object[])new Object[]{sdkType.getPresentableName()}));
                        break;
                    }
                    case DOWNLOAD: {
                        this.setIcon(template.getIcon());
                        this.append(ProjectBundle.message((String)"sdk.configure.download.action", (Object[])new Object[]{sdkType.getPresentableName()}));
                    }
                }
            }
        } else if (value2 instanceof SdkListItem.GroupItem) {
            SdkListItem.GroupItem item = (SdkListItem.GroupItem)value2;
            this.setIcon(item.myIcon);
            this.append(item.myCaption);
        } else if (value2 instanceof SdkListItem.SdkItem) {
            Sdk sdk3 = ((SdkListItem.SdkItem)value2).getSdk();
            SdkAppearanceService.getInstance().forSdk(sdk3, false, selected2, false).customize((SimpleColoredComponent)this);
            String version3 = sdk3.getVersionString();
            if (version3 == null) {
                version3 = ((SdkType)sdk3.getSdkType()).getPresentableName();
            }
            this.append(" ");
            this.append(version3, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (value2 instanceof SdkListItem.NoneSdkItem) {
            SdkAppearanceService.getInstance().forNullSdk(selected2).customize((SimpleColoredComponent)this);
            this.getAccessibleContext().setAccessibleName(ProjectBundle.message((String)"jdk.combo.box.no.sdk.item.accessibility", (Object[])new Object[0]));
        } else if (value2 instanceof SdkListItem.SdkReferenceItem) {
            SdkListItem.SdkReferenceItem item = (SdkListItem.SdkReferenceItem)value2;
            SdkAppearanceService.getInstance().forSdk((SdkTypeId)item.getSdkType(), item.getName(), null, item.isValid(), false, selected2).customize((SimpleColoredComponent)this);
            String version4 = item.getVersionString();
            if (version4 == null) {
                version4 = item.getSdkType().getPresentableName();
            }
            this.append(" ");
            this.append(version4, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else {
            SdkAppearanceService.getInstance().forNullSdk(selected2).customize((SimpleColoredComponent)this);
        }
    }

    @NotNull
    public static String presentDetectedSdkPath(@NotNull String home) {
        if (home == null) {
            SdkListPresenter.$$$reportNull$$$0(4);
        }
        return SdkListPresenter.presentDetectedSdkPath(home, 50, 30);
    }

    @NotNull
    public static String presentDetectedSdkPath(@NotNull String home, int maxLength, int suffixLength) {
        if (home == null) {
            SdkListPresenter.$$$reportNull$$$0(5);
        }
        home = StringUtil.trimEnd((String)home, (String)"/Contents/Home");
        home = StringUtil.trimEnd((String)home, (String)"/Contents/MacOS");
        home = FileUtil.getLocationRelativeToUserHome((String)home);
        String string = home = StringUtil.shortenTextWithEllipsis((String)home, (int)maxLength, (int)suffixLength);
        if (string == null) {
            SdkListPresenter.$$$reportNull$$$0(6);
        }
        return string;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSdkListPresenter(super.getAccessibleContext());
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getSdkListModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unwrap";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/SdkListPresenter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/SdkListPresenter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "presentDetectedSdkPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "forType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getListCellRendererComponent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeCellRenderer";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "presentDetectedSdkPath";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AccessibleSdkListPresenter
    extends AccessibleContextDelegate {
        private String myAccessibleString = null;

        AccessibleSdkListPresenter(AccessibleContext context) {
            super(context);
        }

        protected Container getDelegateParent() {
            return null;
        }

        public String getAccessibleName() {
            return this.myAccessibleString == null ? super.getDelegate().getAccessibleName() : this.myAccessibleString;
        }

        public void setAccessibleName(String s) {
            this.myAccessibleString = s;
        }
    }
}

