/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.ILightStubElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.util.containers.BooleanStack;
import com.intellij.util.containers.Stack;
import gnu.trove.TIntStack;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LightStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance(LightStubBuilder.class);
    public static final ThreadLocal<LighterAST> FORCED_AST = new ThreadLocal();

    public StubElement buildStubTree(@NotNull PsiFile file2) {
        LighterAST tree;
        if (file2 == null) {
            LightStubBuilder.$$$reportNull$$$0(0);
        }
        if ((tree = FORCED_AST.get()) == null) {
            FileType fileType = file2.getFileType();
            if (!(fileType instanceof LanguageFileType)) {
                LOG.error("File is not of LanguageFileType: " + file2 + ", " + fileType);
                return null;
            }
            if (!(file2 instanceof PsiFileImpl)) {
                LOG.error("Unexpected PsiFile instance: " + file2 + ", " + file2.getClass());
                return null;
            }
            if (((PsiFileImpl)file2).getElementTypeForStubBuilder() == null) {
                LOG.error("File is not of IStubFileElementType: " + file2);
                return null;
            }
            FileASTNode node = file2.getNode();
            tree = node.getElementType() instanceof ILightStubFileElementType ? node.getLighterAST() : new TreeBackedLighterAST(node);
        } else {
            FORCED_AST.set(null);
        }
        StubElement rootStub = this.createStubForFile(file2, tree);
        this.buildStubTree(tree, tree.getRoot(), rootStub);
        return rootStub;
    }

    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file2, @NotNull LighterAST tree) {
        if (file2 == null) {
            LightStubBuilder.$$$reportNull$$$0(1);
        }
        if (tree == null) {
            LightStubBuilder.$$$reportNull$$$0(2);
        }
        return new PsiFileStubImpl<PsiFile>(file2);
    }

    protected void buildStubTree(@NotNull LighterAST tree, @NotNull LighterASTNode root, @NotNull StubElement rootStub) {
        if (tree == null) {
            LightStubBuilder.$$$reportNull$$$0(3);
        }
        if (root == null) {
            LightStubBuilder.$$$reportNull$$$0(4);
        }
        if (rootStub == null) {
            LightStubBuilder.$$$reportNull$$$0(5);
        }
        Stack parents2 = new Stack();
        TIntStack childNumbers = new TIntStack();
        BooleanStack parentsStubbed = new BooleanStack();
        Stack kinderGarden = new Stack();
        Stack parentStubs = new Stack();
        LighterASTNode parent = null;
        LighterASTNode element2 = root;
        List children2 = null;
        int childNumber = 0;
        StubElement parentStub = rootStub;
        boolean immediateParentStubbed = true;
        block0: while (element2 != null) {
            List kids;
            boolean hasStub;
            ProgressManager.checkCanceled();
            StubElement stub = LightStubBuilder.createStub(tree, element2, parentStub);
            boolean bl = hasStub = stub != parentStub || parent == null;
            if (hasStub && !immediateParentStubbed) {
                ((ObjectStubBase)stub).markDangling();
            }
            if (!(parent != null && this.skipNode(tree, parent, element2) || (kids = tree.getChildren(element2)).isEmpty())) {
                if (parent != null) {
                    parents2.push((Object)parent);
                    childNumbers.push(childNumber);
                    kinderGarden.push((Object)children2);
                    parentStubs.push((Object)parentStub);
                    parentsStubbed.push(immediateParentStubbed);
                }
                parent = element2;
                immediateParentStubbed = hasStub;
                children2 = kids;
                childNumber = 0;
                element2 = (LighterASTNode)children2.get(0);
                parentStub = stub;
                if (!this.skipNode(tree, parent, element2)) continue;
            }
            while (children2 != null && ++childNumber < children2.size()) {
                element2 = (LighterASTNode)children2.get(childNumber);
                if (this.skipNode(tree, parent, element2)) continue;
                continue block0;
            }
            element2 = null;
            while (!parents2.isEmpty()) {
                parent = (LighterASTNode)parents2.pop();
                childNumber = childNumbers.pop();
                children2 = (List)kinderGarden.pop();
                parentStub = (StubElement)parentStubs.pop();
                immediateParentStubbed = parentsStubbed.pop();
                while (++childNumber < children2.size()) {
                    element2 = (LighterASTNode)children2.get(childNumber);
                    if (this.skipNode(tree, parent, element2)) continue;
                    continue block0;
                }
                element2 = null;
            }
        }
    }

    @NotNull
    private static StubElement createStub(@NotNull LighterAST tree, @NotNull LighterASTNode element2, @NotNull StubElement parentStub) {
        IElementType elementType;
        if (tree == null) {
            LightStubBuilder.$$$reportNull$$$0(6);
        }
        if (element2 == null) {
            LightStubBuilder.$$$reportNull$$$0(7);
        }
        if (parentStub == null) {
            LightStubBuilder.$$$reportNull$$$0(8);
        }
        if ((elementType = element2.getTokenType()) instanceof IStubElementType) {
            if (elementType instanceof ILightStubElementType) {
                ILightStubElementType lightElementType = (ILightStubElementType)elementType;
                if (lightElementType.shouldCreateStub(tree, element2, parentStub)) {
                    StubElement stubElement = lightElementType.createStub(tree, element2, parentStub);
                    if (stubElement == null) {
                        LightStubBuilder.$$$reportNull$$$0(9);
                    }
                    return stubElement;
                }
            } else {
                LOG.error("Element is not of ILightStubElementType: " + LogUtil.objectAndClass((Object)elementType) + ", " + element2);
            }
        }
        StubElement stubElement = parentStub;
        if (stubElement == null) {
            LightStubBuilder.$$$reportNull$$$0(10);
        }
        return stubElement;
    }

    private boolean skipNode(@NotNull LighterAST tree, @NotNull LighterASTNode parent, @NotNull LighterASTNode node) {
        if (tree == null) {
            LightStubBuilder.$$$reportNull$$$0(11);
        }
        if (parent == null) {
            LightStubBuilder.$$$reportNull$$$0(12);
        }
        if (node == null) {
            LightStubBuilder.$$$reportNull$$$0(13);
        }
        if (tree instanceof TreeBackedLighterAST) {
            return this.skipChildProcessingWhenBuildingStubs(((TreeBackedLighterAST)tree).unwrap(parent), ((TreeBackedLighterAST)tree).unwrap(node));
        }
        return this.skipChildProcessingWhenBuildingStubs(tree, parent, node);
    }

    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent, @NotNull ASTNode node) {
        if (parent == null) {
            LightStubBuilder.$$$reportNull$$$0(14);
        }
        if (node == null) {
            LightStubBuilder.$$$reportNull$$$0(15);
        }
        return false;
    }

    protected boolean skipChildProcessingWhenBuildingStubs(@NotNull LighterAST tree, @NotNull LighterASTNode parent, @NotNull LighterASTNode node) {
        if (tree == null) {
            LightStubBuilder.$$$reportNull$$$0(16);
        }
        if (parent == null) {
            LightStubBuilder.$$$reportNull$$$0(17);
        }
        if (node == null) {
            LightStubBuilder.$$$reportNull$$$0(18);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootStub";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/LightStubBuilder";
                break;
            }
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/LightStubBuilder";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createStubForFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "skipNode";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "skipChildProcessingWhenBuildingStubs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

