/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.scale;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.LazyInitializer;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.DetectRetinaKit;
import com.intellij.util.ui.JBScalableIcon;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.UIManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JBUIScale {
    public static final boolean SCALE_VERBOSE = Boolean.getBoolean("ide.ui.scale.verbose");
    public static final String USER_SCALE_FACTOR_PROPERTY = "JBUIScale.userScaleFactor";
    private static final PropertyChangeSupport PROPERTY_CHANGE_SUPPORT = new PropertyChangeSupport(new JBUIScale());
    private static final float DISCRETE_SCALE_RESOLUTION = 0.25f;
    public static float DEF_SYSTEM_FONT_SIZE = 12.0f;
    private static final AtomicNotNullLazyValue<Pair<String, Integer>> systemFontData = AtomicNotNullLazyValue.createValue(() -> {
        Font winFont;
        Font font = UIManager.getFont("Label.font");
        if (SystemInfo.isMacOSElCapitan) {
            font = new Font(".SF NS Text", font.getStyle(), font.getSize());
        }
        Logger log = JBUIScale.getLogger();
        boolean isScaleVerbose = SCALE_VERBOSE;
        if (isScaleVerbose) {
            log.info(String.format("Label font: %s, %d", font.getFontName(), font.getSize()));
        }
        if (SystemInfo.isLinux) {
            Object value = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/DPI");
            if (isScaleVerbose) {
                log.info(String.format("gnome.Xft/DPI: %s", value));
            }
            if (value instanceof Integer) {
                int dpi = (Integer)value / 1024;
                if (dpi < 50) {
                    dpi = 50;
                }
                float scale = JreHiDpiUtil.isJreHiDPIEnabled() ? 1.0f : JBUIScale.discreteScale((float)dpi / 96.0f);
                DEF_SYSTEM_FONT_SIZE = (float)font.getSize() / scale;
                if (isScaleVerbose) {
                    log.info(String.format("DEF_SYSTEM_FONT_SIZE: %.2f", Float.valueOf(DEF_SYSTEM_FONT_SIZE)));
                }
            } else if (!SystemInfo.isJetBrainsJvm) {
                float size = DEF_SYSTEM_FONT_SIZE * JBUIScale.getScreenScale();
                font = font.deriveFont(size);
                if (isScaleVerbose) {
                    log.info(String.format("(Not-JB JRE) reset font size: %.2f", Float.valueOf(size)));
                }
            }
        } else if (SystemInfo.isWindows && (winFont = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font")) != null) {
            font = winFont;
            if (isScaleVerbose) {
                log.info(String.format("Windows sys font: %s, %d", winFont.getFontName(), winFont.getSize()));
            }
        }
        Pair result = Pair.create((Object)font.getName(), (Object)font.getSize());
        if (isScaleVerbose) {
            log.info(String.format("ourSystemFontData: %s, %d", result.first, result.second));
        }
        return result;
    });
    @ApiStatus.Internal
    public static final LazyInitializer.NullableValue<Float> DEBUG_USER_SCALE_FACTOR = new LazyInitializer.NullableValue<Float>(){

        @Nullable
        public Float initialize() {
            String prop = System.getProperty("ide.ui.scale");
            if (prop != null) {
                try {
                    return Float.valueOf(Float.parseFloat(prop));
                }
                catch (NumberFormatException e) {
                    JBUIScale.getLogger().error("ide.ui.scale system property is not a float value: " + prop);
                }
            } else if (Boolean.getBoolean("ide.ui.scale.override")) {
                return Float.valueOf(1.0f);
            }
            return null;
        }
    };
    private static final LazyInitializer.MutableNotNullValue<Float> SYSTEM_SCALE_FACTOR = new LazyInitializer.MutableNotNullValue(() -> {
        if (!SystemProperties.getBooleanProperty((String)"hidpi", (boolean)true)) {
            return Float.valueOf(1.0f);
        }
        if (JreHiDpiUtil.isJreHiDPIEnabled()) {
            GraphicsDevice gd = null;
            try {
                gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
            if (gd != null && gd.getDefaultConfiguration() != null) {
                return Float.valueOf(JBUIScale.sysScale(gd.getDefaultConfiguration()));
            }
            return Float.valueOf(1.0f);
        }
        float result = JBUIScale.getFontScale(((Integer)((Pair)systemFontData.getValue()).getSecond()).intValue());
        JBUIScale.getLogger().info("System scale factor: " + result + " (" + (JreHiDpiUtil.isJreHiDPIEnabled() ? "JRE" : "IDE") + "-managed HiDPI)");
        return Float.valueOf(result);
    });
    private static final LazyInitializer.MutableNotNullValue<Float> userScaleFactor = new LazyInitializer.MutableNotNullValue(() -> {
        Float factor = (Float)DEBUG_USER_SCALE_FACTOR.get();
        if (factor != null) {
            return factor;
        }
        return Float.valueOf(JBUIScale.computeUserScaleFactor(JreHiDpiUtil.isJreHiDPIEnabled() ? 1.0f : ((Float)SYSTEM_SCALE_FACTOR.get()).floatValue()));
    });

    public static void addUserScaleChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            JBUIScale.$$$reportNull$$$0(0);
        }
        PROPERTY_CHANGE_SUPPORT.addPropertyChangeListener(USER_SCALE_FACTOR_PROPERTY, listener);
    }

    public static void removeUserScaleChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            JBUIScale.$$$reportNull$$$0(1);
        }
        PROPERTY_CHANGE_SUPPORT.removePropertyChangeListener(listener);
    }

    private JBUIScale() {
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(JBUIScale.class);
        if (logger == null) {
            JBUIScale.$$$reportNull$$$0(2);
        }
        return logger;
    }

    public static void setSystemScaleFactor(float sysScale) {
        SYSTEM_SCALE_FACTOR.set((Object)Float.valueOf(sysScale));
    }

    public static void setUserScaleFactorForTest(float value) {
        JBUIScale.setUserScaleFactorProperty(value);
    }

    private static void setUserScaleFactorProperty(float value) {
        Float oldValue = (Float)userScaleFactor.get();
        if (oldValue.floatValue() == value) {
            return;
        }
        userScaleFactor.set((Object)Float.valueOf(value));
        JBUIScale.getLogger().info("User scale factor: " + value);
        PROPERTY_CHANGE_SUPPORT.firePropertyChange(USER_SCALE_FACTOR_PROPERTY, oldValue, Float.valueOf(value));
    }

    public static float getFontScale(float fontSize) {
        return fontSize / DEF_SYSTEM_FONT_SIZE;
    }

    @ApiStatus.Internal
    public static float setUserScaleFactor(float scale) {
        Float factor = (Float)DEBUG_USER_SCALE_FACTOR.get();
        if (factor != null) {
            float debugScale = factor.floatValue();
            if (scale == debugScale) {
                JBUIScale.setUserScaleFactorProperty(debugScale);
            }
            return debugScale;
        }
        scale = JBUIScale.computeUserScaleFactor(scale);
        JBUIScale.setUserScaleFactorProperty(scale);
        return scale;
    }

    private static float computeUserScaleFactor(float scale) {
        if (!SystemProperties.getBooleanProperty((String)"hidpi", (boolean)true)) {
            return 1.0f;
        }
        if ((scale = JBUIScale.discreteScale(scale)) < 1.0f && JBUIScale.sysScale() >= 1.0f) {
            scale = 1.0f;
        }
        if (SystemInfo.isLinux && scale == 1.25f && DEF_SYSTEM_FONT_SIZE == 12.0f) {
            scale = 1.0f;
        }
        return scale;
    }

    private static float discreteScale(float scale) {
        return (float)Math.round(scale / 0.25f) * 0.25f;
    }

    public static float sysScale() {
        return ((Float)SYSTEM_SCALE_FACTOR.get()).floatValue();
    }

    public static float sysScale(@Nullable Component comp) {
        if (comp != null) {
            return JBUIScale.sysScale(comp.getGraphicsConfiguration());
        }
        return JBUIScale.sysScale();
    }

    public static float sysScale(@Nullable GraphicsConfiguration gc) {
        if (JreHiDpiUtil.isJreHiDPIEnabled() && gc != null && gc.getDevice().getType() != 1) {
            if (SystemInfo.isMac && JreHiDpiUtil.isJreHiDPI_earlierVersion()) {
                return DetectRetinaKit.isOracleMacRetinaDevice(gc.getDevice()) ? 2.0f : 1.0f;
            }
            return (float)gc.getDefaultTransform().getScaleX();
        }
        return JBUIScale.sysScale();
    }

    public static float scale(float f) {
        return f * ((Float)userScaleFactor.get()).floatValue();
    }

    public static int scale(int i) {
        return Math.round(((Float)userScaleFactor.get()).floatValue() * (float)i);
    }

    @NotNull
    public static <T extends JBScalableIcon> T scaleIcon(@NotNull T icon) {
        if (icon == null) {
            JBUIScale.$$$reportNull$$$0(3);
        }
        JBScalableIcon jBScalableIcon = icon.withIconPreScaled(false);
        if (jBScalableIcon == null) {
            JBUIScale.$$$reportNull$$$0(4);
        }
        return (T)jBScalableIcon;
    }

    public static int scaleFontSize(float fontSize) {
        if (((Float)userScaleFactor.get()).floatValue() == 1.25f) {
            return (int)(fontSize * 1.34f);
        }
        if (((Float)userScaleFactor.get()).floatValue() == 1.75f) {
            return (int)(fontSize * 1.67f);
        }
        return (int)JBUIScale.scale(fontSize);
    }

    private static float getScreenScale() {
        int dpi = 96;
        try {
            dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        return JBUIScale.discreteScale((float)dpi / 96.0f);
    }

    @NotNull
    public static Pair<String, Integer> getSystemFontData() {
        Pair pair = (Pair)systemFontData.getValue();
        if (pair == null) {
            JBUIScale.$$$reportNull$$$0(5);
        }
        return pair;
    }

    public static float sysScale(@Nullable Graphics2D g) {
        if (JreHiDpiUtil.isJreHiDPIEnabled() && g != null) {
            GraphicsConfiguration gc = g.getDeviceConfiguration();
            if (gc == null || gc.getDevice().getType() == 2 || gc.getDevice().getType() == 1) {
                return Math.abs((float)g.getTransform().getScaleX());
            }
            return JBUIScale.sysScale(gc);
        }
        return JBUIScale.sysScale();
    }

    public static double sysScale(@Nullable ScaleContext context) {
        return context == null ? (double)JBUIScale.sysScale() : context.getScale(ScaleType.SYS_SCALE);
    }

    public static boolean isHiDPI(double scale) {
        return scale != 1.0;
    }

    public static boolean isUsrHiDPI() {
        return JBUIScale.isHiDPI(JBUIScale.scale(1.0f));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/scale/JBUIScale";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/scale/JBUIScale";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "scaleIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemFontData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addUserScaleChangeListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeUserScaleChangeListener";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "scaleIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

