/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.cloud;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.agent.util.log.TerminalListener;
import com.intellij.terminal.JBTerminalWidget;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import java.awt.Dimension;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.cloud.CloudTerminalProcess;

public class CloudTerminalRunner
extends AbstractTerminalRunner<CloudTerminalProcess> {
    private final String myPipeName;
    private final CloudTerminalProcess myProcess;
    private final TerminalListener.TtyResizeHandler myTtyResizeHandler;
    private final boolean myDeferSessionUntilFirstShown;

    public CloudTerminalRunner(@NotNull Project project, String pipeName, CloudTerminalProcess process, @Nullable TerminalListener.TtyResizeHandler resizeHandler, boolean deferSessionUntilFirstShown) {
        if (project == null) {
            CloudTerminalRunner.$$$reportNull$$$0(0);
        }
        super(project);
        this.myPipeName = pipeName;
        this.myProcess = process;
        this.myTtyResizeHandler = resizeHandler;
        this.myDeferSessionUntilFirstShown = deferSessionUntilFirstShown;
    }

    public CloudTerminalRunner(@NotNull Project project, String pipeName, CloudTerminalProcess process) {
        if (project == null) {
            CloudTerminalRunner.$$$reportNull$$$0(1);
        }
        this(project, pipeName, process, null, false);
    }

    @Override
    @NotNull
    public JBTerminalWidget createTerminalWidget(@NotNull Disposable parent, @Nullable VirtualFile currentWorkingDirectory) {
        if (parent == null) {
            CloudTerminalRunner.$$$reportNull$$$0(2);
        }
        JBTerminalWidget jBTerminalWidget = super.createTerminalWidget(parent, currentWorkingDirectory, this.myDeferSessionUntilFirstShown);
        if (jBTerminalWidget == null) {
            CloudTerminalRunner.$$$reportNull$$$0(3);
        }
        return jBTerminalWidget;
    }

    @Override
    protected CloudTerminalProcess createProcess(@Nullable String directory) {
        return this.myProcess;
    }

    @Override
    protected ProcessHandler createProcessHandler(final CloudTerminalProcess process) {
        return new ProcessHandler(){

            protected void destroyProcessImpl() {
                process.destroy();
            }

            protected void detachProcessImpl() {
                process.destroy();
            }

            public boolean detachIsDefault() {
                return false;
            }

            @Nullable
            public OutputStream getProcessInput() {
                return process.getOutputStream();
            }
        };
    }

    @Override
    protected String getTerminalConnectionName(CloudTerminalProcess process) {
        return "Terminal: " + this.myPipeName;
    }

    @Override
    protected TtyConnector createTtyConnector(CloudTerminalProcess process) {
        return new ProcessTtyConnector(process, Charset.defaultCharset()){
            private Dimension myAppliedTermSize;

            protected void resizeImmediately() {
                if (CloudTerminalRunner.this.myTtyResizeHandler == null) {
                    return;
                }
                Dimension termSize = this.getPendingTermSize();
                if (Objects.equals(this.myAppliedTermSize, termSize)) {
                    return;
                }
                if (termSize != null) {
                    CloudTerminalRunner.this.myTtyResizeHandler.onTtyResizeRequest(termSize.width, termSize.height);
                }
                this.myAppliedTermSize = termSize;
            }

            public String getName() {
                return "Connector: " + CloudTerminalRunner.this.myPipeName;
            }

            public boolean isConnected() {
                return true;
            }
        };
    }

    @Override
    public String runningTargetName() {
        return "Cloud terminal";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/cloud/CloudTerminalRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/cloud/CloudTerminalRunner";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTerminalWidget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTerminalWidget";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

