/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.StreamError;
import org.armedbear.lisp.Symbol;

public final class URLStream
extends Stream {
    private final Pathname pathname;
    private final InputStream input;
    private final Reader reader;
    private final int bytesPerUnit;

    public URLStream(Pathname pathname, String namestring, LispObject elementType, LispObject direction, LispObject ifExists, LispObject format) throws IOException {
        super(Symbol.URL_STREAM);
        Debug.assertTrue(direction == Keyword.INPUT);
        this.isInputStream = true;
        super.setExternalFormat(format);
        this.pathname = pathname;
        this.elementType = elementType;
        this.input = pathname.getInputStream();
        if (elementType == Symbol.CHARACTER || elementType == Symbol.BASE_CHAR) {
            this.isCharacterStream = true;
            this.bytesPerUnit = 1;
            InputStreamReader isr = new InputStreamReader(this.input);
            this.reader = new BufferedReader(isr);
            this.initAsCharacterInputStream(this.reader);
        } else {
            this.isBinaryStream = true;
            int width = Fixnum.getValue(elementType.cadr());
            this.bytesPerUnit = width / 8;
            this.reader = null;
            this.initAsBinaryInputStream(this.input);
        }
    }

    @Override
    public LispObject typeOf() {
        return Symbol.URL_STREAM;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.URL_STREAM;
    }

    @Override
    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.URL_STREAM) {
            return Lisp.T;
        }
        if (typeSpecifier == BuiltInClass.URL_STREAM) {
            return Lisp.T;
        }
        return super.typep(typeSpecifier);
    }

    @Override
    public void setExternalFormat(LispObject format) {
        super.setExternalFormat(format);
    }

    public Pathname getPathname() {
        return this.pathname;
    }

    public Reader getReader() {
        return this.reader;
    }

    public InputStream getInputStream() {
        return this.input;
    }

    public int getBytesPerUnit() {
        return this.bytesPerUnit;
    }

    @Override
    public void _close() {
        try {
            if (this.input != null) {
                this.input.close();
            }
            if (this.reader != null) {
                this.reader.close();
            }
            this.setOpen(false);
        }
        catch (IOException e) {
            Lisp.error(new StreamError((Stream)this, e));
        }
    }

    @Override
    public String printObject() {
        StringBuffer sb = new StringBuffer();
        sb.append(Symbol.URL_STREAM.printObject());
        String namestring = this.pathname.getNamestring();
        if (namestring != null) {
            sb.append(" ");
            sb.append(namestring);
        }
        return this.unreadableString(sb.toString());
    }
}

