/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.security.Security;
import javax.xml.crypto.test.KeySelectors;
import javax.xml.crypto.test.dsig.SignatureValidator;
import junit.framework.TestCase;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;

public class IaikTransformsTest
extends TestCase {
    private SignatureValidator validator;

    public IaikTransformsTest(String string) {
        super(string);
        String string2 = System.getProperty("file.separator");
        String string3 = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        string3 = string3 + string2 + "data" + string2 + "at" + string2 + "iaik" + string2 + "ixsil";
        this.validator = new SignatureValidator(new File(string3, "transforms/signatures"));
    }

    public void test_base64DecodeSignature() throws Exception {
        String string = "base64DecodeSignature.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        IaikTransformsTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public void test_envelopedSignatureSignature() throws Exception {
        String string = "envelopedSignatureSignature.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        IaikTransformsTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public void test_c14nSignature() throws Exception {
        String string = "c14nSignature.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        IaikTransformsTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public void test_xPathSignature() throws Exception {
        String string = "xPathSignature.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        IaikTransformsTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public static void main(String[] stringArray) throws Exception {
        IaikTransformsTest iaikTransformsTest = new IaikTransformsTest("");
        iaikTransformsTest.test_xPathSignature();
        iaikTransformsTest.test_c14nSignature();
        iaikTransformsTest.test_base64DecodeSignature();
        iaikTransformsTest.test_envelopedSignatureSignature();
    }

    static {
        Security.insertProviderAt(new XMLDSigRI(), 1);
    }
}

