/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoryOperation;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotsService;

public class SnapshotsInProgress
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final SnapshotsInProgress EMPTY = new SnapshotsInProgress(Collections.emptyList());
    private static final Version VERSION_IN_SNAPSHOT_VERSION = Version.V_7_7_0;
    public static final String TYPE = "snapshots";
    private final List<Entry> entries;
    private static final String REPOSITORY = "repository";
    private static final String SNAPSHOTS = "snapshots";
    private static final String SNAPSHOT = "snapshot";
    private static final String UUID = "uuid";
    private static final String INCLUDE_GLOBAL_STATE = "include_global_state";
    private static final String PARTIAL = "partial";
    private static final String STATE = "state";
    private static final String INDICES = "indices";
    private static final String DATA_STREAMS = "data_streams";
    private static final String START_TIME_MILLIS = "start_time_millis";
    private static final String START_TIME = "start_time";
    private static final String REPOSITORY_STATE_ID = "repository_state_id";
    private static final String SHARDS = "shards";
    private static final String INDEX = "index";
    private static final String SHARD = "shard";
    private static final String NODE = "node";

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.entries.equals(((SnapshotsInProgress)o).entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SnapshotsInProgress[");
        for (int i = 0; i < this.entries.size(); ++i) {
            builder.append(this.entries.get(i).snapshot().getSnapshotId().getName());
            if (i + 1 >= this.entries.size()) continue;
            builder.append(",");
        }
        return builder.append("]").toString();
    }

    public static boolean completed(ObjectContainer<ShardSnapshotStatus> shards) {
        for (ObjectCursor status : shards) {
            if (((ShardSnapshotStatus)status.value).state().completed) continue;
            return false;
        }
        return true;
    }

    private static boolean assertConsistentEntries(List<Entry> entries) {
        HashMap<String, Set> assignedShardsByRepo = new HashMap<String, Set>();
        for (Entry entry : entries) {
            for (ObjectObjectCursor<ShardId, ShardSnapshotStatus> objectObjectCursor : entry.shards()) {
                if (((ShardSnapshotStatus)objectObjectCursor.value).isActive()) assert (assignedShardsByRepo.computeIfAbsent(entry.repository(), k -> new HashSet()).add((ShardId)objectObjectCursor.key)) : "Found duplicate shard assignments in " + entries;
            }
        }
        return true;
    }

    public static SnapshotsInProgress of(List<Entry> entries) {
        if (entries.isEmpty()) {
            return EMPTY;
        }
        return new SnapshotsInProgress(Collections.unmodifiableList(entries));
    }

    private SnapshotsInProgress(List<Entry> entries) {
        this.entries = entries;
        assert (SnapshotsInProgress.assertConsistentEntries(entries));
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public Entry snapshot(Snapshot snapshot) {
        for (Entry entry : this.entries) {
            Snapshot curr = entry.snapshot();
            if (!curr.equals(snapshot)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public String getWriteableName() {
        return "snapshots";
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return SnapshotsInProgress.readDiffFrom(ClusterState.Custom.class, "snapshots", in);
    }

    public SnapshotsInProgress(StreamInput in) throws IOException {
        Entry[] entries = new Entry[in.readVInt()];
        for (int i = 0; i < entries.length; ++i) {
            Snapshot snapshot = new Snapshot(in);
            boolean includeGlobalState = in.readBoolean();
            boolean partial = in.readBoolean();
            State state = State.fromValue(in.readByte());
            List<IndexId> indexBuilder = in.readList(IndexId::new);
            long startTime = in.readLong();
            int shards = in.readVInt();
            ImmutableOpenMap.Builder<ShardId, ShardSnapshotStatus> builder = ImmutableOpenMap.builder(shards);
            for (int j = 0; j < shards; ++j) {
                ShardId shardId = new ShardId(in);
                if (in.getVersion().onOrAfter(Version.V_6_0_0_beta1)) {
                    builder.put(shardId, new ShardSnapshotStatus(in));
                    continue;
                }
                String nodeId = in.readOptionalString();
                ShardState shardState = ShardState.fromValue(in.readByte());
                String reason = shardState.failed() ? "" : null;
                builder.put(shardId, new ShardSnapshotStatus(nodeId, shardState, reason));
            }
            long repositoryStateId = in.readLong();
            String failure = in.getVersion().onOrAfter(Version.V_6_7_0) ? in.readOptionalString() : null;
            Map<String, Object> userMetadata = null;
            if (in.getVersion().onOrAfter(SnapshotInfo.METADATA_FIELD_INTRODUCED)) {
                userMetadata = in.readMap();
            }
            Version version = in.getVersion().onOrAfter(VERSION_IN_SNAPSHOT_VERSION) ? Version.readVersion(in) : (in.getVersion().onOrAfter(SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION) ? (in.readBoolean() ? SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION : SnapshotsService.OLD_SNAPSHOT_FORMAT) : SnapshotsService.OLD_SNAPSHOT_FORMAT);
            List<String> dataStreams = in.getVersion().onOrAfter(SnapshotInfo.DATA_STREAMS_IN_SNAPSHOT) ? in.readStringList() : Collections.emptyList();
            entries[i] = new Entry(snapshot, includeGlobalState, partial, state, Collections.unmodifiableList(indexBuilder), dataStreams, startTime, repositoryStateId, builder.build(), failure, userMetadata, version);
        }
        this.entries = Arrays.asList(entries);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.entries.size());
        for (Entry entry : this.entries) {
            entry.snapshot().writeTo(out);
            out.writeBoolean(entry.includeGlobalState());
            out.writeBoolean(entry.partial());
            out.writeByte(entry.state().value());
            out.writeVInt(entry.indices().size());
            for (IndexId indexId : entry.indices()) {
                indexId.writeTo(out);
            }
            out.writeLong(entry.startTime());
            out.writeVInt(entry.shards().size());
            for (ObjectObjectCursor objectObjectCursor : entry.shards()) {
                ((ShardId)objectObjectCursor.key).writeTo(out);
                if (out.getVersion().onOrAfter(Version.V_6_0_0_beta1)) {
                    ((ShardSnapshotStatus)objectObjectCursor.value).writeTo(out);
                    continue;
                }
                out.writeOptionalString(((ShardSnapshotStatus)objectObjectCursor.value).nodeId());
                out.writeByte(((ShardSnapshotStatus)objectObjectCursor.value).state().value);
            }
            out.writeLong(entry.repositoryStateId);
            if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
                out.writeOptionalString(entry.failure);
            }
            if (out.getVersion().onOrAfter(SnapshotInfo.METADATA_FIELD_INTRODUCED)) {
                out.writeMap(entry.userMetadata);
            }
            if (out.getVersion().onOrAfter(VERSION_IN_SNAPSHOT_VERSION)) {
                Version.writeVersion(entry.version, out);
            } else if (out.getVersion().onOrAfter(SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION)) {
                out.writeBoolean(SnapshotsService.useShardGenerations(entry.version));
            }
            if (!out.getVersion().onOrAfter(SnapshotInfo.DATA_STREAMS_IN_SNAPSHOT)) continue;
            out.writeStringCollection(entry.dataStreams);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("snapshots");
        for (Entry entry : this.entries) {
            entry.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static class Entry
    implements ToXContent,
    RepositoryOperation {
        private final State state;
        private final Snapshot snapshot;
        private final boolean includeGlobalState;
        private final boolean partial;
        private final ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards;
        private final List<IndexId> indices;
        private final List<String> dataStreams;
        private final long startTime;
        private final long repositoryStateId;
        private final Version version;
        @Nullable
        private final Map<String, Object> userMetadata;
        @Nullable
        private final String failure;

        public Entry(Snapshot snapshot, boolean includeGlobalState, boolean partial, State state, List<IndexId> indices, List<String> dataStreams, long startTime, long repositoryStateId, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, String failure, Map<String, Object> userMetadata, Version version) {
            this.state = state;
            this.snapshot = snapshot;
            this.includeGlobalState = includeGlobalState;
            this.partial = partial;
            this.indices = indices;
            this.dataStreams = dataStreams;
            this.startTime = startTime;
            this.shards = shards;
            assert (Entry.assertShardsConsistent(state, indices, shards));
            this.repositoryStateId = repositoryStateId;
            this.failure = failure;
            this.userMetadata = userMetadata;
            this.version = version;
        }

        private static boolean assertShardsConsistent(State state, List<IndexId> indices, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards) {
            if ((state == State.INIT || state == State.ABORTED) && shards.isEmpty()) {
                return true;
            }
            Set indexNames = indices.stream().map(IndexId::getName).collect(Collectors.toSet());
            HashSet indexNamesInShards = new HashSet();
            shards.keysIt().forEachRemaining(s -> indexNamesInShards.add(s.getIndexName()));
            assert (indexNames.equals(indexNamesInShards)) : "Indices in shards " + indexNamesInShards + " differ from expected indices " + indexNames + " for state [" + (Object)((Object)state) + "]";
            return true;
        }

        public Entry(Snapshot snapshot, boolean includeGlobalState, boolean partial, State state, List<IndexId> indices, List<String> dataStreams, long startTime, long repositoryStateId, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, Map<String, Object> userMetadata, Version version) {
            this(snapshot, includeGlobalState, partial, state, indices, dataStreams, startTime, repositoryStateId, shards, null, userMetadata, version);
        }

        public Entry(Snapshot snapshot, boolean includeGlobalState, boolean partial, State state, List<IndexId> indices, long startTime, long repositoryStateId, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, Map<String, Object> userMetadata, Version version) {
            this(snapshot, includeGlobalState, partial, state, indices, Collections.emptyList(), startTime, repositoryStateId, shards, null, userMetadata, version);
        }

        public Entry(Entry entry, State state, List<IndexId> indices, long repositoryStateId, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, Version version, String failure) {
            this(entry.snapshot, entry.includeGlobalState, entry.partial, state, indices, entry.dataStreams, entry.startTime, repositoryStateId, shards, failure, entry.userMetadata, version);
        }

        public Entry(Entry entry, State state, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards) {
            this(entry.snapshot, entry.includeGlobalState, entry.partial, state, entry.indices, entry.dataStreams, entry.startTime, entry.repositoryStateId, shards, entry.failure, entry.userMetadata, entry.version);
        }

        public Entry(Entry entry, State state, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, String failure) {
            this(entry.snapshot, entry.includeGlobalState, entry.partial, state, entry.indices, entry.dataStreams, entry.startTime, entry.repositoryStateId, shards, failure, entry.userMetadata, entry.version);
        }

        public Entry(Entry entry, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards) {
            this(entry, entry.state, shards, entry.failure);
        }

        public Entry withRepoGen(long newRepoGen) {
            assert (newRepoGen > this.repositoryStateId) : "Updated repository generation [" + newRepoGen + "] must be higher than current generation [" + this.repositoryStateId + "]";
            return new Entry(this.snapshot, this.includeGlobalState, this.partial, this.state, this.indices, this.dataStreams, this.startTime, newRepoGen, this.shards, this.failure, this.userMetadata, this.version);
        }

        public Entry withShards(ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards) {
            return new Entry(this.snapshot, this.includeGlobalState, this.partial, this.state, this.indices, this.dataStreams, this.startTime, this.repositoryStateId, shards, this.failure, this.userMetadata, this.version);
        }

        @Override
        public String repository() {
            return this.snapshot.getRepository();
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        public ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards() {
            return this.shards;
        }

        public State state() {
            return this.state;
        }

        public List<IndexId> indices() {
            return this.indices;
        }

        public boolean includeGlobalState() {
            return this.includeGlobalState;
        }

        public Map<String, Object> userMetadata() {
            return this.userMetadata;
        }

        public boolean partial() {
            return this.partial;
        }

        public long startTime() {
            return this.startTime;
        }

        public List<String> dataStreams() {
            return this.dataStreams;
        }

        @Override
        public long repositoryStateId() {
            return this.repositoryStateId;
        }

        public String failure() {
            return this.failure;
        }

        public Version version() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.includeGlobalState != entry.includeGlobalState) {
                return false;
            }
            if (this.partial != entry.partial) {
                return false;
            }
            if (this.startTime != entry.startTime) {
                return false;
            }
            if (!this.indices.equals(entry.indices)) {
                return false;
            }
            if (!this.shards.equals(entry.shards)) {
                return false;
            }
            if (!this.snapshot.equals(entry.snapshot)) {
                return false;
            }
            if (this.state != entry.state) {
                return false;
            }
            if (this.repositoryStateId != entry.repositoryStateId) {
                return false;
            }
            return this.version.equals(entry.version);
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = 31 * result + this.snapshot.hashCode();
            result = 31 * result + (this.includeGlobalState ? 1 : 0);
            result = 31 * result + (this.partial ? 1 : 0);
            result = 31 * result + this.shards.hashCode();
            result = 31 * result + this.indices.hashCode();
            result = 31 * result + Long.hashCode(this.startTime);
            result = 31 * result + Long.hashCode(this.repositoryStateId);
            result = 31 * result + this.version.hashCode();
            return result;
        }

        public String toString() {
            return Strings.toString(this);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(SnapshotsInProgress.REPOSITORY, this.snapshot.getRepository());
            builder.field(SnapshotsInProgress.SNAPSHOT, this.snapshot.getSnapshotId().getName());
            builder.field(SnapshotsInProgress.UUID, this.snapshot.getSnapshotId().getUUID());
            builder.field(SnapshotsInProgress.INCLUDE_GLOBAL_STATE, this.includeGlobalState());
            builder.field(SnapshotsInProgress.PARTIAL, this.partial);
            builder.field(SnapshotsInProgress.STATE, (Object)this.state);
            builder.startArray(SnapshotsInProgress.INDICES);
            for (IndexId indexId : this.indices) {
                indexId.toXContent(builder, params);
            }
            builder.endArray();
            builder.humanReadableField(SnapshotsInProgress.START_TIME_MILLIS, SnapshotsInProgress.START_TIME, (Object)new TimeValue(this.startTime));
            builder.field(SnapshotsInProgress.REPOSITORY_STATE_ID, this.repositoryStateId);
            builder.startArray(SnapshotsInProgress.SHARDS);
            for (ObjectObjectCursor objectObjectCursor : this.shards) {
                ShardId shardId = (ShardId)objectObjectCursor.key;
                ShardSnapshotStatus status = (ShardSnapshotStatus)objectObjectCursor.value;
                builder.startObject();
                builder.field(SnapshotsInProgress.INDEX, (ToXContent)shardId.getIndex());
                builder.field(SnapshotsInProgress.SHARD, shardId.getId());
                builder.field(SnapshotsInProgress.STATE, (Object)status.state());
                builder.field(SnapshotsInProgress.NODE, status.nodeId());
                builder.endObject();
            }
            builder.endArray();
            builder.array(SnapshotsInProgress.DATA_STREAMS, this.dataStreams.toArray(new String[0]));
            builder.endObject();
            return builder;
        }

        public boolean isFragment() {
            return false;
        }
    }

    public static class ShardSnapshotStatus {
        public static final ShardSnapshotStatus UNASSIGNED_QUEUED = new ShardSnapshotStatus(null, ShardState.QUEUED, null);
        public static final ShardSnapshotStatus MISSING = new ShardSnapshotStatus(null, ShardState.MISSING, "missing index", null);
        private final ShardState state;
        @Nullable
        private final String nodeId;
        @Nullable
        private final String generation;
        @Nullable
        private final String reason;

        public ShardSnapshotStatus(String nodeId, String generation) {
            this(nodeId, ShardState.INIT, generation);
        }

        public ShardSnapshotStatus(@Nullable String nodeId, ShardState state, @Nullable String generation) {
            this(nodeId, state, null, generation);
        }

        public ShardSnapshotStatus(@Nullable String nodeId, ShardState state, String reason, @Nullable String generation) {
            this.nodeId = nodeId;
            this.state = state;
            this.reason = reason;
            this.generation = generation;
            assert (this.assertConsistent());
        }

        private boolean assertConsistent() {
            assert (!this.state.failed() || this.reason != null);
            assert (this.state != ShardState.INIT && this.state != ShardState.WAITING || this.nodeId != null) : "Null node id for state [" + (Object)((Object)this.state) + "]";
            return true;
        }

        public ShardSnapshotStatus(StreamInput in) throws IOException {
            this.nodeId = in.readOptionalString();
            this.state = ShardState.fromValue(in.readByte());
            this.generation = SnapshotsService.useShardGenerations(in.getVersion()) ? in.readOptionalString() : null;
            this.reason = in.readOptionalString();
        }

        public ShardState state() {
            return this.state;
        }

        @Nullable
        public String nodeId() {
            return this.nodeId;
        }

        @Nullable
        public String generation() {
            return this.generation;
        }

        public String reason() {
            return this.reason;
        }

        public boolean isActive() {
            return this.state == ShardState.INIT || this.state == ShardState.ABORTED || this.state == ShardState.WAITING;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.nodeId);
            out.writeByte(this.state.value);
            if (SnapshotsService.useShardGenerations(out.getVersion())) {
                out.writeOptionalString(this.generation);
            }
            out.writeOptionalString(this.reason);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShardSnapshotStatus status = (ShardSnapshotStatus)o;
            return Objects.equals(this.nodeId, status.nodeId) && Objects.equals(this.reason, status.reason) && Objects.equals(this.generation, status.generation) && this.state == status.state;
        }

        public int hashCode() {
            int result = this.state != null ? this.state.hashCode() : 0;
            result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
            result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
            result = 31 * result + (this.generation != null ? this.generation.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ShardSnapshotStatus[state=" + (Object)((Object)this.state) + ", nodeId=" + this.nodeId + ", reason=" + this.reason + ", generation=" + this.generation + "]";
        }
    }

    public static enum ShardState {
        INIT(0, false, false),
        SUCCESS(2, true, false),
        FAILED(3, true, true),
        ABORTED(4, false, true),
        MISSING(5, true, true),
        WAITING(6, false, false),
        QUEUED(7, false, false);

        private final byte value;
        private final boolean completed;
        private final boolean failed;

        private ShardState(byte value, boolean completed, boolean failed) {
            this.value = value;
            this.completed = completed;
            this.failed = failed;
        }

        public boolean completed() {
            return this.completed;
        }

        public boolean failed() {
            return this.failed;
        }

        public static ShardState fromValue(byte value) {
            switch (value) {
                case 0: {
                    return INIT;
                }
                case 2: {
                    return SUCCESS;
                }
                case 3: {
                    return FAILED;
                }
                case 4: {
                    return ABORTED;
                }
                case 5: {
                    return MISSING;
                }
                case 6: {
                    return WAITING;
                }
                case 7: {
                    return QUEUED;
                }
            }
            throw new IllegalArgumentException("No shard snapshot state for value [" + value + "]");
        }
    }

    public static enum State {
        INIT(0, false),
        STARTED(1, false),
        SUCCESS(2, true),
        FAILED(3, true),
        ABORTED(4, false);

        private final byte value;
        private final boolean completed;

        private State(byte value, boolean completed) {
            this.value = value;
            this.completed = completed;
        }

        public byte value() {
            return this.value;
        }

        public boolean completed() {
            return this.completed;
        }

        public static State fromValue(byte value) {
            switch (value) {
                case 0: {
                    return INIT;
                }
                case 1: {
                    return STARTED;
                }
                case 2: {
                    return SUCCESS;
                }
                case 3: {
                    return FAILED;
                }
                case 4: {
                    return ABORTED;
                }
            }
            throw new IllegalArgumentException("No snapshot state for value [" + value + "]");
        }
    }
}

