/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.FeatureField;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.query.QueryShardContext;

public class RankFeaturesFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "rank_features";

    private RankFeaturesFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, multiFields, copyTo);
        assert (fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) <= 0);
    }

    protected RankFeaturesFieldMapper clone() {
        return (RankFeaturesFieldMapper)super.clone();
    }

    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
    }

    public RankFeaturesFieldType fieldType() {
        return (RankFeaturesFieldType)super.fieldType();
    }

    public void parse(ParseContext context) throws IOException {
        if (context.externalValueSet()) {
            throw new IllegalArgumentException("[rank_features] fields can't be used in multi-fields");
        }
        if (context.parser().currentToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("[rank_features] fields must be json objects, expected a START_OBJECT but got: " + context.parser().currentToken());
        }
        String feature = null;
        XContentParser.Token token = context.parser().nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                feature = context.parser().currentName();
            } else if (token != XContentParser.Token.VALUE_NULL) {
                if (token == XContentParser.Token.VALUE_NUMBER || token == XContentParser.Token.VALUE_STRING) {
                    String key = this.name() + "." + feature;
                    float value = context.parser().floatValue(true);
                    if (context.doc().getByKey((Object)key) != null) {
                        throw new IllegalArgumentException("[rank_features] fields do not support indexing multiple values for the same rank feature [" + key + "] in the same document");
                    }
                    context.doc().addWithKey((Object)key, (IndexableField)new FeatureField(this.name(), feature, value));
                } else {
                    throw new IllegalArgumentException("[rank_features] fields take hashes that map a feature to a strictly positive float, but got unexpected token " + token);
                }
            }
            token = context.parser().nextToken();
        }
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        throw new AssertionError((Object)"parse is implemented directly");
    }

    protected boolean indexedByDefault() {
        return false;
    }

    protected boolean docValuesByDefault() {
        return false;
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static final class RankFeaturesFieldType
    extends MappedFieldType {
        public RankFeaturesFieldType(String name, Map<String, String> meta) {
            super(name, false, false, TextSearchInfo.NONE, meta);
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        public String typeName() {
            return RankFeaturesFieldMapper.CONTENT_TYPE;
        }

        public Query existsQuery(QueryShardContext context) {
            throw new IllegalArgumentException("[rank_features] fields do not support [exists] queries");
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            throw new IllegalArgumentException("[rank_features] fields do not support sorting, scripting or aggregating");
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new IllegalArgumentException("Queries on [rank_features] fields are not supported");
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            return new Builder(name);
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder> {
        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public RankFeaturesFieldMapper build(Mapper.BuilderContext context) {
            return new RankFeaturesFieldMapper(this.name, this.fieldType, new RankFeaturesFieldType(this.buildFullName(context), this.meta), this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

