/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.result;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.testing.junit.result.TestMethodResult;
import org.gradle.api.tasks.testing.TestResult;

public class TestClassResult {
    private final List<TestMethodResult> methodResults = new ArrayList<TestMethodResult>();
    private final String className;
    private final String classDisplayName;
    private long startTime;
    private int failuresCount;
    private int skippedCount;
    private long id;

    public TestClassResult(long id, String className, long startTime) {
        this(id, className, null, startTime);
    }

    public TestClassResult(long id, String className, @Nullable String classDisplayName, long startTime) {
        if (id < 1L) {
            throw new IllegalArgumentException("id must be > 0");
        }
        this.id = id;
        this.className = className;
        this.startTime = startTime;
        this.classDisplayName = classDisplayName == null ? className : classDisplayName;
    }

    public long getId() {
        return this.id;
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassDisplayName() {
        return this.classDisplayName;
    }

    public TestClassResult add(TestMethodResult methodResult) {
        if (methodResult.getResultType() == TestResult.ResultType.FAILURE) {
            ++this.failuresCount;
        }
        if (methodResult.getResultType() == TestResult.ResultType.SKIPPED) {
            ++this.skippedCount;
        }
        this.methodResults.add(methodResult);
        return this;
    }

    public List<TestMethodResult> getResults() {
        return this.methodResults;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getTestsCount() {
        return this.methodResults.size();
    }

    public int getFailuresCount() {
        return this.failuresCount;
    }

    public int getSkippedCount() {
        return this.skippedCount;
    }

    public long getDuration() {
        long end = this.startTime;
        for (TestMethodResult m : this.methodResults) {
            if (end >= m.getEndTime()) continue;
            end = m.getEndTime();
        }
        return end - this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }
}

