/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Action;
import org.gradle.api.artifacts.CapabilitiesResolution;
import org.gradle.api.artifacts.ComponentSelection;
import org.gradle.api.artifacts.ComponentSelectionRules;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.DependencySubstitution;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ComponentSelectionRulesInternal;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.component.ComponentIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.ConflictResolution;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.dsl.ModuleVersionSelectorParsers;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencySubstitutions;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionRules;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionsInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.CapabilitiesResolutionInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultCachePolicy;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultComponentSelectionRules;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.ModuleForcingResolveRule;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.locking.NoOpDependencyLockingProvider;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.rules.SpecRuleAction;
import org.gradle.internal.typeconversion.NormalizedTimeUnit;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.TimeUnitsParser;
import org.gradle.vcs.internal.VcsResolver;

public class DefaultResolutionStrategy
implements ResolutionStrategyInternal {
    private final Set<Object> forcedModules = new LinkedHashSet<Object>();
    private Set<ModuleVersionSelector> parsedForcedModules;
    private ConflictResolution conflictResolution = ConflictResolution.latest;
    private final DefaultComponentSelectionRules componentSelectionRules;
    private final DefaultCachePolicy cachePolicy;
    private final DependencySubstitutionsInternal dependencySubstitutions;
    private final DependencySubstitutionRules globalDependencySubstitutionRules;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final VcsResolver vcsResolver;
    private final ComponentSelectorConverter componentSelectorConverter;
    private final DependencyLockingProvider dependencyLockingProvider;
    private final CapabilitiesResolutionInternal capabilitiesResolution;
    private MutationValidator mutationValidator = MutationValidator.IGNORE;
    private boolean dependencyLockingEnabled = false;
    private boolean assumeFluidDependencies;
    private ResolutionStrategy.SortOrder sortOrder = ResolutionStrategy.SortOrder.DEFAULT;
    private boolean failOnDynamicVersions;
    private boolean failOnChangingVersions;
    private boolean verifyDependencies = true;
    private static final String ASSUME_FLUID_DEPENDENCIES = "org.gradle.resolution.assumeFluidDependencies";

    public DefaultResolutionStrategy(DependencySubstitutionRules globalDependencySubstitutionRules, VcsResolver vcsResolver, ComponentIdentifierFactory componentIdentifierFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, ComponentSelectorConverter componentSelectorConverter, DependencyLockingProvider dependencyLockingProvider, CapabilitiesResolutionInternal capabilitiesResolution, Instantiator instantiator, ObjectFactory objectFactory, ImmutableAttributesFactory attributesFactory, NotationParser<Object, Capability> capabilitiesNotationParser) {
        this(new DefaultCachePolicy(), DefaultDependencySubstitutions.forResolutionStrategy(componentIdentifierFactory, moduleIdentifierFactory, instantiator, objectFactory, attributesFactory, capabilitiesNotationParser), globalDependencySubstitutionRules, vcsResolver, moduleIdentifierFactory, componentSelectorConverter, dependencyLockingProvider, capabilitiesResolution);
    }

    DefaultResolutionStrategy(DefaultCachePolicy cachePolicy, DependencySubstitutionsInternal dependencySubstitutions, DependencySubstitutionRules globalDependencySubstitutionRules, VcsResolver vcsResolver, ImmutableModuleIdentifierFactory moduleIdentifierFactory, ComponentSelectorConverter componentSelectorConverter, DependencyLockingProvider dependencyLockingProvider, CapabilitiesResolutionInternal capabilitiesResolution) {
        this.cachePolicy = cachePolicy;
        this.dependencySubstitutions = dependencySubstitutions;
        this.globalDependencySubstitutionRules = globalDependencySubstitutionRules;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.componentSelectionRules = new DefaultComponentSelectionRules(moduleIdentifierFactory);
        this.vcsResolver = vcsResolver;
        this.componentSelectorConverter = componentSelectorConverter;
        this.dependencyLockingProvider = dependencyLockingProvider;
        this.capabilitiesResolution = capabilitiesResolution;
        this.assumeFluidDependencies = Boolean.getBoolean(ASSUME_FLUID_DEPENDENCIES);
    }

    @Override
    public void setMutationValidator(MutationValidator validator) {
        this.mutationValidator = validator;
        this.cachePolicy.setMutationValidator(validator);
        this.componentSelectionRules.setMutationValidator(validator);
        this.dependencySubstitutions.setMutationValidator(validator);
    }

    public Set<ModuleVersionSelector> getForcedModules() {
        if (this.parsedForcedModules == null) {
            this.parsedForcedModules = (Set)ModuleVersionSelectorParsers.multiParser().parseNotation(this.forcedModules);
        }
        return Collections.unmodifiableSet(this.parsedForcedModules);
    }

    public ResolutionStrategy failOnVersionConflict() {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.conflictResolution = ConflictResolution.strict;
        return this;
    }

    public ResolutionStrategy failOnDynamicVersions() {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.failOnDynamicVersions = true;
        return this;
    }

    public ResolutionStrategy failOnChangingVersions() {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.failOnChangingVersions = true;
        return this;
    }

    public ResolutionStrategy failOnNonReproducibleResolution() {
        this.failOnChangingVersions();
        this.failOnDynamicVersions();
        return this;
    }

    public void preferProjectModules() {
        this.conflictResolution = ConflictResolution.preferProjectModules;
    }

    public ResolutionStrategy activateDependencyLocking() {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.dependencyLockingEnabled = true;
        return this;
    }

    public ResolutionStrategy deactivateDependencyLocking() {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.dependencyLockingEnabled = false;
        return this;
    }

    public void sortArtifacts(ResolutionStrategy.SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public ResolutionStrategy capabilitiesResolution(Action<? super CapabilitiesResolution> action) {
        action.execute((Object)this.capabilitiesResolution);
        return this;
    }

    public CapabilitiesResolution getCapabilitiesResolution() {
        return this.capabilitiesResolution;
    }

    @Override
    public ResolutionStrategy.SortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public ConflictResolution getConflictResolution() {
        return this.conflictResolution;
    }

    public DefaultResolutionStrategy force(Object ... moduleVersionSelectorNotations) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.parsedForcedModules = null;
        Collections.addAll(this.forcedModules, moduleVersionSelectorNotations);
        return this;
    }

    public ResolutionStrategy eachDependency(Action<? super DependencyResolveDetails> rule) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.dependencySubstitutions.allWithDependencyResolveDetails(rule, this.componentSelectorConverter);
        return this;
    }

    @Override
    public Action<DependencySubstitution> getDependencySubstitutionRule() {
        Set<ModuleVersionSelector> forcedModules = this.getForcedModules();
        Action moduleForcingResolveRule = (Action)Cast.uncheckedCast((Object)(forcedModules.isEmpty() ? Actions.doNothing() : new ModuleForcingResolveRule(forcedModules)));
        Action localDependencySubstitutionsAction = this.dependencySubstitutions.getRuleAction();
        Action<DependencySubstitution> globalDependencySubstitutionRulesAction = this.globalDependencySubstitutionRules.getRuleAction();
        return Actions.composite((Action[])new Action[]{moduleForcingResolveRule, localDependencySubstitutionsAction, globalDependencySubstitutionRulesAction});
    }

    @Override
    public void assumeFluidDependencies() {
        this.assumeFluidDependencies = true;
    }

    @Override
    public boolean resolveGraphToDetermineTaskDependencies() {
        return this.assumeFluidDependencies || this.dependencySubstitutions.hasRules() || this.globalDependencySubstitutionRules.hasRules() || this.vcsResolver.hasRules();
    }

    public DefaultResolutionStrategy setForcedModules(Object ... moduleVersionSelectorNotations) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.forcedModules.clear();
        this.force(moduleVersionSelectorNotations);
        return this;
    }

    @Override
    public DefaultCachePolicy getCachePolicy() {
        return this.cachePolicy;
    }

    public void cacheDynamicVersionsFor(int value, String units) {
        NormalizedTimeUnit timeUnit = new TimeUnitsParser().parseNotation((CharSequence)units, value);
        this.cacheDynamicVersionsFor(timeUnit.getValue(), timeUnit.getTimeUnit());
    }

    public void cacheDynamicVersionsFor(int value, TimeUnit units) {
        this.cachePolicy.cacheDynamicVersionsFor(value, units);
    }

    public void cacheChangingModulesFor(int value, String units) {
        NormalizedTimeUnit timeUnit = new TimeUnitsParser().parseNotation((CharSequence)units, value);
        this.cacheChangingModulesFor(timeUnit.getValue(), timeUnit.getTimeUnit());
    }

    public void cacheChangingModulesFor(int value, TimeUnit units) {
        this.cachePolicy.cacheChangingModulesFor(value, units);
    }

    @Override
    public ComponentSelectionRulesInternal getComponentSelection() {
        return this.componentSelectionRules;
    }

    public ResolutionStrategy componentSelection(Action<? super ComponentSelectionRules> action) {
        action.execute((Object)this.componentSelectionRules);
        return this;
    }

    @Override
    public DependencySubstitutionsInternal getDependencySubstitution() {
        return this.dependencySubstitutions;
    }

    public ResolutionStrategy dependencySubstitution(Action<? super DependencySubstitutions> action) {
        action.execute((Object)this.dependencySubstitutions);
        return this;
    }

    @Override
    public DefaultResolutionStrategy copy() {
        DefaultResolutionStrategy out = new DefaultResolutionStrategy(this.cachePolicy.copy(), this.dependencySubstitutions.copy(), this.globalDependencySubstitutionRules, this.vcsResolver, this.moduleIdentifierFactory, this.componentSelectorConverter, this.dependencyLockingProvider, this.capabilitiesResolution);
        if (this.conflictResolution == ConflictResolution.strict) {
            out.failOnVersionConflict();
        } else if (this.conflictResolution == ConflictResolution.preferProjectModules) {
            out.preferProjectModules();
        }
        out.setForcedModules(this.forcedModules);
        for (SpecRuleAction<? super ComponentSelection> ruleAction : this.componentSelectionRules.getRules()) {
            out.getComponentSelection().addRule(ruleAction);
        }
        if (this.isDependencyLockingEnabled()) {
            out.activateDependencyLocking();
        }
        if (this.isFailingOnDynamicVersions()) {
            out.failOnDynamicVersions();
        }
        if (this.isFailingOnChangingVersions()) {
            out.failOnChangingVersions();
        }
        if (!this.isDependencyVerificationEnabled()) {
            out.disableDependencyVerification();
        }
        return out;
    }

    @Override
    public DependencyLockingProvider getDependencyLockingProvider() {
        if (this.dependencyLockingEnabled) {
            return this.dependencyLockingProvider;
        }
        return NoOpDependencyLockingProvider.getInstance();
    }

    @Override
    public boolean isDependencyLockingEnabled() {
        return this.dependencyLockingEnabled;
    }

    @Override
    public CapabilitiesResolutionInternal getCapabilitiesResolutionRules() {
        return this.capabilitiesResolution;
    }

    @Override
    public boolean isFailingOnDynamicVersions() {
        return this.failOnDynamicVersions;
    }

    @Override
    public boolean isFailingOnChangingVersions() {
        return this.failOnChangingVersions;
    }

    @Override
    public boolean isDependencyVerificationEnabled() {
        return this.verifyDependencies;
    }

    public ResolutionStrategy disableDependencyVerification() {
        this.verifyDependencies = false;
        return this;
    }

    public ResolutionStrategy enableDependencyVerification() {
        this.verifyDependencies = true;
        return this;
    }
}

