"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiToggle = exports.TYPES = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var typeToInputTypeMap = {
  single: 'radio',
  multi: 'checkbox'
};
var TYPES = Object.keys(typeToInputTypeMap);
exports.TYPES = TYPES;

var EuiToggle = function EuiToggle(_ref) {
  var id = _ref.id,
      className = _ref.className,
      checked = _ref.checked,
      children = _ref.children,
      inputClassName = _ref.inputClassName,
      isDisabled = _ref.isDisabled,
      label = _ref.label,
      name = _ref.name,
      onChange = _ref.onChange,
      title = _ref.title,
      type = _ref.type,
      value = _ref.value,
      dataTestSubj = _ref['data-test-subj'],
      rest = (0, _objectWithoutProperties2.default)(_ref, ["id", "className", "checked", "children", "inputClassName", "isDisabled", "label", "name", "onChange", "title", "type", "value", "data-test-subj"]);
  var classes = (0, _classnames.default)('euiToggle', {
    'euiToggle--checked': checked
  }, className);
  var inputClasses = (0, _classnames.default)('euiToggle__input', inputClassName);
  return _react.default.createElement("div", (0, _extends2.default)({
    className: classes
  }, rest), _react.default.createElement("input", {
    id: id,
    className: inputClasses,
    "aria-label": label,
    checked: checked,
    disabled: isDisabled,
    name: name,
    onChange: onChange,
    title: title,
    type: type ? typeToInputTypeMap[type] : undefined,
    value: value,
    "data-test-subj": dataTestSubj
  }), children);
};

exports.EuiToggle = EuiToggle;
EuiToggle.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  id: _propTypes.default.string,

  /**
       * Initial state of the toggle
       */
  checked: _propTypes.default.bool,

  /**
       * For handling the onChange event of the input
       */
  onChange: _propTypes.default.any,
  isDisabled: _propTypes.default.bool,
  name: _propTypes.default.string,

  /**
       * Determines the input type based on multiple or single item(s)
       */
  type: _propTypes.default.oneOf(["single", "multi"]),

  /**
       * What would typically be the input's label. Required for accessibility.
       */
  label: _propTypes.default.string.isRequired,

  /**
       * Additional classNames for the input itself
       */
  inputClassName: _propTypes.default.string,
  value: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired])
};
EuiToggle.defaultProps = {
  type: 'multi'
};
EuiToggle.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiToggle",
  "props": {
    "type": {
      "defaultValue": {
        "value": "'multi'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"single\"",
          "computed": false
        }, {
          "value": "\"multi\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Determines the input type based on multiple or single item(s)"
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "id": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "checked": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Initial state of the toggle"
    },
    "onChange": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": "For handling the onChange event of the input"
    },
    "isDisabled": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "name": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "label": {
      "type": {
        "name": "string"
      },
      "required": true,
      "description": "What would typically be the input's label. Required for accessibility."
    },
    "inputClassName": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": "Additional classNames for the input itself"
    },
    "value": {
      "type": {
        "name": "union",
        "value": [{
          "name": "string"
        }, {
          "name": "number"
        }]
      },
      "required": false,
      "description": ""
    }
  }
};