"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Field = void 0;

var _i18n = require("@kbn/i18n");

var _obj_define = require("./obj_define");

var _common = require("../../../common");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class Field {
  // esTypes might be undefined on old index patterns that have not been refreshed since we added
  // this prop. It is also undefined on scripted fields.
  constructor(indexPattern, spec, shortDotsEnable, {
    fieldFormats,
    onNotification
  }) {
    _defineProperty(this, "name", void 0);

    _defineProperty(this, "type", void 0);

    _defineProperty(this, "script", void 0);

    _defineProperty(this, "lang", void 0);

    _defineProperty(this, "count", void 0);

    _defineProperty(this, "esTypes", void 0);

    _defineProperty(this, "aggregatable", void 0);

    _defineProperty(this, "filterable", void 0);

    _defineProperty(this, "searchable", void 0);

    _defineProperty(this, "sortable", void 0);

    _defineProperty(this, "visualizable", void 0);

    _defineProperty(this, "scripted", void 0);

    _defineProperty(this, "subType", void 0);

    _defineProperty(this, "displayName", void 0);

    _defineProperty(this, "indexPattern", void 0);

    _defineProperty(this, "readFromDocValues", void 0);

    _defineProperty(this, "format", void 0);

    _defineProperty(this, "$$spec", void 0);

    _defineProperty(this, "conflictDescriptions", void 0);

    _defineProperty(this, "toSpec", () => ({}));

    // unwrap old instances of Field
    if (spec instanceof Field) spec = spec.$$spec; // construct this object using ObjDefine class, which
    // extends the Field.prototype but gets it's properties
    // defined using the logic below

    const obj = new _obj_define.ObjDefine(spec, Field.prototype);

    if (spec.name === '_source') {
      spec.type = '_source';
    } // find the type for this field, fallback to unknown type


    let type = (0, _common.getKbnFieldType)(spec.type);

    if (spec.type && !type) {
      const title = _i18n.i18n.translate('data.indexPatterns.unknownFieldHeader', {
        values: {
          type: spec.type
        },
        defaultMessage: 'Unknown field type {type}'
      });

      const text = _i18n.i18n.translate('data.indexPatterns.unknownFieldErrorMessage', {
        values: {
          name: spec.name,
          title: indexPattern.title
        },
        defaultMessage: 'Field {name} in indexPattern {title} is using an unknown field type.'
      });

      onNotification({
        title,
        text,
        color: 'danger',
        iconType: 'alert'
      });
    }

    if (!type) type = (0, _common.getKbnFieldType)('unknown');
    let format = spec.format;

    if (!_common.FieldFormat.isInstanceOfFieldFormat(format)) {
      format = indexPattern.fieldFormatMap && indexPattern.fieldFormatMap[spec.name] || fieldFormats.getDefaultInstance(spec.type, spec.esTypes);
    }

    const indexed = !!spec.indexed;
    const scripted = !!spec.scripted;
    const searchable = !!spec.searchable || scripted;
    const aggregatable = !!spec.aggregatable || scripted;
    const readFromDocValues = !!spec.readFromDocValues && !scripted;
    const sortable = spec.name === '_score' || (indexed || aggregatable) && type && type.sortable;
    const filterable = spec.name === '_id' || scripted || (indexed || searchable) && type && type.filterable;
    const visualizable = aggregatable;
    this.name = '';
    obj.fact('name');
    this.type = '';
    obj.fact('type');
    obj.fact('esTypes');
    obj.writ('count', spec.count || 0); // scripted objs

    obj.fact('scripted', scripted);
    obj.writ('script', scripted ? spec.script : null);
    obj.writ('lang', scripted ? spec.lang || 'painless' : null); // stats

    obj.fact('searchable', searchable);
    obj.fact('aggregatable', aggregatable);
    obj.fact('readFromDocValues', readFromDocValues); // usage flags, read-only and won't be saved

    obj.comp('format', format);
    obj.comp('sortable', sortable);
    obj.comp('filterable', filterable);
    obj.comp('visualizable', visualizable); // computed values

    obj.comp('indexPattern', indexPattern);
    obj.comp('displayName', shortDotsEnable ? (0, _common.shortenDottedString)(spec.name) : spec.name);
    this.$$spec = spec;
    obj.comp('$$spec', spec); // conflict info

    obj.writ('conflictDescriptions'); // multi info

    obj.fact('subType');
    const newObj = obj.create();

    newObj.toSpec = function () {
      var _this$indexPattern, _this$indexPattern$fi;

      return {
        count: this.count,
        script: this.script,
        lang: this.lang,
        conflictDescriptions: this.conflictDescriptions,
        name: this.name,
        type: this.type,
        esTypes: this.esTypes,
        scripted: this.scripted,
        searchable: this.searchable,
        aggregatable: this.aggregatable,
        readFromDocValues: this.readFromDocValues,
        subType: this.subType,
        format: ((_this$indexPattern = this.indexPattern) === null || _this$indexPattern === void 0 ? void 0 : (_this$indexPattern$fi = _this$indexPattern.fieldFormatMap[this.name]) === null || _this$indexPattern$fi === void 0 ? void 0 : _this$indexPattern$fi.toJSON()) || undefined
      };
    };

    return newObj;
  } // only providing type info as constructor returns new object instead of `this`


}

exports.Field = Field;