function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { Observable } from 'rxjs';
import { map, tap } from 'rxjs/operators';
import { createStateContainer } from '../../../../kibana_utils/public';
import { isFilterPinned, compareFilters, COMPARE_ALL_OPTIONS } from '../../../common';
export function createQueryStateObservable(_ref) {
  var timefilter = _ref.timefilter.timefilter,
      filterManager = _ref.filterManager;
  return new Observable(function (subscriber) {
    var state = createStateContainer({
      time: timefilter.getTime(),
      refreshInterval: timefilter.getRefreshInterval(),
      filters: filterManager.getFilters()
    });
    var currentChange = {};
    var subs = [timefilter.getTimeUpdate$().subscribe(function () {
      currentChange.time = true;
      state.set(_objectSpread(_objectSpread({}, state.get()), {}, {
        time: timefilter.getTime()
      }));
    }), timefilter.getRefreshIntervalUpdate$().subscribe(function () {
      currentChange.refreshInterval = true;
      state.set(_objectSpread(_objectSpread({}, state.get()), {}, {
        refreshInterval: timefilter.getRefreshInterval()
      }));
    }), filterManager.getUpdates$().subscribe(function () {
      currentChange.filters = true;

      var _state$get = state.get(),
          filters = _state$get.filters;

      var globalOld = filters === null || filters === void 0 ? void 0 : filters.filter(function (f) {
        return isFilterPinned(f);
      });
      var appOld = filters === null || filters === void 0 ? void 0 : filters.filter(function (f) {
        return !isFilterPinned(f);
      });
      var globalNew = filterManager.getGlobalFilters();
      var appNew = filterManager.getAppFilters();

      if (!globalOld || !compareFilters(globalOld, globalNew, COMPARE_ALL_OPTIONS)) {
        currentChange.globalFilters = true;
      }

      if (!appOld || !compareFilters(appOld, appNew, COMPARE_ALL_OPTIONS)) {
        currentChange.appFilters = true;
      }

      state.set(_objectSpread(_objectSpread({}, state.get()), {}, {
        filters: filterManager.getFilters()
      }));
    }), state.state$.pipe(map(function (newState) {
      return {
        state: newState,
        changes: currentChange
      };
    }), tap(function () {
      currentChange = {};
    })).subscribe(subscriber)];
    return function () {
      subs.forEach(function (s) {
        return s.unsubscribe();
      });
    };
  });
}