function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { EuiButton, EuiButtonEmpty // @ts-ignore
, EuiCodeEditor, EuiFieldText, EuiFlexGroup, EuiFlexItem, EuiForm, EuiFormRow, EuiPopoverTitle, EuiSpacer, EuiSwitch } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage, injectI18n } from '@kbn/i18n/react';
import { get } from 'lodash';
import React, { Component } from 'react';
import { GenericComboBox } from './generic_combo_box';
import { getFieldFromFilter as _getFieldFromFilter, getFilterableFields, getOperatorFromFilter, getOperatorOptions, isFilterValid as _isFilterValid } from './lib/filter_editor_utils';
import { PhraseValueInput } from './phrase_value_input';
import { PhrasesValuesInput } from './phrases_values_input';
import { RangeValueInput } from './range_value_input';
import { getIndexPatternFromFilter as _getIndexPatternFromFilter, buildFilter, buildCustomFilter, cleanFilter, getFilterParams } from '../../../../common';

var FilterEditorUI = /*#__PURE__*/function (_Component) {
  _inherits(FilterEditorUI, _Component);

  var _super = _createSuper(FilterEditorUI);

  function FilterEditorUI(props) {
    var _this;

    _classCallCheck(this, FilterEditorUI);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "toggleCustomEditor", function () {
      var isCustomEditorOpen = !_this.state.isCustomEditorOpen;

      _this.setState({
        isCustomEditorOpen: isCustomEditorOpen
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onIndexPatternChange", function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
          selectedIndexPattern = _ref2[0];

      var selectedField = undefined;
      var selectedOperator = undefined;
      var params = undefined;

      _this.setState({
        selectedIndexPattern: selectedIndexPattern,
        selectedField: selectedField,
        selectedOperator: selectedOperator,
        params: params
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onFieldChange", function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 1),
          selectedField = _ref4[0];

      var selectedOperator = undefined;
      var params = undefined;

      _this.setState({
        selectedField: selectedField,
        selectedOperator: selectedOperator,
        params: params
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onOperatorChange", function (_ref5) {
      var _ref6 = _slicedToArray(_ref5, 1),
          selectedOperator = _ref6[0];

      // Only reset params when the operator type changes
      var params = get(_this.state.selectedOperator, 'type') === get(selectedOperator, 'type') ? _this.state.params : undefined;

      _this.setState({
        selectedOperator: selectedOperator,
        params: params
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onCustomLabelSwitchChange", function (event) {
      var useCustomLabel = event.target.checked;
      var customLabel = event.target.checked ? '' : null;

      _this.setState({
        useCustomLabel: useCustomLabel,
        customLabel: customLabel
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onCustomLabelChange", function (event) {
      var customLabel = event.target.value;

      _this.setState({
        customLabel: customLabel
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onParamsChange", function (params) {
      _this.setState({
        params: params
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onQueryDslChange", function (queryDsl) {
      _this.setState({
        queryDsl: queryDsl
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onSubmit", function () {
      var _this$state = _this.state,
          indexPattern = _this$state.selectedIndexPattern,
          field = _this$state.selectedField,
          operator = _this$state.selectedOperator,
          params = _this$state.params,
          useCustomLabel = _this$state.useCustomLabel,
          customLabel = _this$state.customLabel,
          isCustomEditorOpen = _this$state.isCustomEditorOpen,
          queryDsl = _this$state.queryDsl;
      var $state = _this.props.filter.$state;

      if (!$state || !$state.store) {
        return; // typescript validation
      }

      var alias = useCustomLabel ? customLabel : null;

      if (isCustomEditorOpen) {
        var _this$props$filter$me = _this.props.filter.meta,
            index = _this$props$filter$me.index,
            disabled = _this$props$filter$me.disabled,
            negate = _this$props$filter$me.negate;
        var newIndex = index || _this.props.indexPatterns[0].id;
        var body = JSON.parse(queryDsl);

        var _filter = buildCustomFilter(newIndex, body, disabled, negate, alias, $state.store);

        _this.props.onSubmit(_filter);
      } else if (indexPattern && field && operator) {
        var _filter2 = buildFilter(indexPattern, field, operator.type, operator.negate, _this.props.filter.meta.disabled, params !== null && params !== void 0 ? params : '', alias, $state.store);

        _this.props.onSubmit(_filter2);
      }
    });

    _this.state = {
      selectedIndexPattern: _this.getIndexPatternFromFilter(),
      selectedField: _this.getFieldFromFilter(),
      selectedOperator: _this.getSelectedOperator(),
      params: getFilterParams(props.filter),
      useCustomLabel: props.filter.meta.alias !== null,
      customLabel: props.filter.meta.alias,
      queryDsl: JSON.stringify(cleanFilter(props.filter), null, 2),
      isCustomEditorOpen: _this.isUnknownFilterType()
    };
    return _this;
  }

  _createClass(FilterEditorUI, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(EuiPopoverTitle, null, /*#__PURE__*/React.createElement(EuiFlexGroup, {
        alignItems: "baseline",
        responsive: false
      }, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "data.filter.filterEditor.editFilterPopupTitle",
        defaultMessage: "Edit filter"
      })), /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false,
        className: "filterEditor__hiddenItem"
      }), /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
        size: "xs",
        onClick: this.toggleCustomEditor
      }, this.state.isCustomEditorOpen ? /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "data.filter.filterEditor.editFilterValuesButtonLabel",
        defaultMessage: "Edit filter values"
      }) : /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "data.filter.filterEditor.editQueryDslButtonLabel",
        defaultMessage: "Edit as Query DSL"
      }))))), /*#__PURE__*/React.createElement("div", {
        className: "globalFilterItem__editorForm"
      }, /*#__PURE__*/React.createElement(EuiForm, null, this.renderIndexPatternInput(), this.state.isCustomEditorOpen ? this.renderCustomEditor() : this.renderRegularEditor(), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/React.createElement(EuiSwitch, {
        id: "filterEditorCustomLabelSwitch",
        label: this.props.intl.formatMessage({
          id: 'data.filter.filterEditor.createCustomLabelSwitchLabel',
          defaultMessage: 'Create custom label?'
        }),
        checked: this.state.useCustomLabel,
        onChange: this.onCustomLabelSwitchChange
      }), this.state.useCustomLabel && /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/React.createElement(EuiFormRow, {
        label: this.props.intl.formatMessage({
          id: 'data.filter.filterEditor.createCustomLabelInputLabel',
          defaultMessage: 'Custom label'
        })
      }, /*#__PURE__*/React.createElement(EuiFieldText, {
        value: "".concat(this.state.customLabel),
        onChange: this.onCustomLabelChange
      }))), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/React.createElement(EuiFlexGroup, {
        direction: "rowReverse",
        alignItems: "center",
        responsive: false
      }, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiButton, {
        fill: true,
        onClick: this.onSubmit,
        isDisabled: !this.isFilterValid(),
        "data-test-subj": "saveFilter"
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "data.filter.filterEditor.saveButtonLabel",
        defaultMessage: "Save"
      }))), /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
        flush: "right",
        onClick: this.props.onCancel,
        "data-test-subj": "cancelSaveFilter"
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "data.filter.filterEditor.cancelButtonLabel",
        defaultMessage: "Cancel"
      }))), /*#__PURE__*/React.createElement(EuiFlexItem, null)))));
    }
  }, {
    key: "renderIndexPatternInput",
    value: function renderIndexPatternInput() {
      var _this2 = this;

      if (this.props.indexPatterns.length <= 1 && this.props.indexPatterns.find(function (indexPattern) {
        return indexPattern === _this2.getIndexPatternFromFilter();
      })) {
        /**
         * Don't render the index pattern selector if there's just one \ zero index patterns
         * and if the index pattern the filter was LOADED with is in the indexPatterns list.
         **/
        return '';
      }

      var selectedIndexPattern = this.state.selectedIndexPattern;
      return /*#__PURE__*/React.createElement(EuiFlexGroup, null, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiFormRow, {
        label: this.props.intl.formatMessage({
          id: 'data.filter.filterEditor.indexPatternSelectLabel',
          defaultMessage: 'Index Pattern'
        })
      }, /*#__PURE__*/React.createElement(IndexPatternComboBox, {
        placeholder: this.props.intl.formatMessage({
          id: 'data.filter.filterBar.indexPatternSelectPlaceholder',
          defaultMessage: 'Select an index pattern'
        }),
        options: this.props.indexPatterns,
        selectedOptions: selectedIndexPattern ? [selectedIndexPattern] : [],
        getLabel: function getLabel(indexPattern) {
          return indexPattern.title;
        },
        onChange: this.onIndexPatternChange,
        singleSelection: {
          asPlainText: true
        },
        isClearable: false,
        "data-test-subj": "filterIndexPatternsSelect"
      }))));
    }
  }, {
    key: "renderRegularEditor",
    value: function renderRegularEditor() {
      return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(EuiFlexGroup, {
        responsive: false,
        gutterSize: "s"
      }, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: 2
      }, this.renderFieldInput()), /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false,
        style: {
          flexBasis: 160
        }
      }, this.renderOperatorInput())), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/React.createElement("div", {
        "data-test-subj": "filterParams"
      }, this.renderParamsEditor()));
    }
  }, {
    key: "renderFieldInput",
    value: function renderFieldInput() {
      var _this$state2 = this.state,
          selectedIndexPattern = _this$state2.selectedIndexPattern,
          selectedField = _this$state2.selectedField;
      var fields = selectedIndexPattern ? getFilterableFields(selectedIndexPattern) : [];
      return /*#__PURE__*/React.createElement(EuiFormRow, {
        label: this.props.intl.formatMessage({
          id: 'data.filter.filterEditor.fieldSelectLabel',
          defaultMessage: 'Field'
        })
      }, /*#__PURE__*/React.createElement(FieldComboBox, {
        id: "fieldInput",
        isDisabled: !selectedIndexPattern,
        placeholder: this.props.intl.formatMessage({
          id: 'data.filter.filterEditor.fieldSelectPlaceholder',
          defaultMessage: 'Select a field first'
        }),
        options: fields,
        selectedOptions: selectedField ? [selectedField] : [],
        getLabel: function getLabel(field) {
          return field.name;
        },
        onChange: this.onFieldChange,
        singleSelection: {
          asPlainText: true
        },
        isClearable: false,
        className: "globalFilterEditor__fieldInput",
        "data-test-subj": "filterFieldSuggestionList"
      }));
    }
  }, {
    key: "renderOperatorInput",
    value: function renderOperatorInput() {
      var _this$state3 = this.state,
          selectedField = _this$state3.selectedField,
          selectedOperator = _this$state3.selectedOperator;
      var operators = selectedField ? getOperatorOptions(selectedField) : [];
      return /*#__PURE__*/React.createElement(EuiFormRow, {
        label: this.props.intl.formatMessage({
          id: 'data.filter.filterEditor.operatorSelectLabel',
          defaultMessage: 'Operator'
        })
      }, /*#__PURE__*/React.createElement(OperatorComboBox, {
        isDisabled: !selectedField,
        placeholder: selectedField ? this.props.intl.formatMessage({
          id: 'data.filter.filterEditor.operatorSelectPlaceholderSelect',
          defaultMessage: 'Select'
        }) : this.props.intl.formatMessage({
          id: 'data.filter.filterEditor.operatorSelectPlaceholderWaiting',
          defaultMessage: 'Waiting'
        }),
        options: operators,
        selectedOptions: selectedOperator ? [selectedOperator] : [],
        getLabel: function getLabel(_ref7) {
          var message = _ref7.message;
          return message;
        },
        onChange: this.onOperatorChange,
        singleSelection: {
          asPlainText: true
        },
        isClearable: false,
        "data-test-subj": "filterOperatorList"
      }));
    }
  }, {
    key: "renderCustomEditor",
    value: function renderCustomEditor() {
      return /*#__PURE__*/React.createElement(EuiFormRow, {
        label: i18n.translate('data.filter.filterEditor.queryDslLabel', {
          defaultMessage: 'Elasticsearch Query DSL'
        })
      }, /*#__PURE__*/React.createElement(EuiCodeEditor, {
        value: this.state.queryDsl,
        onChange: this.onQueryDslChange,
        mode: "json",
        width: "100%",
        height: "250px"
      }));
    }
  }, {
    key: "renderParamsEditor",
    value: function renderParamsEditor() {
      var indexPattern = this.state.selectedIndexPattern;

      if (!indexPattern || !this.state.selectedOperator) {
        return '';
      }

      switch (this.state.selectedOperator.type) {
        case 'exists':
          return '';

        case 'phrase':
          return /*#__PURE__*/React.createElement(PhraseValueInput, {
            indexPattern: indexPattern,
            field: this.state.selectedField,
            value: this.state.params,
            onChange: this.onParamsChange,
            "data-test-subj": "phraseValueInput"
          });

        case 'phrases':
          return /*#__PURE__*/React.createElement(PhrasesValuesInput, {
            indexPattern: indexPattern,
            field: this.state.selectedField,
            values: this.state.params,
            onChange: this.onParamsChange
          });

        case 'range':
          return /*#__PURE__*/React.createElement(RangeValueInput, {
            field: this.state.selectedField,
            value: this.state.params,
            onChange: this.onParamsChange
          });
      }
    }
  }, {
    key: "isUnknownFilterType",
    value: function isUnknownFilterType() {
      var type = this.props.filter.meta.type;
      return !!type && !['phrase', 'phrases', 'range', 'exists'].includes(type);
    }
  }, {
    key: "getIndexPatternFromFilter",
    value: function getIndexPatternFromFilter() {
      return _getIndexPatternFromFilter(this.props.filter, this.props.indexPatterns);
    }
  }, {
    key: "getFieldFromFilter",
    value: function getFieldFromFilter() {
      var indexPattern = this.getIndexPatternFromFilter();
      return indexPattern && _getFieldFromFilter(this.props.filter, indexPattern);
    }
  }, {
    key: "getSelectedOperator",
    value: function getSelectedOperator() {
      return getOperatorFromFilter(this.props.filter);
    }
  }, {
    key: "isFilterValid",
    value: function isFilterValid() {
      var _this$state4 = this.state,
          isCustomEditorOpen = _this$state4.isCustomEditorOpen,
          queryDsl = _this$state4.queryDsl,
          indexPattern = _this$state4.selectedIndexPattern,
          field = _this$state4.selectedField,
          operator = _this$state4.selectedOperator,
          params = _this$state4.params;

      if (isCustomEditorOpen) {
        try {
          return Boolean(JSON.parse(queryDsl));
        } catch (e) {
          return false;
        }
      }

      return _isFilterValid(indexPattern, field, operator, params);
    }
  }]);

  return FilterEditorUI;
}(Component);

function IndexPatternComboBox(props) {
  return GenericComboBox(props);
}

function FieldComboBox(props) {
  return GenericComboBox(props);
}

function OperatorComboBox(props) {
  return GenericComboBox(props);
}

export var FilterEditor = injectI18n(FilterEditorUI);