function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { FormattedMessage, I18nProvider } from '@kbn/i18n/react';
import { EuiCallOut, EuiLink, EuiLoadingSpinner, EuiPageContent } from '@elastic/eui';
import { ElasticRequestState, useEsDocSearch } from './use_es_doc_search';
import { getServices } from '../../../kibana_services';
import { DocViewer } from '../doc_viewer/doc_viewer';
export function Doc(props) {
  var _useEsDocSearch = useEsDocSearch(props),
      _useEsDocSearch2 = _slicedToArray(_useEsDocSearch, 3),
      reqState = _useEsDocSearch2[0],
      hit = _useEsDocSearch2[1],
      indexPattern = _useEsDocSearch2[2];

  return /*#__PURE__*/React.createElement(I18nProvider, null, /*#__PURE__*/React.createElement(EuiPageContent, null, reqState === ElasticRequestState.NotFoundIndexPattern && /*#__PURE__*/React.createElement(EuiCallOut, {
    color: "danger",
    "data-test-subj": "doc-msg-notFoundIndexPattern",
    iconType: "alert",
    title: /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "discover.doc.failedToLocateIndexPattern",
      defaultMessage: "No index pattern matches ID {indexPatternId}",
      values: {
        indexPatternId: props.indexPatternId
      }
    })
  }), reqState === ElasticRequestState.NotFound && /*#__PURE__*/React.createElement(EuiCallOut, {
    color: "danger",
    "data-test-subj": "doc-msg-notFound",
    iconType: "alert",
    title: /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "discover.doc.failedToLocateDocumentDescription",
      defaultMessage: "Cannot find document"
    })
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "discover.doc.couldNotFindDocumentsDescription",
    defaultMessage: "No documents match that ID."
  })), reqState === ElasticRequestState.Error && /*#__PURE__*/React.createElement(EuiCallOut, {
    color: "danger",
    "data-test-subj": "doc-msg-error",
    iconType: "alert",
    title: /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "discover.doc.failedToExecuteQueryDescription",
      defaultMessage: "Cannot run search"
    })
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "discover.doc.somethingWentWrongDescription",
    defaultMessage: "{indexName} is missing.",
    values: {
      indexName: props.index
    }
  }), ' ', /*#__PURE__*/React.createElement(EuiLink, {
    href: "https://www.elastic.co/guide/en/elasticsearch/reference/".concat(getServices().metadata.branch, "/indices-exists.html"),
    target: "_blank"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "discover.doc.somethingWentWrongDescriptionAddon",
    defaultMessage: "Please ensure the index exists."
  }))), reqState === ElasticRequestState.Loading && /*#__PURE__*/React.createElement(EuiCallOut, {
    "data-test-subj": "doc-msg-loading"
  }, /*#__PURE__*/React.createElement(EuiLoadingSpinner, {
    size: "m"
  }), ' ', /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "discover.doc.loadingDescription",
    defaultMessage: "Loading\u2026"
  })), reqState === ElasticRequestState.Found && hit !== null && indexPattern && /*#__PURE__*/React.createElement("div", {
    "data-test-subj": "doc-hit"
  }, /*#__PURE__*/React.createElement(DocViewer, {
    hit: hit,
    indexPattern: indexPattern
  }))));
}