function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { getTimelionVisualizationConfig } from './timelion_vis_fn';
import { getTimelionVisDefinition } from './timelion_vis_type';
import { setIndexPatterns, setSavedObjectsClient } from './helpers/plugin_services';
import './index.scss';
import { getArgValueSuggestions } from './helpers/arg_value_suggestions';
/** @internal */

/** @internal */
export var TimelionVisPlugin = /*#__PURE__*/function () {
  function TimelionVisPlugin(initializerContext) {
    _classCallCheck(this, TimelionVisPlugin);

    this.initializerContext = initializerContext;
  }

  _createClass(TimelionVisPlugin, [{
    key: "setup",
    value: function setup(core, _ref) {
      var expressions = _ref.expressions,
          visualizations = _ref.visualizations,
          data = _ref.data;
      var dependencies = {
        uiSettings: core.uiSettings,
        http: core.http,
        timefilter: data.query.timefilter.timefilter
      };
      expressions.registerFunction(function () {
        return getTimelionVisualizationConfig(dependencies);
      });
      visualizations.createReactVisualization(getTimelionVisDefinition(dependencies));
    }
  }, {
    key: "start",
    value: function start(core, plugins) {
      setIndexPatterns(plugins.data.indexPatterns);
      setSavedObjectsClient(core.savedObjects.client);

      if (this.initializerContext.config.get().ui.enabled === false) {
        core.chrome.navLinks.update('timelion', {
          hidden: true
        });
      }

      return {
        getArgValueSuggestions: getArgValueSuggestions
      };
    }
  }]);

  return TimelionVisPlugin;
}();