function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { indexPatterns } from '../../../../plugins/data/public';
import { getUISettings, getSavedObjects } from '../services';
export function getIndexPattern(_x) {
  return _getIndexPattern.apply(this, arguments);
}

function _getIndexPattern() {
  _getIndexPattern = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(savedVis) {
    var savedObjectsClient, defaultIndex, indexPatternObjects, _indexPatternObjects$, _indexPatternObjects$2, indexPattern, savedObject;

    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            if (!(savedVis.visState.type !== 'metrics')) {
              _context.next = 2;
              break;
            }

            return _context.abrupt("return", savedVis.searchSource.getField('index'));

          case 2:
            savedObjectsClient = getSavedObjects().client;
            defaultIndex = getUISettings().get('defaultIndex');

            if (!savedVis.visState.params.index_pattern) {
              _context.next = 10;
              break;
            }

            _context.next = 7;
            return savedObjectsClient.find({
              type: 'index-pattern',
              fields: ['title', 'fields'],
              search: "\"".concat(savedVis.visState.params.index_pattern, "\""),
              searchFields: ['title']
            });

          case 7:
            indexPatternObjects = _context.sent;
            _indexPatternObjects$ = indexPatternObjects.savedObjects.map(indexPatterns.getFromSavedObject), _indexPatternObjects$2 = _slicedToArray(_indexPatternObjects$, 1), indexPattern = _indexPatternObjects$2[0];
            return _context.abrupt("return", indexPattern);

          case 10:
            _context.next = 12;
            return savedObjectsClient.get('index-pattern', defaultIndex);

          case 12:
            savedObject = _context.sent;
            return _context.abrupt("return", indexPatterns.getFromSavedObject(savedObject));

          case 14:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _getIndexPattern.apply(this, arguments);
}