function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useEffect, useState, cloneElement } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { throttle } from '../color_picker/utils';
import { EuiWindowEvent, keys, htmlIdGenerator } from '../../services';
import { EuiFocusTrap } from '../focus_trap';
import { EuiOverlayMask } from '../overlay_mask';
import { EuiButtonEmpty } from '../button';
import { EuiI18n } from '../i18n';
import { EuiScreenReaderOnly } from '../accessibility';
export var EuiCollapsibleNav = function EuiCollapsibleNav(_ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$isDocked = _ref.isDocked,
      isDocked = _ref$isDocked === void 0 ? false : _ref$isDocked,
      _ref$isOpen = _ref.isOpen,
      isOpen = _ref$isOpen === void 0 ? false : _ref$isOpen,
      button = _ref.button,
      _ref$showButtonIfDock = _ref.showButtonIfDocked,
      showButtonIfDocked = _ref$showButtonIfDock === void 0 ? false : _ref$showButtonIfDock,
      _ref$dockedBreakpoint = _ref.dockedBreakpoint,
      dockedBreakpoint = _ref$dockedBreakpoint === void 0 ? 992 : _ref$dockedBreakpoint,
      _ref$showCloseButton = _ref.showCloseButton,
      showCloseButton = _ref$showCloseButton === void 0 ? true : _ref$showCloseButton,
      closeButtonProps = _ref.closeButtonProps,
      onClose = _ref.onClose,
      id = _ref.id,
      maskProps = _ref.maskProps,
      rest = _objectWithoutProperties(_ref, ["children", "className", "isDocked", "isOpen", "button", "showButtonIfDocked", "dockedBreakpoint", "showCloseButton", "closeButtonProps", "onClose", "id", "maskProps"]);

  var _useState = useState(id || htmlIdGenerator()('euiCollapsibleNav')),
      _useState2 = _slicedToArray(_useState, 1),
      flyoutID = _useState2[0];

  var _useState3 = useState(window.innerWidth >= dockedBreakpoint),
      _useState4 = _slicedToArray(_useState3, 2),
      windowIsLargeEnoughToDock = _useState4[0],
      setWindowIsLargeEnoughToDock = _useState4[1];

  var navIsDocked = isDocked && windowIsLargeEnoughToDock;
  var functionToCallOnWindowResize = throttle(function () {
    if (window.innerWidth < dockedBreakpoint) {
      setWindowIsLargeEnoughToDock(false);
    } else {
      setWindowIsLargeEnoughToDock(true);
    } // reacts every 50ms to resize changes and always gets the final update

  }, 50); // Watch for docked status and appropriately add/remove body classes and resize handlers

  useEffect(function () {
    window.addEventListener('resize', functionToCallOnWindowResize);

    if (navIsDocked) {
      document.body.classList.add('euiBody--collapsibleNavIsDocked');
    } else if (isOpen) {
      document.body.classList.add('euiBody--collapsibleNavIsOpen');
    }

    return function () {
      document.body.classList.remove('euiBody--collapsibleNavIsDocked');
      document.body.classList.remove('euiBody--collapsibleNavIsOpen');
      window.removeEventListener('resize', functionToCallOnWindowResize);
    };
  }, [navIsDocked, functionToCallOnWindowResize, isOpen]);

  var onKeyDown = function onKeyDown(event) {
    if (event.key === keys.ESCAPE) {
      event.preventDefault();
      collapse();
    }
  };

  var collapse = function collapse() {
    // Skip collapsing if it is docked
    if (navIsDocked) {
      return;
    } else {
      onClose && onClose();
    }
  };

  var classes = classNames('euiCollapsibleNav', {
    'euiCollapsibleNav--isDocked': navIsDocked
  }, className);
  var optionalOverlay;

  if (!navIsDocked) {
    optionalOverlay = React.createElement(EuiOverlayMask, _extends({
      onClick: collapse,
      headerZindexLocation: "below"
    }, maskProps));
  } // Show a trigger button if one was passed but
  // not if navIsDocked and showButtonIfDocked is false


  var trigger = navIsDocked && !showButtonIfDocked ? undefined : button && cloneElement(button, {
    'aria-controls': flyoutID,
    'aria-expanded': isOpen,
    'aria-pressed': isOpen,
    className: classNames(button.props.className, 'euiCollapsibleNav__toggle')
  });
  var closeButton = showCloseButton && React.createElement(EuiScreenReaderOnly, {
    showOnFocus: true
  }, React.createElement(EuiButtonEmpty, _extends({
    onClick: collapse,
    size: "xs",
    textProps: {
      className: 'euiCollapsibleNav__closeButtonText'
    },
    iconType: "cross"
  }, closeButtonProps, {
    className: classNames('euiCollapsibleNav__closeButton', closeButtonProps && closeButtonProps.className)
  }), React.createElement(EuiI18n, {
    token: "euiCollapsibleNav.closeButtonLabel",
    default: "close"
  })));
  var flyout = React.createElement(React.Fragment, null, React.createElement(EuiWindowEvent, {
    event: "keydown",
    handler: onKeyDown
  }), optionalOverlay, React.createElement(EuiFocusTrap, {
    disabled: navIsDocked,
    clickOutsideDisables: true
  }, React.createElement("nav", _extends({
    id: flyoutID,
    className: classes
  }, rest), children, closeButton)));
  return React.createElement(React.Fragment, null, trigger, (isOpen || navIsDocked) && flyout);
};
EuiCollapsibleNav.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  children: PropTypes.node,

  /**
       * Keeps navigation flyout visible and push `<body>` content via padding
       */
  isDocked: PropTypes.bool,

  /**
       * Pixel value for customizing the minimum window width for enabling docking
       */
  dockedBreakpoint: PropTypes.number,

  /**
       * Shows the navigation flyout
       */
  isOpen: PropTypes.bool,

  /**
       * Button for controlling visible state of the nav
       */
  button: PropTypes.element,

  /**
       * Keeps the display of toggle button when in docked state
       */
  showButtonIfDocked: PropTypes.bool,

  /**
       * Keeps the display of floating close button.
       * If `false`, you must then keep the `button` displayed at all breakpoints.
       */
  showCloseButton: PropTypes.bool,

  /**
       * Extend the props of the close button, an EuiButtonEmpty
       */
  closeButtonProps: PropTypes.shape({
    href: PropTypes.string,
    onClick: PropTypes.func,
    iconType: PropTypes.oneOfType([PropTypes.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "annotation", "apmApp", "apmTrace", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, PropTypes.string.isRequired, PropTypes.elementType.isRequired]),
    iconSide: PropTypes.oneOf(["left", "right"]),
    color: PropTypes.oneOf(["primary", "danger", "disabled", "text", "ghost"]),
    size: PropTypes.oneOf(["xs", "s", "l"]),
    flush: PropTypes.oneOf(["left", "right"]),
    isDisabled: PropTypes.bool,
    target: PropTypes.string,
    rel: PropTypes.string,

    /**
       * Adds/swaps for loading spinner & disables
       */

    /**
       * Adds/swaps for loading spinner & disables
       */
    isLoading: PropTypes.bool,
    type: PropTypes.oneOf(["button", "submit"]),
    buttonRef: PropTypes.func,

    /**
       * Passes props to `euiButtonEmpty__content` span
       */

    /**
       * Passes props to `euiButtonEmpty__content` span
       */
    contentProps: PropTypes.any,

    /**
       * Passes props to `euiButtonEmpty__text` span
       */

    /**
       * Passes props to `euiButtonEmpty__text` span
       */
    textProps: PropTypes.any,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string
  }),
  onClose: PropTypes.func,

  /**
       * Adjustments to the EuiOverlayMask
       */
  maskProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,

    /**
       * Function that applies to clicking the mask itself and not the children
       */
    onClick: PropTypes.func,
    children: PropTypes.node,

    /**
       * Should the mask visually sit above or below the EuiHeader (controlled by z-index)
       */
    headerZindexLocation: PropTypes.oneOf(["above", "below"])
  })
};
EuiCollapsibleNav.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiCollapsibleNav",
  "props": {
    "isDocked": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Keeps navigation flyout visible and push `<body>` content via padding"
    },
    "isOpen": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Shows the navigation flyout"
    },
    "showButtonIfDocked": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Keeps the display of toggle button when in docked state"
    },
    "dockedBreakpoint": {
      "defaultValue": {
        "value": "992",
        "computed": false
      },
      "type": {
        "name": "number"
      },
      "required": false,
      "description": "Pixel value for customizing the minimum window width for enabling docking"
    },
    "showCloseButton": {
      "defaultValue": {
        "value": "true",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Keeps the display of floating close button.\nIf `false`, you must then keep the `button` displayed at all breakpoints."
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "children": {
      "type": {
        "name": "node"
      },
      "required": false,
      "description": ""
    },
    "button": {
      "type": {
        "name": "element"
      },
      "required": false,
      "description": "Button for controlling visible state of the nav"
    },
    "closeButtonProps": {
      "type": {
        "name": "shape",
        "value": {
          "href": {
            "name": "string",
            "required": false
          },
          "onClick": {
            "name": "func",
            "required": false
          },
          "iconType": {
            "name": "union",
            "value": [{
              "name": "enum",
              "value": [{
                "value": "\"accessibility\"",
                "computed": false
              }, {
                "value": "\"addDataApp\"",
                "computed": false
              }, {
                "value": "\"advancedSettingsApp\"",
                "computed": false
              }, {
                "value": "\"aggregate\"",
                "computed": false
              }, {
                "value": "\"alert\"",
                "computed": false
              }, {
                "value": "\"annotation\"",
                "computed": false
              }, {
                "value": "\"apmApp\"",
                "computed": false
              }, {
                "value": "\"apmTrace\"",
                "computed": false
              }, {
                "value": "\"apps\"",
                "computed": false
              }, {
                "value": "\"arrowDown\"",
                "computed": false
              }, {
                "value": "\"arrowLeft\"",
                "computed": false
              }, {
                "value": "\"arrowRight\"",
                "computed": false
              }, {
                "value": "\"arrowUp\"",
                "computed": false
              }, {
                "value": "\"asterisk\"",
                "computed": false
              }, {
                "value": "\"auditbeatApp\"",
                "computed": false
              }, {
                "value": "\"beaker\"",
                "computed": false
              }, {
                "value": "\"bell\"",
                "computed": false
              }, {
                "value": "\"bellSlash\"",
                "computed": false
              }, {
                "value": "\"bolt\"",
                "computed": false
              }, {
                "value": "\"boxesHorizontal\"",
                "computed": false
              }, {
                "value": "\"boxesVertical\"",
                "computed": false
              }, {
                "value": "\"branch\"",
                "computed": false
              }, {
                "value": "\"broom\"",
                "computed": false
              }, {
                "value": "\"brush\"",
                "computed": false
              }, {
                "value": "\"bug\"",
                "computed": false
              }, {
                "value": "\"bullseye\"",
                "computed": false
              }, {
                "value": "\"calendar\"",
                "computed": false
              }, {
                "value": "\"canvasApp\"",
                "computed": false
              }, {
                "value": "\"codeApp\"",
                "computed": false
              }, {
                "value": "\"check\"",
                "computed": false
              }, {
                "value": "\"checkInCircleFilled\"",
                "computed": false
              }, {
                "value": "\"cheer\"",
                "computed": false
              }, {
                "value": "\"clock\"",
                "computed": false
              }, {
                "value": "\"cloudDrizzle\"",
                "computed": false
              }, {
                "value": "\"cloudStormy\"",
                "computed": false
              }, {
                "value": "\"cloudSunny\"",
                "computed": false
              }, {
                "value": "\"compute\"",
                "computed": false
              }, {
                "value": "\"console\"",
                "computed": false
              }, {
                "value": "\"consoleApp\"",
                "computed": false
              }, {
                "value": "\"controlsHorizontal\"",
                "computed": false
              }, {
                "value": "\"controlsVertical\"",
                "computed": false
              }, {
                "value": "\"copy\"",
                "computed": false
              }, {
                "value": "\"copyClipboard\"",
                "computed": false
              }, {
                "value": "\"createAdvancedJob\"",
                "computed": false
              }, {
                "value": "\"createMultiMetricJob\"",
                "computed": false
              }, {
                "value": "\"createPopulationJob\"",
                "computed": false
              }, {
                "value": "\"createSingleMetricJob\"",
                "computed": false
              }, {
                "value": "\"cross\"",
                "computed": false
              }, {
                "value": "\"crossClusterReplicationApp\"",
                "computed": false
              }, {
                "value": "\"crosshairs\"",
                "computed": false
              }, {
                "value": "\"crossInACircleFilled\"",
                "computed": false
              }, {
                "value": "\"currency\"",
                "computed": false
              }, {
                "value": "\"cut\"",
                "computed": false
              }, {
                "value": "\"dashboardApp\"",
                "computed": false
              }, {
                "value": "\"database\"",
                "computed": false
              }, {
                "value": "\"dataVisualizer\"",
                "computed": false
              }, {
                "value": "\"devToolsApp\"",
                "computed": false
              }, {
                "value": "\"discoverApp\"",
                "computed": false
              }, {
                "value": "\"document\"",
                "computed": false
              }, {
                "value": "\"documentEdit\"",
                "computed": false
              }, {
                "value": "\"documents\"",
                "computed": false
              }, {
                "value": "\"dot\"",
                "computed": false
              }, {
                "value": "\"download\"",
                "computed": false
              }, {
                "value": "\"editorAlignCenter\"",
                "computed": false
              }, {
                "value": "\"editorAlignLeft\"",
                "computed": false
              }, {
                "value": "\"editorAlignRight\"",
                "computed": false
              }, {
                "value": "\"editorBold\"",
                "computed": false
              }, {
                "value": "\"editorCodeBlock\"",
                "computed": false
              }, {
                "value": "\"editorComment\"",
                "computed": false
              }, {
                "value": "\"editorDistributeHorizontal\"",
                "computed": false
              }, {
                "value": "\"editorDistributeVertical\"",
                "computed": false
              }, {
                "value": "\"editorHeading\"",
                "computed": false
              }, {
                "value": "\"editorItalic\"",
                "computed": false
              }, {
                "value": "\"editorItemAlignLeft\"",
                "computed": false
              }, {
                "value": "\"editorItemAlignBottom\"",
                "computed": false
              }, {
                "value": "\"editorItemAlignCenter\"",
                "computed": false
              }, {
                "value": "\"editorItemAlignMiddle\"",
                "computed": false
              }, {
                "value": "\"editorItemAlignRight\"",
                "computed": false
              }, {
                "value": "\"editorItemAlignTop\"",
                "computed": false
              }, {
                "value": "\"editorLink\"",
                "computed": false
              }, {
                "value": "\"editorOrderedList\"",
                "computed": false
              }, {
                "value": "\"editorPositionBottomLeft\"",
                "computed": false
              }, {
                "value": "\"editorPositionBottomRight\"",
                "computed": false
              }, {
                "value": "\"editorPositionTopLeft\"",
                "computed": false
              }, {
                "value": "\"editorPositionTopRight\"",
                "computed": false
              }, {
                "value": "\"editorRedo\"",
                "computed": false
              }, {
                "value": "\"editorStrike\"",
                "computed": false
              }, {
                "value": "\"editorTable\"",
                "computed": false
              }, {
                "value": "\"editorUnderline\"",
                "computed": false
              }, {
                "value": "\"editorUndo\"",
                "computed": false
              }, {
                "value": "\"editorUnorderedList\"",
                "computed": false
              }, {
                "value": "\"email\"",
                "computed": false
              }, {
                "value": "\"empty\"",
                "computed": false
              }, {
                "value": "\"emsApp\"",
                "computed": false
              }, {
                "value": "\"exit\"",
                "computed": false
              }, {
                "value": "\"expand\"",
                "computed": false
              }, {
                "value": "\"expandMini\"",
                "computed": false
              }, {
                "value": "\"exportAction\"",
                "computed": false
              }, {
                "value": "\"eye\"",
                "computed": false
              }, {
                "value": "\"eyeClosed\"",
                "computed": false
              }, {
                "value": "\"faceHappy\"",
                "computed": false
              }, {
                "value": "\"faceNeutral\"",
                "computed": false
              }, {
                "value": "\"faceSad\"",
                "computed": false
              }, {
                "value": "\"filebeatApp\"",
                "computed": false
              }, {
                "value": "\"filter\"",
                "computed": false
              }, {
                "value": "\"flag\"",
                "computed": false
              }, {
                "value": "\"folderCheck\"",
                "computed": false
              }, {
                "value": "\"folderClosed\"",
                "computed": false
              }, {
                "value": "\"folderExclamation\"",
                "computed": false
              }, {
                "value": "\"folderOpen\"",
                "computed": false
              }, {
                "value": "\"fullScreen\"",
                "computed": false
              }, {
                "value": "\"gear\"",
                "computed": false
              }, {
                "value": "\"gisApp\"",
                "computed": false
              }, {
                "value": "\"glasses\"",
                "computed": false
              }, {
                "value": "\"globe\"",
                "computed": false
              }, {
                "value": "\"grab\"",
                "computed": false
              }, {
                "value": "\"grabHorizontal\"",
                "computed": false
              }, {
                "value": "\"graphApp\"",
                "computed": false
              }, {
                "value": "\"grid\"",
                "computed": false
              }, {
                "value": "\"grokApp\"",
                "computed": false
              }, {
                "value": "\"heart\"",
                "computed": false
              }, {
                "value": "\"heartbeatApp\"",
                "computed": false
              }, {
                "value": "\"heatmap\"",
                "computed": false
              }, {
                "value": "\"help\"",
                "computed": false
              }, {
                "value": "\"home\"",
                "computed": false
              }, {
                "value": "\"iInCircle\"",
                "computed": false
              }, {
                "value": "\"image\"",
                "computed": false
              }, {
                "value": "\"importAction\"",
                "computed": false
              }, {
                "value": "\"indexClose\"",
                "computed": false
              }, {
                "value": "\"indexEdit\"",
                "computed": false
              }, {
                "value": "\"indexFlush\"",
                "computed": false
              }, {
                "value": "\"indexManagementApp\"",
                "computed": false
              }, {
                "value": "\"indexMapping\"",
                "computed": false
              }, {
                "value": "\"indexOpen\"",
                "computed": false
              }, {
                "value": "\"indexPatternApp\"",
                "computed": false
              }, {
                "value": "\"indexRollupApp\"",
                "computed": false
              }, {
                "value": "\"indexSettings\"",
                "computed": false
              }, {
                "value": "\"inputOutput\"",
                "computed": false
              }, {
                "value": "\"inspect\"",
                "computed": false
              }, {
                "value": "\"invert\"",
                "computed": false
              }, {
                "value": "\"ip\"",
                "computed": false
              }, {
                "value": "\"keyboardShortcut\"",
                "computed": false
              }, {
                "value": "\"kqlField\"",
                "computed": false
              }, {
                "value": "\"kqlFunction\"",
                "computed": false
              }, {
                "value": "\"kqlOperand\"",
                "computed": false
              }, {
                "value": "\"kqlSelector\"",
                "computed": false
              }, {
                "value": "\"kqlValue\"",
                "computed": false
              }, {
                "value": "\"lensApp\"",
                "computed": false
              }, {
                "value": "\"link\"",
                "computed": false
              }, {
                "value": "\"list\"",
                "computed": false
              }, {
                "value": "\"listAdd\"",
                "computed": false
              }, {
                "value": "\"lock\"",
                "computed": false
              }, {
                "value": "\"lockOpen\"",
                "computed": false
              }, {
                "value": "\"logsApp\"",
                "computed": false
              }, {
                "value": "\"logoAerospike\"",
                "computed": false
              }, {
                "value": "\"logoApache\"",
                "computed": false
              }, {
                "value": "\"logoAPM\"",
                "computed": false
              }, {
                "value": "\"logoAppSearch\"",
                "computed": false
              }, {
                "value": "\"logoAWS\"",
                "computed": false
              }, {
                "value": "\"logoAWSMono\"",
                "computed": false
              }, {
                "value": "\"logoAzure\"",
                "computed": false
              }, {
                "value": "\"logoAzureMono\"",
                "computed": false
              }, {
                "value": "\"logoBeats\"",
                "computed": false
              }, {
                "value": "\"logoBusinessAnalytics\"",
                "computed": false
              }, {
                "value": "\"logoCeph\"",
                "computed": false
              }, {
                "value": "\"logoCloud\"",
                "computed": false
              }, {
                "value": "\"logoCloudEnterprise\"",
                "computed": false
              }, {
                "value": "\"logoCode\"",
                "computed": false
              }, {
                "value": "\"logoCodesandbox\"",
                "computed": false
              }, {
                "value": "\"logoCouchbase\"",
                "computed": false
              }, {
                "value": "\"logoDocker\"",
                "computed": false
              }, {
                "value": "\"logoDropwizard\"",
                "computed": false
              }, {
                "value": "\"logoElastic\"",
                "computed": false
              }, {
                "value": "\"logoElasticsearch\"",
                "computed": false
              }, {
                "value": "\"logoElasticStack\"",
                "computed": false
              }, {
                "value": "\"logoEnterpriseSearch\"",
                "computed": false
              }, {
                "value": "\"logoEtcd\"",
                "computed": false
              }, {
                "value": "\"logoGCP\"",
                "computed": false
              }, {
                "value": "\"logoGCPMono\"",
                "computed": false
              }, {
                "value": "\"logoGithub\"",
                "computed": false
              }, {
                "value": "\"logoGmail\"",
                "computed": false
              }, {
                "value": "\"logoGolang\"",
                "computed": false
              }, {
                "value": "\"logoGoogleG\"",
                "computed": false
              }, {
                "value": "\"logoHAproxy\"",
                "computed": false
              }, {
                "value": "\"logoIBM\"",
                "computed": false
              }, {
                "value": "\"logoIBMMono\"",
                "computed": false
              }, {
                "value": "\"logoKafka\"",
                "computed": false
              }, {
                "value": "\"logoKibana\"",
                "computed": false
              }, {
                "value": "\"logoKubernetes\"",
                "computed": false
              }, {
                "value": "\"logoLogging\"",
                "computed": false
              }, {
                "value": "\"logoLogstash\"",
                "computed": false
              }, {
                "value": "\"logoMaps\"",
                "computed": false
              }, {
                "value": "\"logoMemcached\"",
                "computed": false
              }, {
                "value": "\"logoMetrics\"",
                "computed": false
              }, {
                "value": "\"logoMongodb\"",
                "computed": false
              }, {
                "value": "\"logoMySQL\"",
                "computed": false
              }, {
                "value": "\"logoNginx\"",
                "computed": false
              }, {
                "value": "\"logoObservability\"",
                "computed": false
              }, {
                "value": "\"logoOsquery\"",
                "computed": false
              }, {
                "value": "\"logoPhp\"",
                "computed": false
              }, {
                "value": "\"logoPostgres\"",
                "computed": false
              }, {
                "value": "\"logoPrometheus\"",
                "computed": false
              }, {
                "value": "\"logoRabbitmq\"",
                "computed": false
              }, {
                "value": "\"logoRedis\"",
                "computed": false
              }, {
                "value": "\"logoSecurity\"",
                "computed": false
              }, {
                "value": "\"logoSiteSearch\"",
                "computed": false
              }, {
                "value": "\"logoSketch\"",
                "computed": false
              }, {
                "value": "\"logoSlack\"",
                "computed": false
              }, {
                "value": "\"logoUptime\"",
                "computed": false
              }, {
                "value": "\"logoWebhook\"",
                "computed": false
              }, {
                "value": "\"logoWindows\"",
                "computed": false
              }, {
                "value": "\"logoWorkplaceSearch\"",
                "computed": false
              }, {
                "value": "\"logstashFilter\"",
                "computed": false
              }, {
                "value": "\"logstashIf\"",
                "computed": false
              }, {
                "value": "\"logstashInput\"",
                "computed": false
              }, {
                "value": "\"logstashOutput\"",
                "computed": false
              }, {
                "value": "\"logstashQueue\"",
                "computed": false
              }, {
                "value": "\"machineLearningApp\"",
                "computed": false
              }, {
                "value": "\"magnet\"",
                "computed": false
              }, {
                "value": "\"magnifyWithMinus\"",
                "computed": false
              }, {
                "value": "\"magnifyWithPlus\"",
                "computed": false
              }, {
                "value": "\"managementApp\"",
                "computed": false
              }, {
                "value": "\"mapMarker\"",
                "computed": false
              }, {
                "value": "\"memory\"",
                "computed": false
              }, {
                "value": "\"menu\"",
                "computed": false
              }, {
                "value": "\"menuLeft\"",
                "computed": false
              }, {
                "value": "\"menuRight\"",
                "computed": false
              }, {
                "value": "\"merge\"",
                "computed": false
              }, {
                "value": "\"metricbeatApp\"",
                "computed": false
              }, {
                "value": "\"metricsApp\"",
                "computed": false
              }, {
                "value": "\"minimize\"",
                "computed": false
              }, {
                "value": "\"minusInCircle\"",
                "computed": false
              }, {
                "value": "\"minusInCircleFilled\"",
                "computed": false
              }, {
                "value": "\"monitoringApp\"",
                "computed": false
              }, {
                "value": "\"moon\"",
                "computed": false
              }, {
                "value": "\"nested\"",
                "computed": false
              }, {
                "value": "\"node\"",
                "computed": false
              }, {
                "value": "\"notebookApp\"",
                "computed": false
              }, {
                "value": "\"number\"",
                "computed": false
              }, {
                "value": "\"offline\"",
                "computed": false
              }, {
                "value": "\"online\"",
                "computed": false
              }, {
                "value": "\"package\"",
                "computed": false
              }, {
                "value": "\"packetbeatApp\"",
                "computed": false
              }, {
                "value": "\"pageSelect\"",
                "computed": false
              }, {
                "value": "\"pagesSelect\"",
                "computed": false
              }, {
                "value": "\"partial\"",
                "computed": false
              }, {
                "value": "\"paperClip\"",
                "computed": false
              }, {
                "value": "\"pause\"",
                "computed": false
              }, {
                "value": "\"pencil\"",
                "computed": false
              }, {
                "value": "\"pin\"",
                "computed": false
              }, {
                "value": "\"pinFilled\"",
                "computed": false
              }, {
                "value": "\"pipelineApp\"",
                "computed": false
              }, {
                "value": "\"play\"",
                "computed": false
              }, {
                "value": "\"plusInCircle\"",
                "computed": false
              }, {
                "value": "\"plusInCircleFilled\"",
                "computed": false
              }, {
                "value": "\"popout\"",
                "computed": false
              }, {
                "value": "\"push\"",
                "computed": false
              }, {
                "value": "\"questionInCircle\"",
                "computed": false
              }, {
                "value": "\"quote\"",
                "computed": false
              }, {
                "value": "\"recentlyViewedApp\"",
                "computed": false
              }, {
                "value": "\"refresh\"",
                "computed": false
              }, {
                "value": "\"reporter\"",
                "computed": false
              }, {
                "value": "\"reportingApp\"",
                "computed": false
              }, {
                "value": "\"save\"",
                "computed": false
              }, {
                "value": "\"savedObjectsApp\"",
                "computed": false
              }, {
                "value": "\"scale\"",
                "computed": false
              }, {
                "value": "\"search\"",
                "computed": false
              }, {
                "value": "\"searchProfilerApp\"",
                "computed": false
              }, {
                "value": "\"securityAnalyticsApp\"",
                "computed": false
              }, {
                "value": "\"securityApp\"",
                "computed": false
              }, {
                "value": "\"securitySignal\"",
                "computed": false
              }, {
                "value": "\"securitySignalDetected\"",
                "computed": false
              }, {
                "value": "\"securitySignalResolved\"",
                "computed": false
              }, {
                "value": "\"shard\"",
                "computed": false
              }, {
                "value": "\"share\"",
                "computed": false
              }, {
                "value": "\"snowflake\"",
                "computed": false
              }, {
                "value": "\"sortable\"",
                "computed": false
              }, {
                "value": "\"sortDown\"",
                "computed": false
              }, {
                "value": "\"sortLeft\"",
                "computed": false
              }, {
                "value": "\"sortRight\"",
                "computed": false
              }, {
                "value": "\"sortUp\"",
                "computed": false
              }, {
                "value": "\"spacesApp\"",
                "computed": false
              }, {
                "value": "\"sqlApp\"",
                "computed": false
              }, {
                "value": "\"starEmpty\"",
                "computed": false
              }, {
                "value": "\"starEmptySpace\"",
                "computed": false
              }, {
                "value": "\"starFilled\"",
                "computed": false
              }, {
                "value": "\"starFilledSpace\"",
                "computed": false
              }, {
                "value": "\"starMinusEmpty\"",
                "computed": false
              }, {
                "value": "\"starMinusFilled\"",
                "computed": false
              }, {
                "value": "\"starPlusEmpty\"",
                "computed": false
              }, {
                "value": "\"starPlusFilled\"",
                "computed": false
              }, {
                "value": "\"stats\"",
                "computed": false
              }, {
                "value": "\"stop\"",
                "computed": false
              }, {
                "value": "\"stopFilled\"",
                "computed": false
              }, {
                "value": "\"stopSlash\"",
                "computed": false
              }, {
                "value": "\"storage\"",
                "computed": false
              }, {
                "value": "\"string\"",
                "computed": false
              }, {
                "value": "\"submodule\"",
                "computed": false
              }, {
                "value": "\"swatchInput\"",
                "computed": false
              }, {
                "value": "\"symlink\"",
                "computed": false
              }, {
                "value": "\"tableOfContents\"",
                "computed": false
              }, {
                "value": "\"tableDensityExpanded\"",
                "computed": false
              }, {
                "value": "\"tableDensityCompact\"",
                "computed": false
              }, {
                "value": "\"tableDensityNormal\"",
                "computed": false
              }, {
                "value": "\"tag\"",
                "computed": false
              }, {
                "value": "\"tear\"",
                "computed": false
              }, {
                "value": "\"temperature\"",
                "computed": false
              }, {
                "value": "\"timeline\"",
                "computed": false
              }, {
                "value": "\"timelionApp\"",
                "computed": false
              }, {
                "value": "\"training\"",
                "computed": false
              }, {
                "value": "\"trash\"",
                "computed": false
              }, {
                "value": "\"upgradeAssistantApp\"",
                "computed": false
              }, {
                "value": "\"uptimeApp\"",
                "computed": false
              }, {
                "value": "\"user\"",
                "computed": false
              }, {
                "value": "\"users\"",
                "computed": false
              }, {
                "value": "\"usersRolesApp\"",
                "computed": false
              }, {
                "value": "\"vector\"",
                "computed": false
              }, {
                "value": "\"videoPlayer\"",
                "computed": false
              }, {
                "value": "\"visArea\"",
                "computed": false
              }, {
                "value": "\"visAreaStacked\"",
                "computed": false
              }, {
                "value": "\"visBarHorizontal\"",
                "computed": false
              }, {
                "value": "\"visBarHorizontalStacked\"",
                "computed": false
              }, {
                "value": "\"visBarVertical\"",
                "computed": false
              }, {
                "value": "\"visBarVerticalStacked\"",
                "computed": false
              }, {
                "value": "\"visGauge\"",
                "computed": false
              }, {
                "value": "\"visGoal\"",
                "computed": false
              }, {
                "value": "\"visLine\"",
                "computed": false
              }, {
                "value": "\"visMapCoordinate\"",
                "computed": false
              }, {
                "value": "\"visMapRegion\"",
                "computed": false
              }, {
                "value": "\"visMetric\"",
                "computed": false
              }, {
                "value": "\"visPie\"",
                "computed": false
              }, {
                "value": "\"visTable\"",
                "computed": false
              }, {
                "value": "\"visTagCloud\"",
                "computed": false
              }, {
                "value": "\"visText\"",
                "computed": false
              }, {
                "value": "\"visTimelion\"",
                "computed": false
              }, {
                "value": "\"visualizeApp\"",
                "computed": false
              }, {
                "value": "\"visVega\"",
                "computed": false
              }, {
                "value": "\"visVisualBuilder\"",
                "computed": false
              }, {
                "value": "\"watchesApp\"",
                "computed": false
              }, {
                "value": "\"wrench\"",
                "computed": false
              }, {
                "value": "\"tokenClass\"",
                "computed": false
              }, {
                "value": "\"tokenProperty\"",
                "computed": false
              }, {
                "value": "\"tokenEnum\"",
                "computed": false
              }, {
                "value": "\"tokenVariable\"",
                "computed": false
              }, {
                "value": "\"tokenMethod\"",
                "computed": false
              }, {
                "value": "\"tokenAnnotation\"",
                "computed": false
              }, {
                "value": "\"tokenException\"",
                "computed": false
              }, {
                "value": "\"tokenInterface\"",
                "computed": false
              }, {
                "value": "\"tokenParameter\"",
                "computed": false
              }, {
                "value": "\"tokenField\"",
                "computed": false
              }, {
                "value": "\"tokenElement\"",
                "computed": false
              }, {
                "value": "\"tokenFunction\"",
                "computed": false
              }, {
                "value": "\"tokenBoolean\"",
                "computed": false
              }, {
                "value": "\"tokenString\"",
                "computed": false
              }, {
                "value": "\"tokenArray\"",
                "computed": false
              }, {
                "value": "\"tokenNumber\"",
                "computed": false
              }, {
                "value": "\"tokenConstant\"",
                "computed": false
              }, {
                "value": "\"tokenObject\"",
                "computed": false
              }, {
                "value": "\"tokenEvent\"",
                "computed": false
              }, {
                "value": "\"tokenKey\"",
                "computed": false
              }, {
                "value": "\"tokenNull\"",
                "computed": false
              }, {
                "value": "\"tokenStruct\"",
                "computed": false
              }, {
                "value": "\"tokenPackage\"",
                "computed": false
              }, {
                "value": "\"tokenOperator\"",
                "computed": false
              }, {
                "value": "\"tokenEnumMember\"",
                "computed": false
              }, {
                "value": "\"tokenRepo\"",
                "computed": false
              }, {
                "value": "\"tokenSymbol\"",
                "computed": false
              }, {
                "value": "\"tokenFile\"",
                "computed": false
              }, {
                "value": "\"tokenModule\"",
                "computed": false
              }, {
                "value": "\"tokenNamespace\"",
                "computed": false
              }, {
                "value": "\"tokenDate\"",
                "computed": false
              }, {
                "value": "\"tokenIP\"",
                "computed": false
              }, {
                "value": "\"tokenNested\"",
                "computed": false
              }, {
                "value": "\"tokenAlias\"",
                "computed": false
              }, {
                "value": "\"tokenShape\"",
                "computed": false
              }, {
                "value": "\"tokenGeo\"",
                "computed": false
              }, {
                "value": "\"tokenRange\"",
                "computed": false
              }, {
                "value": "\"tokenBinary\"",
                "computed": false
              }, {
                "value": "\"tokenJoin\"",
                "computed": false
              }, {
                "value": "\"tokenPercolator\"",
                "computed": false
              }, {
                "value": "\"tokenFlattened\"",
                "computed": false
              }, {
                "value": "\"tokenRankFeature\"",
                "computed": false
              }, {
                "value": "\"tokenRankFeatures\"",
                "computed": false
              }, {
                "value": "\"tokenKeyword\"",
                "computed": false
              }, {
                "value": "\"tokenCompletionSuggester\"",
                "computed": false
              }, {
                "value": "\"tokenDenseVector\"",
                "computed": false
              }, {
                "value": "\"tokenText\"",
                "computed": false
              }, {
                "value": "\"tokenTokenCount\"",
                "computed": false
              }, {
                "value": "\"tokenSearchType\"",
                "computed": false
              }, {
                "value": "\"tokenHistogram\"",
                "computed": false
              }]
            }, {
              "name": "string"
            }, {
              "name": "elementType"
            }],
            "required": false
          },
          "iconSide": {
            "name": "enum",
            "value": [{
              "value": "\"left\"",
              "computed": false
            }, {
              "value": "\"right\"",
              "computed": false
            }],
            "required": false
          },
          "color": {
            "name": "enum",
            "value": [{
              "value": "\"primary\"",
              "computed": false
            }, {
              "value": "\"danger\"",
              "computed": false
            }, {
              "value": "\"disabled\"",
              "computed": false
            }, {
              "value": "\"text\"",
              "computed": false
            }, {
              "value": "\"ghost\"",
              "computed": false
            }],
            "required": false
          },
          "size": {
            "name": "enum",
            "value": [{
              "value": "\"xs\"",
              "computed": false
            }, {
              "value": "\"s\"",
              "computed": false
            }, {
              "value": "\"l\"",
              "computed": false
            }],
            "required": false
          },
          "flush": {
            "name": "enum",
            "value": [{
              "value": "\"left\"",
              "computed": false
            }, {
              "value": "\"right\"",
              "computed": false
            }],
            "required": false
          },
          "isDisabled": {
            "name": "bool",
            "required": false
          },
          "target": {
            "name": "string",
            "required": false
          },
          "rel": {
            "name": "string",
            "required": false
          },
          "isLoading": {
            "name": "bool",
            "description": "Adds/swaps for loading spinner & disables",
            "required": false
          },
          "type": {
            "name": "enum",
            "value": [{
              "value": "\"button\"",
              "computed": false
            }, {
              "value": "\"submit\"",
              "computed": false
            }],
            "required": false
          },
          "buttonRef": {
            "name": "func",
            "required": false
          },
          "contentProps": {
            "name": "any",
            "description": "Passes props to `euiButtonEmpty__content` span",
            "required": false
          },
          "textProps": {
            "name": "any",
            "description": "Passes props to `euiButtonEmpty__text` span",
            "required": false
          },
          "className": {
            "name": "string",
            "required": false
          },
          "aria-label": {
            "name": "string",
            "required": false
          },
          "data-test-subj": {
            "name": "string",
            "required": false
          }
        }
      },
      "required": false,
      "description": "Extend the props of the close button, an EuiButtonEmpty"
    },
    "onClose": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    },
    "maskProps": {
      "type": {
        "name": "shape",
        "value": {
          "className": {
            "name": "string",
            "required": false
          },
          "aria-label": {
            "name": "string",
            "required": false
          },
          "data-test-subj": {
            "name": "string",
            "required": false
          },
          "onClick": {
            "name": "func",
            "description": "Function that applies to clicking the mask itself and not the children",
            "required": false
          },
          "children": {
            "name": "node",
            "required": false
          },
          "headerZindexLocation": {
            "name": "enum",
            "value": [{
              "value": "\"above\"",
              "computed": false
            }, {
              "value": "\"below\"",
              "computed": false
            }],
            "description": "Should the mask visually sit above or below the EuiHeader (controlled by z-index)",
            "required": false
          }
        }
      },
      "required": false,
      "description": "Adjustments to the EuiOverlayMask"
    }
  }
};