function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component, Fragment } from 'react';
import PropTypes from "prop-types";
import { EuiButtonEmpty } from '../../../button';
import { EuiIcon } from '../../../icon';
import { EuiPopover } from '../../../popover';
import { EuiTitle } from '../../../title';
import { EuiSpacer } from '../../../spacer';
import { EuiHorizontalRule } from '../../../horizontal_rule';
import { EuiText } from '../../../text';
import { EuiQuickSelect } from './quick_select';
import { EuiCommonlyUsedTimeRanges } from './commonly_used_time_ranges';
import { EuiRecentlyUsed } from './recently_used';
import { EuiRefreshInterval } from './refresh_interval';
export var EuiQuickSelectPopover =
/*#__PURE__*/
function (_Component) {
  _inherits(EuiQuickSelectPopover, _Component);

  function EuiQuickSelectPopover() {
    var _getPrototypeOf2;

    var _this;

    _classCallCheck(this, EuiQuickSelectPopover);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(EuiQuickSelectPopover)).call.apply(_getPrototypeOf2, [this].concat(args)));

    _defineProperty(_assertThisInitialized(_this), "state", {
      isOpen: false
    });

    _defineProperty(_assertThisInitialized(_this), "closePopover", function () {
      _this.setState({
        isOpen: false
      });
    });

    _defineProperty(_assertThisInitialized(_this), "togglePopover", function () {
      _this.setState(function (prevState) {
        return {
          isOpen: !prevState.isOpen
        };
      });
    });

    _defineProperty(_assertThisInitialized(_this), "applyTime", function (_ref) {
      var start = _ref.start,
          end = _ref.end,
          quickSelect = _ref.quickSelect,
          _ref$keepPopoverOpen = _ref.keepPopoverOpen,
          keepPopoverOpen = _ref$keepPopoverOpen === void 0 ? false : _ref$keepPopoverOpen;

      _this.props.applyTime({
        start: start,
        end: end
      });

      if (quickSelect) {
        _this.setState({
          prevQuickSelect: quickSelect
        });
      }

      if (!keepPopoverOpen) {
        _this.closePopover();
      }
    });

    _defineProperty(_assertThisInitialized(_this), "renderDateTimeSections", function () {
      var _this$props = _this.props,
          commonlyUsedRanges = _this$props.commonlyUsedRanges,
          dateFormat = _this$props.dateFormat,
          end = _this$props.end,
          isAutoRefreshOnly = _this$props.isAutoRefreshOnly,
          recentlyUsedRanges = _this$props.recentlyUsedRanges,
          start = _this$props.start;
      var prevQuickSelect = _this.state.prevQuickSelect;

      if (isAutoRefreshOnly) {
        return null;
      }

      return React.createElement(Fragment, null, React.createElement(EuiQuickSelect, {
        applyTime: _this.applyTime,
        start: start,
        end: end,
        prevQuickSelect: prevQuickSelect
      }), React.createElement(EuiCommonlyUsedTimeRanges, {
        applyTime: _this.applyTime,
        commonlyUsedRanges: commonlyUsedRanges
      }), React.createElement(EuiRecentlyUsed, {
        applyTime: _this.applyTime,
        commonlyUsedRanges: commonlyUsedRanges,
        dateFormat: dateFormat,
        recentlyUsedRanges: recentlyUsedRanges
      }), _this.renderCustomQuickSelectPanels());
    });

    _defineProperty(_assertThisInitialized(_this), "renderCustomQuickSelectPanels", function () {
      var customQuickSelectPanels = _this.props.customQuickSelectPanels;

      if (!customQuickSelectPanels) {
        return null;
      }

      return customQuickSelectPanels.map(function (_ref2) {
        var title = _ref2.title,
            content = _ref2.content;
        return React.createElement(Fragment, {
          key: title
        }, React.createElement(EuiTitle, {
          size: "xxxs"
        }, React.createElement("span", null, title)), React.createElement(EuiSpacer, {
          size: "s"
        }), React.createElement(EuiText, {
          size: "s",
          className: "euiQuickSelectPopover__section"
        }, React.cloneElement(content, {
          applyTime: _this.applyTime
        })), React.createElement(EuiHorizontalRule, {
          margin: "s"
        }));
      });
    });

    return _this;
  }

  _createClass(EuiQuickSelectPopover, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          applyRefreshInterval = _this$props2.applyRefreshInterval,
          isAutoRefreshOnly = _this$props2.isAutoRefreshOnly,
          isDisabled = _this$props2.isDisabled,
          isPaused = _this$props2.isPaused,
          refreshInterval = _this$props2.refreshInterval;
      var isOpen = this.state.isOpen;
      var quickSelectButton = React.createElement(EuiButtonEmpty, {
        className: "euiFormControlLayout__prepend",
        textProps: {
          className: 'euiQuickSelectPopover__buttonText'
        },
        onClick: this.togglePopover,
        "aria-label": "Date quick select",
        size: "xs",
        iconType: "arrowDown",
        iconSide: "right",
        isDisabled: isDisabled,
        "data-test-subj": "superDatePickerToggleQuickMenuButton"
      }, React.createElement(EuiIcon, {
        type: !isAutoRefreshOnly && isPaused ? 'calendar' : 'clock'
      }));
      return React.createElement(EuiPopover, {
        id: "QuickSelectPopover",
        button: quickSelectButton,
        isOpen: isOpen,
        closePopover: this.closePopover,
        anchorPosition: "downLeft",
        anchorClassName: "euiQuickSelectPopover__anchor",
        ownFocus: true
      }, React.createElement("div", {
        className: "euiQuickSelectPopover__content",
        "data-test-subj": "superDatePickerQuickMenu"
      }, this.renderDateTimeSections(), React.createElement(EuiRefreshInterval, {
        applyRefreshInterval: applyRefreshInterval,
        isPaused: isPaused,
        refreshInterval: refreshInterval
      })));
    }
  }]);

  return EuiQuickSelectPopover;
}(Component);
EuiQuickSelectPopover.propTypes = {
  applyRefreshInterval: PropTypes.func,
  applyTime: PropTypes.func.isRequired,
  commonlyUsedRanges: PropTypes.arrayOf(PropTypes.shape({
    end: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired,
    label: PropTypes.string,
    start: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired
  }).isRequired).isRequired,
  customQuickSelectPanels: PropTypes.arrayOf(PropTypes.shape({
    title: PropTypes.string.isRequired,
    content: PropTypes.element.isRequired
  }).isRequired),
  dateFormat: PropTypes.string.isRequired,
  end: PropTypes.string.isRequired,
  isAutoRefreshOnly: PropTypes.bool.isRequired,
  isDisabled: PropTypes.bool.isRequired,
  isPaused: PropTypes.bool.isRequired,
  recentlyUsedRanges: PropTypes.arrayOf(PropTypes.shape({
    end: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired,
    label: PropTypes.string,
    start: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired
  }).isRequired).isRequired,
  refreshInterval: PropTypes.number.isRequired,
  start: PropTypes.string.isRequired
};
EuiQuickSelectPopover.__docgenInfo = {
  "description": "",
  "methods": [{
    "name": "closePopover",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "togglePopover",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "applyTime",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "{\n  start,\n  end,\n  quickSelect,\n  keepPopoverOpen = false\n}",
      "type": null
    }],
    "returns": null
  }, {
    "name": "renderDateTimeSections",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "renderCustomQuickSelectPanels",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }],
  "displayName": "EuiQuickSelectPopover",
  "props": {
    "applyRefreshInterval": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    },
    "applyTime": {
      "type": {
        "name": "func"
      },
      "required": true,
      "description": ""
    },
    "commonlyUsedRanges": {
      "type": {
        "name": "arrayOf",
        "value": {
          "name": "shape",
          "value": {
            "end": {
              "name": "union",
              "value": [{
                "name": "enum",
                "value": [{
                  "value": "\"now\"",
                  "computed": false
                }]
              }, {
                "name": "string"
              }],
              "required": true
            },
            "label": {
              "name": "string",
              "required": false
            },
            "start": {
              "name": "union",
              "value": [{
                "name": "enum",
                "value": [{
                  "value": "\"now\"",
                  "computed": false
                }]
              }, {
                "name": "string"
              }],
              "required": true
            }
          }
        }
      },
      "required": true,
      "description": ""
    },
    "customQuickSelectPanels": {
      "type": {
        "name": "arrayOf",
        "value": {
          "name": "shape",
          "value": {
            "title": {
              "name": "string",
              "required": true
            },
            "content": {
              "name": "element",
              "required": true
            }
          }
        }
      },
      "required": false,
      "description": ""
    },
    "dateFormat": {
      "type": {
        "name": "string"
      },
      "required": true,
      "description": ""
    },
    "end": {
      "type": {
        "name": "string"
      },
      "required": true,
      "description": ""
    },
    "isAutoRefreshOnly": {
      "type": {
        "name": "bool"
      },
      "required": true,
      "description": ""
    },
    "isDisabled": {
      "type": {
        "name": "bool"
      },
      "required": true,
      "description": ""
    },
    "isPaused": {
      "type": {
        "name": "bool"
      },
      "required": true,
      "description": ""
    },
    "recentlyUsedRanges": {
      "type": {
        "name": "arrayOf",
        "value": {
          "name": "shape",
          "value": {
            "end": {
              "name": "union",
              "value": [{
                "name": "enum",
                "value": [{
                  "value": "\"now\"",
                  "computed": false
                }]
              }, {
                "name": "string"
              }],
              "required": true
            },
            "label": {
              "name": "string",
              "required": false
            },
            "start": {
              "name": "union",
              "value": [{
                "name": "enum",
                "value": [{
                  "value": "\"now\"",
                  "computed": false
                }]
              }, {
                "name": "string"
              }],
              "required": true
            }
          }
        }
      },
      "required": true,
      "description": ""
    },
    "refreshInterval": {
      "type": {
        "name": "number"
      },
      "required": true,
      "description": ""
    },
    "start": {
      "type": {
        "name": "string"
      },
      "required": true,
      "description": ""
    }
  }
};