function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback } from 'react';
import { EuiFormRow, EuiCodeEditor } from '@elastic/eui';
import { debounce } from 'lodash';
import { isJSON } from '../../../static/validators/string';
import { useJson } from './use_json';
export var JsonEditor = /*#__PURE__*/React.memo(function (_ref) {
  var label = _ref.label,
      helpText = _ref.helpText,
      onUpdate = _ref.onUpdate,
      value = _ref.value,
      defaultValue = _ref.defaultValue,
      euiCodeEditorProps = _ref.euiCodeEditorProps,
      propsError = _ref.error;
  var isControlled = value !== undefined;

  var _useJson = useJson({
    defaultValue: defaultValue,
    onUpdate: onUpdate,
    isControlled: isControlled
  }),
      content = _useJson.content,
      setContent = _useJson.setContent,
      internalError = _useJson.error;

  var debouncedSetContent = useCallback(debounce(setContent, 300), [setContent]); // We let the consumer control the validation and the error message.

  var error = isControlled ? propsError : internalError;
  var onEuiCodeEditorChange = useCallback(function (updated) {
    if (isControlled) {
      onUpdate({
        data: {
          raw: updated,
          format: function format() {
            return JSON.parse(updated);
          }
        },
        validate: function validate() {
          return isJSON(updated);
        },
        isValid: undefined
      });
    } else {
      debouncedSetContent(updated);
    }
  }, [isControlled]);
  return /*#__PURE__*/React.createElement(EuiFormRow, {
    label: label,
    helpText: helpText,
    isInvalid: typeof error === 'string',
    error: error,
    fullWidth: true
  }, /*#__PURE__*/React.createElement(EuiCodeEditor, _extends({
    mode: "json",
    theme: "textmate",
    width: "100%",
    height: "500px",
    setOptions: {
      showLineNumbers: false,
      tabSize: 2
    },
    editorProps: {
      $blockScrolling: Infinity
    },
    showGutter: false,
    minLines: 6,
    value: isControlled ? value : content,
    onChange: onEuiCodeEditorChange
  }, euiCodeEditorProps)));
});