/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiCallOut, EuiTextColor, EuiLink, EuiButton } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
export var EmptyState = function EmptyState(_ref) {
  var onRefresh = _ref.onRefresh,
      prependBasePath = _ref.prependBasePath;
  return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(EuiCallOut, {
    color: "warning",
    title: /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "indexPatternManagement.createIndexPattern.emptyStateHeader",
      defaultMessage: "Couldn't find any Elasticsearch data"
    })
  }, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.createIndexPattern.emptyStateLabel.emptyStateDetail",
    defaultMessage: "{needToIndex} {learnHowLink} or {getStartedLink}",
    values: {
      needToIndex: /*#__PURE__*/React.createElement(EuiTextColor, {
        color: "subdued"
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.createIndexPattern.emptyStateLabel.needToIndexLabel",
        defaultMessage: "You'll need to index some data into Elasticsearch before you can create an index pattern."
      })),
      learnHowLink: /*#__PURE__*/React.createElement(EuiLink, {
        href: prependBasePath('/app/home#/tutorial_directory')
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.createIndexPattern.emptyStateLabel.learnHowLink",
        defaultMessage: "Learn how"
      })),
      getStartedLink: /*#__PURE__*/React.createElement(EuiLink, {
        href: prependBasePath('/app/home#/tutorial_directory/sampleData')
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.createIndexPattern.emptyStateLabel.getStartedLink",
        defaultMessage: "get started with some sample data sets."
      }))
    }
  })), /*#__PURE__*/React.createElement(EuiButton, {
    iconType: "refresh",
    onClick: onRefresh,
    "data-test-subj": "refreshIndicesButton",
    color: "warning"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.createIndexPattern.emptyState.checkDataButton",
    defaultMessage: "Check for new data"
  }))));
};