function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Fragment } from 'react';
import { EuiBasicTable, EuiButton, EuiColorPicker, EuiFieldText, EuiSpacer } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { DefaultFormatEditor } from '../default';
import { fieldFormats } from '../../../../../../../../../plugins/data/public';
export var ColorFormatEditor = /*#__PURE__*/function (_DefaultFormatEditor) {
  _inherits(ColorFormatEditor, _DefaultFormatEditor);

  var _super = _createSuper(ColorFormatEditor);

  function ColorFormatEditor(props) {
    var _this;

    _classCallCheck(this, ColorFormatEditor);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "onColorChange", function (newColorParams, index) {
      var colors = _toConsumableArray(_this.props.formatParams.colors);

      colors[index] = _objectSpread(_objectSpread({}, colors[index]), newColorParams);

      _this.onChange({
        colors: colors
      });
    });

    _defineProperty(_assertThisInitialized(_this), "addColor", function () {
      var colors = _toConsumableArray(_this.props.formatParams.colors);

      _this.onChange({
        colors: [].concat(_toConsumableArray(colors), [_objectSpread({}, fieldFormats.DEFAULT_CONVERTER_COLOR)])
      });
    });

    _defineProperty(_assertThisInitialized(_this), "removeColor", function (index) {
      var colors = _toConsumableArray(_this.props.formatParams.colors);

      colors.splice(index, 1);

      _this.onChange({
        colors: colors
      });
    });

    _this.onChange({
      fieldType: props.fieldType
    });

    return _this;
  }

  _createClass(ColorFormatEditor, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          formatParams = _this$props.formatParams,
          fieldType = _this$props.fieldType;
      var items = formatParams.colors && formatParams.colors.length && formatParams.colors.map(function (color, index) {
        return _objectSpread(_objectSpread({}, color), {}, {
          index: index
        });
      }) || [];
      var columns = [fieldType === 'string' ? {
        field: 'regex',
        name: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.color.patternLabel",
          defaultMessage: "Pattern (regular expression)"
        }),
        render: function render(value, item) {
          return /*#__PURE__*/React.createElement(EuiFieldText, {
            value: value,
            onChange: function onChange(e) {
              _this2.onColorChange({
                regex: e.target.value
              }, item.index);
            }
          });
        }
      } : {
        field: 'range',
        name: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.color.rangeLabel",
          defaultMessage: "Range (min:max)"
        }),
        render: function render(value, item) {
          return /*#__PURE__*/React.createElement(EuiFieldText, {
            value: value,
            onChange: function onChange(e) {
              _this2.onColorChange({
                range: e.target.value
              }, item.index);
            }
          });
        }
      }, {
        field: 'text',
        name: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.color.textColorLabel",
          defaultMessage: "Text color"
        }),
        render: function render(color, item) {
          return /*#__PURE__*/React.createElement(EuiColorPicker, {
            color: color,
            onChange: function onChange(newColor) {
              _this2.onColorChange({
                text: newColor
              }, item.index);
            }
          });
        }
      }, {
        field: 'background',
        name: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.color.backgroundLabel",
          defaultMessage: "Background color"
        }),
        render: function render(color, item) {
          return /*#__PURE__*/React.createElement(EuiColorPicker, {
            color: color,
            onChange: function onChange(newColor) {
              _this2.onColorChange({
                background: newColor
              }, item.index);
            }
          });
        }
      }, {
        name: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.color.exampleLabel",
          defaultMessage: "Example"
        }),
        render: function render(item) {
          return /*#__PURE__*/React.createElement("div", {
            style: {
              background: item.background,
              color: item.text
            }
          }, "123456");
        }
      }, {
        field: 'actions',
        name: i18n.translate('indexPatternManagement.color.actions', {
          defaultMessage: 'Actions'
        }),
        actions: [{
          name: i18n.translate('indexPatternManagement.color.deleteAria', {
            defaultMessage: 'Delete'
          }),
          description: i18n.translate('indexPatternManagement.color.deleteTitle', {
            defaultMessage: 'Delete color format'
          }),
          onClick: function onClick(item) {
            _this2.removeColor(item.index);
          },
          type: 'icon',
          icon: 'trash',
          color: 'danger',
          available: function available() {
            return items.length > 1;
          }
        }]
      }];
      return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiBasicTable, {
        items: items,
        columns: columns
      }), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/React.createElement(EuiButton, {
        iconType: "plusInCircle",
        size: "s",
        onClick: this.addColor
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.color.addColorButton",
        defaultMessage: "Add color"
      })), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "l"
      }));
    }
  }]);

  return ColorFormatEditor;
}(DefaultFormatEditor);

_defineProperty(ColorFormatEditor, "formatId", 'color');