function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useMemo, useState, useCallback, useEffect } from 'react';
import { get, isEqual } from 'lodash';
import { i18n } from '@kbn/i18n';
import { keys, EuiButtonIcon, EuiFlexGroup, EuiFlexItem } from '@elastic/eui';
import { DefaultEditorNavBar } from './navbar';
import { DefaultEditorControls } from './controls';
import { setStateParamValue, useEditorReducer, useEditorFormState, discardChanges } from './state';
import { SidebarTitle } from './sidebar_title';

function DefaultEditorSideBar(_ref) {
  var embeddableHandler = _ref.embeddableHandler,
      isCollapsed = _ref.isCollapsed,
      onClickCollapse = _ref.onClickCollapse,
      optionTabs = _ref.optionTabs,
      uiState = _ref.uiState,
      vis = _ref.vis,
      isLinkedSearch = _ref.isLinkedSearch,
      eventEmitter = _ref.eventEmitter,
      savedSearch = _ref.savedSearch,
      timeRange = _ref.timeRange;

  var _useState = useState(optionTabs[0].name),
      _useState2 = _slicedToArray(_useState, 2),
      selectedTab = _useState2[0],
      setSelectedTab = _useState2[1];

  var _useState3 = useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      isDirty = _useState4[0],
      setDirty = _useState4[1];

  var _useEditorReducer = useEditorReducer(vis, eventEmitter),
      _useEditorReducer2 = _slicedToArray(_useEditorReducer, 2),
      state = _useEditorReducer2[0],
      dispatch = _useEditorReducer2[1];

  var _useEditorFormState = useEditorFormState(),
      formState = _useEditorFormState.formState,
      setTouched = _useEditorFormState.setTouched,
      setValidity = _useEditorFormState.setValidity,
      resetValidity = _useEditorFormState.resetValidity;

  var responseAggs = useMemo(function () {
    return state.data.aggs ? state.data.aggs.getResponseAggs() : [];
  }, [state.data.aggs]);
  var metricSchemas = (vis.type.schemas.metrics || []).map(function (s) {
    return s.name;
  });
  var metricAggs = useMemo(function () {
    return responseAggs.filter(function (agg) {
      return metricSchemas.includes(get(agg, 'schema'));
    });
  }, [responseAggs, metricSchemas]);
  var hasHistogramAgg = useMemo(function () {
    return responseAggs.some(function (agg) {
      return agg.type.name === 'histogram';
    });
  }, [responseAggs]);
  var setStateValidity = useCallback(function (value) {
    setValidity('visOptions', value);
  }, [setValidity]);
  var setStateValue = useCallback(function (paramName, value) {
    var shouldUpdate = !isEqual(state.params[paramName], value);

    if (shouldUpdate) {
      dispatch(setStateParamValue(paramName, value));
    }
  }, [dispatch, state.params]);
  var applyChanges = useCallback(function () {
    if (formState.invalid || !isDirty) {
      setTouched(true);
      return;
    }

    vis.setState(_objectSpread(_objectSpread({}, vis.serialize()), {}, {
      params: state.params,
      data: {
        aggs: state.data.aggs ? state.data.aggs.aggs.map(function (agg) {
          return agg.toJSON();
        }) : []
      }
    }));
    embeddableHandler.reload();
    eventEmitter.emit('dirtyStateChange', {
      isDirty: false
    });
    setTouched(false);
  }, [vis, state, formState.invalid, setTouched, isDirty, eventEmitter, embeddableHandler]);
  var onSubmit = useCallback(function (event) {
    if (event.ctrlKey && event.key === keys.ENTER) {
      event.preventDefault();
      event.stopPropagation();
      applyChanges();
    }
  }, [applyChanges]);
  useEffect(function () {
    var changeHandler = function changeHandler(_ref2) {
      var dirty = _ref2.isDirty;
      setDirty(dirty);

      if (!dirty) {
        resetValidity();
      }
    };

    eventEmitter.on('dirtyStateChange', changeHandler);
    return function () {
      eventEmitter.off('dirtyStateChange', changeHandler);
    };
  }, [resetValidity, eventEmitter]); // subscribe on external vis changes using browser history, for example press back button

  useEffect(function () {
    var resetHandler = function resetHandler() {
      return dispatch(discardChanges(vis));
    };

    eventEmitter.on('updateEditor', resetHandler);
    return function () {
      eventEmitter.off('updateEditor', resetHandler);
    };
  }, [dispatch, vis, eventEmitter]);
  var dataTabProps = {
    dispatch: dispatch,
    formIsTouched: formState.touched,
    metricAggs: metricAggs,
    state: state,
    schemas: vis.type.schemas,
    setValidity: setValidity,
    setTouched: setTouched,
    setStateValue: setStateValue
  };
  var optionTabProps = {
    aggs: state.data.aggs,
    hasHistogramAgg: hasHistogramAgg,
    stateParams: state.params,
    vis: vis,
    uiState: uiState,
    setValue: setStateValue,
    setValidity: setStateValidity,
    setTouched: setTouched
  };
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiFlexGroup, {
    className: "visEditorSidebar",
    direction: "column",
    justifyContent: "spaceBetween",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    className: "visEditorSidebar__formWrapper"
  }, /*#__PURE__*/React.createElement("form", {
    className: "visEditorSidebar__form",
    name: "visualizeEditor",
    onKeyDownCapture: onSubmit
  }, vis.type.requiresSearch && /*#__PURE__*/React.createElement(SidebarTitle, {
    isLinkedSearch: isLinkedSearch,
    savedSearch: savedSearch,
    vis: vis,
    eventEmitter: eventEmitter
  }), optionTabs.length > 1 && /*#__PURE__*/React.createElement(DefaultEditorNavBar, {
    optionTabs: optionTabs,
    selectedTab: selectedTab,
    setSelectedTab: setSelectedTab
  }), optionTabs.map(function (_ref3) {
    var Editor = _ref3.editor,
        name = _ref3.name;
    var isTabSelected = selectedTab === name;
    return /*#__PURE__*/React.createElement("div", {
      key: name,
      className: "visEditorSidebar__config ".concat(isTabSelected ? '' : 'visEditorSidebar__config-isHidden')
    }, /*#__PURE__*/React.createElement(Editor, _extends({
      isTabSelected: isTabSelected
    }, name === 'data' ? dataTabProps : optionTabProps, {
      timeRange: timeRange
    })));
  }))), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(DefaultEditorControls, {
    applyChanges: applyChanges,
    dispatch: dispatch,
    isDirty: isDirty,
    isTouched: formState.touched,
    isInvalid: formState.invalid,
    vis: vis
  }))), /*#__PURE__*/React.createElement(EuiButtonIcon, {
    "aria-expanded": !isCollapsed,
    "aria-label": i18n.translate('visDefaultEditor.sidebar.collapseButtonAriaLabel', {
      defaultMessage: 'Toggle sidebar'
    }),
    className: "visEditor__collapsibleSidebarButton",
    "data-test-subj": "collapseSideBarButton",
    color: "text",
    iconType: isCollapsed ? 'menuLeft' : 'menuRight',
    onClick: onClickCollapse
  }));
}

export { DefaultEditorSideBar };