function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback } from 'react';
import { EuiPanel, EuiTitle, EuiColorPicker, EuiFormRow, EuiSpacer } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { SelectOption, SwitchOption, RequiredNumberInputOption } from '../../../../../charts/public';

function ThresholdPanel(_ref) {
  var stateParams = _ref.stateParams,
      setValue = _ref.setValue,
      setMultipleValidity = _ref.setMultipleValidity,
      vis = _ref.vis;
  var setThresholdLine = useCallback(function (paramName, value) {
    return setValue('thresholdLine', _objectSpread(_objectSpread({}, stateParams.thresholdLine), {}, _defineProperty({}, paramName, value)));
  }, [stateParams.thresholdLine, setValue]);
  var setThresholdLineColor = useCallback(function (value) {
    return setThresholdLine('color', value);
  }, [setThresholdLine]);
  var setThresholdLineValidity = useCallback(function (paramName, isValid) {
    return setMultipleValidity("thresholdLine__".concat(paramName), isValid);
  }, [setMultipleValidity]);
  return /*#__PURE__*/React.createElement(EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visTypeVislib.editors.pointSeries.thresholdLineSettingsTitle",
    defaultMessage: "Threshold line"
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('visTypeVislib.editors.pointSeries.thresholdLine.showLabel', {
      defaultMessage: 'Show threshold line'
    }),
    paramName: "show",
    value: stateParams.thresholdLine.show,
    setValue: setThresholdLine
  }), stateParams.thresholdLine.show && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(RequiredNumberInputOption, {
    label: i18n.translate('visTypeVislib.editors.pointSeries.thresholdLine.valueLabel', {
      defaultMessage: 'Threshold value'
    }),
    paramName: "value",
    value: stateParams.thresholdLine.value,
    setValue: setThresholdLine,
    setValidity: setThresholdLineValidity
  }), /*#__PURE__*/React.createElement(RequiredNumberInputOption, {
    label: i18n.translate('visTypeVislib.editors.pointSeries.thresholdLine.widthLabel', {
      defaultMessage: 'Line width'
    }),
    paramName: "width",
    min: 1,
    step: 1,
    value: stateParams.thresholdLine.width,
    setValue: setThresholdLine,
    setValidity: setThresholdLineValidity
  }), /*#__PURE__*/React.createElement(SelectOption, {
    label: i18n.translate('visTypeVislib.editors.pointSeries.thresholdLine.styleLabel', {
      defaultMessage: 'Line style'
    }),
    options: vis.type.editorConfig.collections.thresholdLineStyles,
    paramName: "style",
    value: stateParams.thresholdLine.style,
    setValue: setThresholdLine
  }), /*#__PURE__*/React.createElement(EuiFormRow, {
    label: i18n.translate('visTypeVislib.editors.pointSeries.thresholdLine.colorLabel', {
      defaultMessage: 'Line color'
    }),
    fullWidth: true,
    compressed: true
  }, /*#__PURE__*/React.createElement(EuiColorPicker, {
    compressed: true,
    color: stateParams.thresholdLine.color,
    fullWidth: true,
    onChange: setThresholdLineColor
  }))));
}

export { ThresholdPanel };