/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util;

import com.sun.opengl.util.Animator;
import java.util.Timer;
import java.util.TimerTask;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLException;

public class FPSAnimator
extends Animator {
    private Timer timer;
    private int fps;
    private boolean scheduleAtFixedRate;

    public FPSAnimator(int n) {
        this(null, n);
    }

    public FPSAnimator(int n, boolean bl) {
        this(null, n, bl);
    }

    public FPSAnimator(GLAutoDrawable gLAutoDrawable, int n) {
        this(gLAutoDrawable, n, false);
    }

    public FPSAnimator(GLAutoDrawable gLAutoDrawable, int n, boolean bl) {
        this.fps = n;
        if (gLAutoDrawable != null) {
            this.add(gLAutoDrawable);
        }
        this.scheduleAtFixedRate = bl;
    }

    public synchronized void start() {
        if (this.timer != null) {
            throw new GLException("Already started");
        }
        this.timer = new Timer();
        long l = (long)(1000.0f / (float)this.fps);
        TimerTask timerTask = new TimerTask(){

            public void run() {
                FPSAnimator.this.display();
            }
        };
        if (this.scheduleAtFixedRate) {
            this.timer.scheduleAtFixedRate(timerTask, 0L, l);
        } else {
            this.timer.schedule(timerTask, 0L, l);
        }
    }

    public synchronized boolean isAnimating() {
        return this.timer != null;
    }

    public synchronized void stop() {
        if (this.timer == null) {
            throw new GLException("Already stopped");
        }
        this.timer.cancel();
        this.timer = null;
    }
}

