/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.search.Query;
import org.apache.solr.search.ExtendedQuery;

public abstract class ExtendedQueryBase
extends Query
implements ExtendedQuery {
    private int cost;
    private boolean cache = true;
    private boolean cacheSep;

    @Override
    public void setCache(boolean cache) {
        this.cache = cache;
    }

    @Override
    public boolean getCache() {
        return this.cache;
    }

    @Override
    public void setCacheSep(boolean cacheSep) {
        this.cacheSep = cacheSep;
    }

    @Override
    public boolean getCacheSep() {
        return this.cacheSep;
    }

    @Override
    public void setCost(int cost) {
        this.cost = cost;
    }

    @Override
    public int getCost() {
        return this.cost;
    }

    public String getOptions() {
        return ExtendedQueryBase.getOptionsString(this);
    }

    public static String getOptionsString(ExtendedQuery q) {
        StringBuilder sb = new StringBuilder();
        if (!q.getCache()) {
            sb.append("{!cache=false");
            int cost = q.getCost();
            if (cost != 0) {
                sb.append(" cost=");
                sb.append(q.getCost());
            }
            sb.append("}");
        } else if (q.getCacheSep()) {
            sb.append("{!cache=sep");
            sb.append("}");
        }
        return sb.toString();
    }

    public String toString(String field) {
        return this.getOptions();
    }
}

