/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.Writer;
import org.apache.solr.common.SolrException;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.GeoJSONWriter;
import org.apache.solr.response.JSONResponseWriter;
import org.apache.solr.response.JSONWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.AbstractSpatialFieldType;
import org.apache.solr.schema.SchemaField;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.io.SupportedFormats;

public class GeoJSONResponseWriter
extends JSONResponseWriter {
    public static final String FIELD = "geojson.field";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        String geofield = req.getParams().get(FIELD, null);
        if (geofield == null || geofield.length() == 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "GeoJSON.  Missing parameter: 'geojson.field'");
        }
        SchemaField sf = req.getSchema().getFieldOrNull(geofield);
        if (sf == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "GeoJSON.  Unknown field: 'geojson.field'=" + geofield);
        }
        SupportedFormats formats = null;
        if (sf.getType() instanceof AbstractSpatialFieldType) {
            SpatialContext ctx = ((AbstractSpatialFieldType)sf.getType()).getSpatialContext();
            formats = ctx.getFormats();
        }
        try (GeoJSONWriter w = new GeoJSONWriter(writer, req, rsp, geofield, formats);){
            ((JSONWriter)w).writeResponse();
        }
    }
}

